/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.table;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleColoredRenderer;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.impl.CommonUiProperties;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.statistics.VcsLogUsageTriggerCollector;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.table.VcsLogCellController;
import com.intellij.vcs.log.ui.table.VcsLogCellRenderer;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import com.intellij.vcs.log.util.VcsLogUiUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.util.Objects;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class RootCellRenderer
extends SimpleColoredRenderer
implements TableCellRenderer,
VcsLogCellRenderer {
    @NotNull
    private final VcsLogUiProperties myProperties;
    @NotNull
    private final VcsLogColorManager myColorManager;
    @NotNull
    private Color myColor = UIUtil.getTableBackground();
    @NotNull
    private Color myBorderColor = UIUtil.getTableBackground();
    private boolean isNarrow = true;

    RootCellRenderer(@NotNull VcsLogUiProperties properties, @NotNull VcsLogColorManager colorManager) {
        this.myProperties = properties;
        this.myColorManager = colorManager;
        this.setTextAlign(0);
    }

    protected void paintBackground(Graphics2D g, int x, int width, int height) {
        g.setColor(this.myColor);
        if (this.isNarrow) {
            g.fillRect(x, 0, width - JBUIScale.scale((int)5), height);
            g.setColor(this.myBorderColor);
            g.fillRect(x + width - JBUIScale.scale((int)5), 0, JBUIScale.scale((int)5), height);
        } else {
            g.fillRect(x, 0, width, height);
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row2, int column) {
        this.clear();
        FilePath path2 = (FilePath)value;
        this.myColor = path2 == null ? UIUtil.getTableBackground((boolean)isSelected, (boolean)hasFocus) : VcsLogGraphTable.getPathBackgroundColor(path2, this.myColorManager);
        this.myBorderColor = Objects.requireNonNull(((VcsLogGraphTable)((Object)table)).getStyle(row2, column, hasFocus, isSelected).getBackground());
        this.setForeground(UIUtil.getTableForeground((boolean)false, (boolean)hasFocus));
        if (this.myProperties.exists(CommonUiProperties.SHOW_ROOT_NAMES) && this.myProperties.get(CommonUiProperties.SHOW_ROOT_NAMES).booleanValue()) {
            if (RootCellRenderer.isTextShown(table, value, row2, column)) {
                if (path2 == null) {
                    this.append("");
                } else {
                    String text2 = path2.getName();
                    int availableWidth = ((VcsLogGraphTable)((Object)table)).getRootColumn().getWidth() - VcsLogUiUtil.getHorizontalTextPadding((SimpleColoredComponent)this);
                    text2 = VcsLogUiUtil.shortenTextToFit(text2, this.getFontMetrics(VcsLogGraphTable.getTableFont()), availableWidth, 0, "\u2026");
                    this.append(text2);
                }
            }
            this.isNarrow = false;
        } else {
            this.append("");
            this.isNarrow = true;
        }
        return this;
    }

    @Override
    @NotNull
    public VcsLogCellController getCellController() {
        return new VcsLogCellController(){

            @Override
            @Nullable
            public Cursor performMouseClick(int row2, @NotNull MouseEvent e) {
                if (RootCellRenderer.this.myColorManager.hasMultiplePaths() && RootCellRenderer.this.myProperties.exists(CommonUiProperties.SHOW_ROOT_NAMES)) {
                    VcsLogUsageTriggerCollector.triggerClick("root.column");
                    RootCellRenderer.this.myProperties.set(CommonUiProperties.SHOW_ROOT_NAMES, RootCellRenderer.this.myProperties.get(CommonUiProperties.SHOW_ROOT_NAMES) == false);
                }
                return null;
            }

            @Override
            @NotNull
            public Cursor performMouseMove(int row2, @NotNull MouseEvent e) {
                return Cursor.getPredefinedCursor(12);
            }
        };
    }

    private static boolean isTextShown(JTable table, Object value, int row2, int column) {
        int readableRow = ScrollingUtil.getReadableRow((JTable)table, (int)Math.round((float)table.getRowHeight() * 0.5f));
        if (row2 < readableRow) {
            return false;
        }
        return row2 == 0 || readableRow == row2 || !Objects.equals(value, table.getModel().getValueAt(row2 - 1, column));
    }

    public void setBackground(Color bg) {
        this.myBorderColor = bg;
    }
}

