/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.frame;

import com.google.common.primitives.Ints;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Anchor;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.JBColor;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.table.ComponentsListFocusTraversalPolicy;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.DataPackBase;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.impl.CommonUiProperties;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.ui.AbstractVcsLogUi;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import com.intellij.vcs.log.ui.actions.IntelliSortChooserPopupAction;
import com.intellij.vcs.log.ui.filter.VcsLogFilterUiEx;
import com.intellij.vcs.log.ui.frame.FrameDiffPreview;
import com.intellij.vcs.log.ui.frame.VcsLogChangeProcessor;
import com.intellij.vcs.log.ui.frame.VcsLogChangesBrowser;
import com.intellij.vcs.log.ui.frame.VcsLogCommitDetailsListPanel;
import com.intellij.vcs.log.ui.table.CommitSelectionListener;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import com.intellij.vcs.log.util.BekUtil;
import com.intellij.vcs.log.util.VcsLogUiUtil;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.VisiblePack;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FocusTraversalPolicy;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MainFrame
extends JPanel
implements DataProvider,
Disposable {
    private static final String DIFF_SPLITTER_PROPORTION = "vcs.log.diff.splitter.proportion";
    private static final String DETAILS_SPLITTER_PROPORTION = "vcs.log.details.splitter.proportion";
    private static final String CHANGES_SPLITTER_PROPORTION = "vcs.log.changes.splitter.proportion";
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final MainVcsLogUiProperties myUiProperties;
    @NotNull
    private final JComponent myToolbar;
    @NotNull
    private final VcsLogGraphTable myGraphTable;
    @NotNull
    private final VcsLogFilterUiEx myFilterUi;
    @NotNull
    private final VcsLogChangesBrowser myChangesBrowser;
    @NotNull
    private final Splitter myChangesBrowserSplitter;
    @NotNull
    private final VcsLogCommitDetailsListPanel myDetailsPanel;
    @NotNull
    private final Splitter myDetailsSplitter;
    @NotNull
    private final EditorNotificationPanel myNotificationLabel;
    @Nullable
    private final FrameDiffPreview<VcsLogChangeProcessor> myDiffPreview;

    public MainFrame(@NotNull VcsLogData logData, final @NotNull AbstractVcsLogUi logUi, @NotNull MainVcsLogUiProperties uiProperties, @NotNull VcsLogFilterUiEx filterUi, boolean withDiffPreview, @NotNull Disposable disposable) {
        this.myLogData = logData;
        this.myUiProperties = uiProperties;
        this.myFilterUi = filterUi;
        this.myGraphTable = new MyVcsLogGraphTable(logUi.getId(), logData, logUi.getProperties(), logUi.getColorManager(), () -> logUi.getRefresher().onRefresh(), (Consumer<Runnable>)((Consumer)logUi::requestMore), disposable);
        this.myGraphTable.setCompactReferencesView(this.myUiProperties.get(MainVcsLogUiProperties.COMPACT_REFERENCES_VIEW));
        this.myGraphTable.setShowTagNames(this.myUiProperties.get(MainVcsLogUiProperties.SHOW_TAG_NAMES));
        this.myGraphTable.setLabelsLeftAligned(this.myUiProperties.get(MainVcsLogUiProperties.LABELS_LEFT_ALIGNED));
        PopupHandler.installPopupHandler((JComponent)((Object)this.myGraphTable), (String)"Vcs.Log.ContextMenu", (String)"Vcs.Log.ContextMenu");
        this.myDetailsPanel = new VcsLogCommitDetailsListPanel(logData, logUi.getColorManager(), this){

            @Override
            protected void navigate(@NotNull CommitId commit) {
                logUi.jumpToCommit(commit.getHash(), commit.getRoot());
            }
        };
        this.myChangesBrowser = new VcsLogChangesBrowser(logData.getProject(), this.myUiProperties, (Function<? super CommitId, ? extends VcsShortCommitDetails>)((Function)commitId -> {
            int index = this.myLogData.getCommitIndex(commitId.getHash(), commitId.getRoot());
            return this.myLogData.getMiniDetailsGetter().getCommitData(index, Collections.singleton(index));
        }), this);
        this.myChangesBrowser.getDiffAction().registerCustomShortcutSet(this.myChangesBrowser.getDiffAction().getShortcutSet(), (JComponent)((Object)this.getGraphTable()));
        JBLoadingPanel changesLoadingPane = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)this, 300);
        changesLoadingPane.add((Component)this.myChangesBrowser);
        this.myToolbar = this.createActionsToolbar();
        this.myChangesBrowser.setToolbarHeightReferent(this.myToolbar);
        MyCommitSelectionListenerForDiff listenerForDiff = new MyCommitSelectionListenerForDiff(changesLoadingPane);
        this.myGraphTable.getSelectionModel().addListSelectionListener(listenerForDiff);
        Disposer.register((Disposable)this, () -> this.myGraphTable.getSelectionModel().removeListSelectionListener(listenerForDiff));
        this.myDetailsPanel.installCommitSelectionListener(this.myGraphTable);
        VcsLogUiUtil.installDetailsListeners(this.myGraphTable, this.myDetailsPanel, this.myLogData, this);
        this.myNotificationLabel = new EditorNotificationPanel(UIUtil.getPanelBackground());
        this.myNotificationLabel.setVisible(false);
        this.myNotificationLabel.setBorder((Border)new CompoundBorder(JBUI.Borders.customLine((Color)JBColor.border(), (int)1, (int)0, (int)0, (int)0), (Border)ObjectUtils.notNull((Object)this.myNotificationLabel.getBorder(), (Object)JBUI.Borders.empty())));
        JPanel toolbars = new JPanel(new BorderLayout());
        toolbars.add((Component)this.myToolbar, "North");
        toolbars.add((Component)this.myNotificationLabel, "Center");
        JPanel toolbarsAndTable = new JPanel(new BorderLayout());
        toolbarsAndTable.add((Component)toolbars, "North");
        toolbarsAndTable.add((Component)VcsLogUiUtil.installProgress(VcsLogUiUtil.setupScrolledGraph(this.myGraphTable, 2), this.myLogData, logUi.getId(), this), "Center");
        this.myDetailsSplitter = new OnePixelSplitter(true, DETAILS_SPLITTER_PROPORTION, 0.7f);
        this.myDetailsSplitter.setFirstComponent((JComponent)changesLoadingPane);
        this.showDetails(this.myUiProperties.get(CommonUiProperties.SHOW_DETAILS));
        this.myChangesBrowserSplitter = new OnePixelSplitter(false, CHANGES_SPLITTER_PROPORTION, 0.7f);
        this.myChangesBrowserSplitter.setFirstComponent((JComponent)toolbarsAndTable);
        this.myChangesBrowserSplitter.setSecondComponent((JComponent)this.myDetailsSplitter);
        this.setLayout(new BorderLayout());
        if (withDiffPreview) {
            this.myDiffPreview = new FrameDiffPreview<VcsLogChangeProcessor>(this.createDiffPreview(false, this.myChangesBrowser), (VcsLogUiProperties)this.myUiProperties, (JComponent)this.myChangesBrowserSplitter, DIFF_SPLITTER_PROPORTION, this.myUiProperties.get(MainVcsLogUiProperties.DIFF_PREVIEW_VERTICAL_SPLIT).booleanValue(), 0.7f){

                @Override
                public void updatePreview(boolean state) {
                    ((VcsLogChangeProcessor)this.getPreviewDiff()).updatePreview(state);
                }
            };
            this.add(this.myDiffPreview.getMainComponent());
        } else {
            this.myDiffPreview = null;
            this.add((Component)this.myChangesBrowserSplitter);
        }
        Disposer.register((Disposable)disposable, (Disposable)this);
        this.myGraphTable.resetDefaultFocusTraversalKeys();
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy((FocusTraversalPolicy)((Object)new MyFocusPolicy()));
    }

    @NotNull
    public VcsLogChangeProcessor createDiffPreview(boolean isInEditor, @NotNull Disposable parent) {
        VcsLogChangeProcessor processor = new VcsLogChangeProcessor(this.myLogData.getProject(), this.myChangesBrowser, isInEditor, parent);
        if (!isInEditor) {
            processor.getToolbarWrapper().setVerticalSizeReferent(this.getToolbar());
        }
        return processor;
    }

    public void setExplanationHtml(@Nullable String text2) {
        this.myNotificationLabel.setText(text2);
        this.myNotificationLabel.setVisible(text2 != null);
    }

    public void updateDataPack(@NotNull VisiblePack dataPack, boolean permGraphChanged) {
        this.myFilterUi.updateDataPack(dataPack);
        this.myGraphTable.updateDataPack(dataPack, permGraphChanged);
        this.myChangesBrowser.setAffectedPaths(VcsLogUtil.getAffectedPaths(dataPack));
    }

    @NotNull
    public VcsLogGraphTable getGraphTable() {
        return this.myGraphTable;
    }

    @NotNull
    public VcsLogFilterUiEx getFilterUi() {
        return this.myFilterUi;
    }

    @NotNull
    private JComponent createActionsToolbar() {
        DefaultActionGroup toolbarGroup = new DefaultActionGroup();
        toolbarGroup.copyFromGroup((DefaultActionGroup)ActionManager.getInstance().getAction("Vcs.Log.Toolbar.Internal"));
        if (BekUtil.isBekEnabled()) {
            Constraints constraint = new Constraints(Anchor.BEFORE, "Vcs.Log.PresentationSettings");
            if (BekUtil.isLinearBekEnabled()) {
                toolbarGroup.add((AnAction)new IntelliSortChooserPopupAction(), constraint);
            } else {
                toolbarGroup.add(ActionManager.getInstance().getAction("Vcs.Log.IntelliSortChooser"), constraint);
            }
        }
        DefaultActionGroup mainGroup = new DefaultActionGroup();
        mainGroup.add(ActionManager.getInstance().getAction("Vcs.Log.TextFilterSettings"));
        mainGroup.add((AnAction)new Separator());
        mainGroup.add((AnAction)this.myFilterUi.createActionGroup());
        mainGroup.addSeparator();
        mainGroup.add((AnAction)toolbarGroup);
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("Vcs.Log.Toolbar", (ActionGroup)mainGroup, true);
        toolbar.setTargetComponent((JComponent)this);
        Wrapper textFilter = new Wrapper((JComponent)this.myFilterUi.getTextFilterComponent());
        textFilter.setVerticalSizeReferent(toolbar.getComponent());
        DefaultActionGroup rightCornerGroup = new DefaultActionGroup(new AnAction[]{ActionManager.getInstance().getAction("Vcs.Log.Toolbar.RightCorner")});
        ActionToolbar rightCornerToolbar = ActionManager.getInstance().createActionToolbar("Vcs.Log.Toolbar", (ActionGroup)rightCornerGroup, true);
        rightCornerToolbar.setTargetComponent((JComponent)this);
        rightCornerToolbar.setReservePlaceAutoPopupIcon(false);
        rightCornerToolbar.setLayoutPolicy(0);
        JPanel panel2 = new JPanel((LayoutManager)new MigLayout("ins 0, fill", "[left]0[left, fill]push[pref:pref, right]", "center"));
        GuiUtils.installVisibilityReferent((JComponent)panel2, (JComponent)toolbar.getComponent());
        panel2.add((Component)textFilter);
        panel2.add(toolbar.getComponent());
        panel2.add(rightCornerToolbar.getComponent());
        return panel2;
    }

    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (VcsDataKeys.CHANGES.is(dataId) || VcsDataKeys.SELECTED_CHANGES.is(dataId)) {
            return this.myChangesBrowser.getDirectChanges().toArray(new Change[0]);
        }
        if (VcsLogInternalDataKeys.LOG_UI_PROPERTIES.is(dataId)) {
            return this.myUiProperties;
        }
        if (CommonDataKeys.VIRTUAL_FILE_ARRAY.is(dataId)) {
            Collection<VirtualFile> roots = this.getSelectedRoots();
            return VfsUtilCore.toVirtualFileArray(roots);
        }
        if (VcsLogInternalDataKeys.LOG_DIFF_HANDLER.is(dataId)) {
            Collection<VirtualFile> roots = this.getSelectedRoots();
            if (roots.size() != 1) {
                return null;
            }
            return this.myLogData.getLogProvider((VirtualFile)Objects.requireNonNull(ContainerUtil.getFirstItem(roots))).getDiffHandler();
        }
        return null;
    }

    @NotNull
    private Collection<VirtualFile> getSelectedRoots() {
        Collection<VirtualFile> roots = this.myLogData.getRoots();
        if (roots.size() == 1) {
            return roots;
        }
        int[] selectedRows = this.myGraphTable.getSelectedRows();
        if (selectedRows.length == 0 || selectedRows.length > 1000) {
            return VcsLogUtil.getAllVisibleRoots(roots, this.myFilterUi.getFilters());
        }
        return ContainerUtil.map2Set((Collection)Ints.asList((int[])selectedRows), row2 -> this.myGraphTable.getModel().getRootAtRow((int)row2));
    }

    @NotNull
    public JComponent getToolbar() {
        return this.myToolbar;
    }

    @NotNull
    public VcsLogChangesBrowser getChangesBrowser() {
        return this.myChangesBrowser;
    }

    public void showDetails(boolean state) {
        this.myDetailsSplitter.setSecondComponent((JComponent)((Object)(state ? this.myDetailsPanel : null)));
    }

    public void dispose() {
        this.myDetailsSplitter.dispose();
        this.myChangesBrowserSplitter.dispose();
    }

    private class MyVcsLogGraphTable
    extends VcsLogGraphTable {
        @NotNull
        private final Runnable myRefresh;

        MyVcsLogGraphTable(@NotNull String logId, @NotNull VcsLogData logData, @NotNull VcsLogUiProperties uiProperties, @NotNull VcsLogColorManager colorManager, @NotNull Runnable refresh2, @NotNull Consumer<Runnable> requestMore, Disposable disposable) {
            super(logId, logData, uiProperties, colorManager, requestMore, disposable);
            this.myRefresh = refresh2;
        }

        @Override
        protected void updateEmptyText() {
            StatusText statusText2 = this.getEmptyText();
            VisiblePack visiblePack = this.getModel().getVisiblePack();
            DataPackBase dataPack = visiblePack.getDataPack();
            if (dataPack instanceof DataPack.ErrorDataPack) {
                this.setErrorEmptyText(((DataPack.ErrorDataPack)dataPack).getError(), VcsLogBundle.message((String)"vcs.log.error.loading.status", (Object[])new Object[0]));
                this.appendActionToEmptyText(VcsLogBundle.message((String)"vcs.log.refresh.status.action", (Object[])new Object[0]), () -> MainFrame.this.myLogData.refresh(MainFrame.this.myLogData.getLogProviders().keySet()));
            } else if (visiblePack instanceof VisiblePack.ErrorVisiblePack) {
                this.setErrorEmptyText(((VisiblePack.ErrorVisiblePack)visiblePack).getError(), VcsLogBundle.message((String)"vcs.log.error.filtering.status", (Object[])new Object[0]));
                if (visiblePack.getFilters().isEmpty()) {
                    this.appendActionToEmptyText(VcsLogBundle.message((String)"vcs.log.refresh.status.action", (Object[])new Object[0]), this.myRefresh);
                } else {
                    VcsLogUiUtil.appendResetFiltersActionToEmptyText(MainFrame.this.myFilterUi, this.getEmptyText());
                }
            } else if (visiblePack.getVisibleGraph().getVisibleCommitCount() == 0) {
                if (visiblePack.getFilters().isEmpty()) {
                    statusText2.setText(VcsLogBundle.message((String)"vcs.log.no.commits.status", (Object[])new Object[0])).appendSecondaryText(VcsLogBundle.message((String)"vcs.log.commit.status.action", (Object[])new Object[0]), VcsLogUiUtil.getLinkAttributes(), ActionUtil.createActionListener((String)"CheckinProject", (Component)((Object)this), (String)"unknown"));
                    String shortcutText = KeymapUtil.getFirstKeyboardShortcutText((String)"CheckinProject");
                    if (!shortcutText.isEmpty()) {
                        statusText2.appendSecondaryText(" (" + shortcutText + ")", StatusText.DEFAULT_ATTRIBUTES, null);
                    }
                } else {
                    MainFrame.this.myFilterUi.setCustomEmptyText(this.getEmptyText());
                }
            } else {
                statusText2.setText(VcsLogBundle.message((String)"vcs.log.default.status", (Object[])new Object[0]));
            }
        }
    }

    private class MyFocusPolicy
    extends ComponentsListFocusTraversalPolicy {
        private MyFocusPolicy() {
        }

        @NotNull
        protected List<Component> getOrderedComponents() {
            ArrayList components = ContainerUtil.newArrayList((Object[])new Component[]{MainFrame.this.myGraphTable, MainFrame.this.myChangesBrowser.getPreferredFocusedComponent(), MainFrame.this.myFilterUi.getTextFilterComponent().getTextEditor()});
            if (MainFrame.this.myDiffPreview != null) {
                components.add(2, ((VcsLogChangeProcessor)MainFrame.this.myDiffPreview.getPreviewDiff()).getPreferredFocusedComponent());
            }
            return components;
        }
    }

    private class MyCommitSelectionListenerForDiff
    extends CommitSelectionListener<VcsFullCommitDetails> {
        @NotNull
        private final JBLoadingPanel myChangesLoadingPane;

        protected MyCommitSelectionListenerForDiff(JBLoadingPanel changesLoadingPane) {
            super(MainFrame.this.myGraphTable, MainFrame.this.myLogData.getCommitDetailsGetter());
            this.myChangesLoadingPane = changesLoadingPane;
        }

        @Override
        protected void onEmptySelection() {
            MainFrame.this.myChangesBrowser.setSelectedDetails(Collections.emptyList());
        }

        @Override
        protected void onDetailsLoaded(@NotNull List<? extends VcsFullCommitDetails> detailsList) {
            int maxSize = VcsLogUtil.getMaxSize(detailsList);
            if (maxSize > VcsLogUtil.getShownChangesLimit()) {
                String sizeText = VcsLogUtil.getSizeText(maxSize);
                MainFrame.this.myChangesBrowser.showText(statusText2 -> {
                    statusText2.setText(VcsLogBundle.message((String)"vcs.log.changes.too.many.status", (Object[])new Object[]{detailsList.size(), sizeText}));
                    statusText2.appendSecondaryText(VcsLogBundle.message((String)"vcs.log.changes.too.many.show.anyway.status.action", (Object[])new Object[0]), VcsLogUiUtil.getLinkAttributes(), e -> MainFrame.this.myChangesBrowser.setSelectedDetails(detailsList));
                });
            } else {
                MainFrame.this.myChangesBrowser.setSelectedDetails(detailsList);
            }
        }

        @Override
        protected void onSelection(int @NotNull [] selection) {
            MainFrame.this.myChangesBrowser.resetSelectedDetails();
        }

        @Override
        protected void startLoading() {
            this.myChangesLoadingPane.startLoading();
        }

        @Override
        protected void stopLoading() {
            this.myChangesLoadingPane.stopLoading();
        }

        @Override
        protected void onError(@NotNull Throwable error) {
            MainFrame.this.myChangesBrowser.showText(statusText2 -> statusText2.setText(VcsLogBundle.message((String)"vcs.log.error.loading.status", (Object[])new Object[0])));
        }
    }
}

