/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.vcs.log.ui.filter.FilterModel;
import com.intellij.vcs.log.ui.filter.VcsLogPopupComponent;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class FilterPopupComponent<Filter, Model extends FilterModel<Filter>>
extends VcsLogPopupComponent {
    protected static final Supplier<@Nls String> ALL = VcsBundle.messagePointer((String)"vcs.log.filter.all", (Object[])new Object[0]);
    @NotNull
    protected final Model myFilterModel;

    FilterPopupComponent(@NotNull Supplier<String> displayName, @NotNull Model filterModel) {
        super(displayName);
        this.myFilterModel = filterModel;
    }

    @Override
    public String getCurrentText() {
        Object filter = ((FilterModel)this.myFilterModel).getFilter();
        return filter == null ? ALL.get() : this.getText(filter);
    }

    @Override
    public void installChangeListener(@NotNull Runnable onChange) {
        ((FilterModel)this.myFilterModel).addSetFilterListener(onChange);
    }

    @NotNull
    @Nls
    protected abstract String getText(@NotNull Filter var1);

    @Nullable
    @Nls
    protected abstract String getToolTip(@NotNull Filter var1);

    @Override
    public String getToolTipText() {
        Object filter = ((FilterModel)this.myFilterModel).getFilter();
        return filter == null ? null : this.getToolTip(filter);
    }

    @NotNull
    protected AnAction createAllAction() {
        return new AllAction();
    }

    private class AllAction
    extends DumbAwareAction {
        AllAction() {
            super(ALL);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            ((FilterModel)FilterPopupComponent.this.myFilterModel).setFilter(null);
        }
    }
}

