/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ObjectUtils;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.statistics.VcsLogUsageTriggerCollector;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class OpenAnotherLogTabAction
extends DumbAwareAction {
    protected OpenAnotherLogTabAction() {
        super(() -> OpenAnotherLogTabAction.getText(VcsLogBundle.message((String)"vcs", (Object[])new Object[0])), () -> OpenAnotherLogTabAction.getDescription(VcsLogBundle.message((String)"vcs", (Object[])new Object[0])), AllIcons.Actions.OpenNewTab);
    }

    public void update(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        VcsProjectLog projectLog = VcsProjectLog.getInstance(project);
        VcsLogManager logManager = (VcsLogManager)ObjectUtils.chooseNotNull((Object)e.getData(VcsLogInternalDataKeys.LOG_MANAGER), (Object)projectLog.getLogManager());
        if (logManager == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        e.getPresentation().setEnabledAndVisible(projectLog.getLogManager() == logManager);
        String vcsName = VcsLogUtil.getVcsDisplayName(project, logManager);
        e.getPresentation().setText(OpenAnotherLogTabAction.getText(vcsName));
        e.getPresentation().setDescription(OpenAnotherLogTabAction.getDescription(vcsName));
    }

    @NotNull
    @Nls(capitalization=Nls.Capitalization.Sentence)
    private static String getDescription(@Nls @NotNull String vcsName) {
        return VcsLogBundle.message((String)"vcs.log.action.description.open.new.tab.with.log", (Object[])new Object[]{vcsName});
    }

    @NotNull
    @Nls(capitalization=Nls.Capitalization.Title)
    private static String getText(@Nls @NotNull String vcsName) {
        return VcsLogBundle.message((String)"vcs.log.action.open.new.tab.with.log", (Object[])new Object[]{vcsName});
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        VcsLogUsageTriggerCollector.triggerUsage(e, (Object)this);
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        VcsLogUi logUi = (VcsLogUi)e.getData(VcsLogDataKeys.VCS_LOG_UI);
        VcsLogFilterCollection filters = Registry.is((String)"vcs.log.copy.filters.to.new.tab") && logUi != null ? logUi.getFilterUi().getFilters() : VcsLogFilterObject.collection(new VcsLogFilter[0]);
        VcsLogManager.LogWindowKind kind = VcsLogManager.LogWindowKind.TOOL_WINDOW;
        if (e.getData(PlatformDataKeys.TOOL_WINDOW) == null && Registry.is((String)"vcs.log.open.editor.tab")) {
            kind = VcsLogManager.LogWindowKind.EDITOR;
        }
        VcsProjectLog.getInstance(project).openLogTab(filters, kind);
    }
}

