/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.ui.AbstractVcsLogUi;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import com.intellij.vcs.log.ui.actions.BooleanPropertyToggleAction;
import com.intellij.vcs.log.ui.highlighters.VcsLogHighlighterFactory;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightersActionGroup
extends ActionGroup
implements DumbAware {
    public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
        ArrayList<Object> actions = new ArrayList<Object>();
        if (e != null && e.getData(VcsLogInternalDataKeys.LOG_UI_PROPERTIES) != null) {
            actions.add(new Separator(IdeBundle.messagePointer((String)"action.Anonymous.text.highlight", (Object[])new Object[0])));
            for (VcsLogHighlighterFactory factory : AbstractVcsLogUi.LOG_HIGHLIGHTER_FACTORY_EP.getExtensionList()) {
                if (!factory.showMenuItem()) continue;
                actions.add((Object)new EnableHighlighterAction(factory));
            }
        }
        return actions.toArray(AnAction.EMPTY_ARRAY);
    }

    private static class EnableHighlighterAction
    extends BooleanPropertyToggleAction {
        @NotNull
        private final VcsLogHighlighterFactory myFactory;

        private EnableHighlighterAction(@NotNull VcsLogHighlighterFactory factory) {
            super(() -> factory.getTitle());
            this.myFactory = factory;
        }

        @Override
        protected VcsLogUiProperties.VcsLogUiProperty<Boolean> getProperty() {
            return MainVcsLogUiProperties.VcsLogHighlighterProperty.get(this.myFactory.getId());
        }
    }
}

