/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.statistics;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.beans.MetricEventFactoryKt;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.service.fus.collectors.UsageDescriptorKeyValidator;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.impl.VcsProjectLog;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@NonNls
public class VcsLogRepoSizeCollector
extends ProjectUsagesCollector {
    @NotNull
    public Set<MetricEvent> getMetrics(@NotNull Project project) {
        DataPack dataPack;
        VcsProjectLog projectLog = VcsProjectLog.getInstance(project);
        VcsLogData logData = projectLog.getDataManager();
        if (logData != null && (dataPack = logData.getDataPack()).isFull()) {
            PermanentGraph<Integer> permanentGraph = dataPack.getPermanentGraph();
            HashSet usages = ContainerUtil.newHashSet((Object[])new MetricEvent[]{new MetricEvent("dataInitialized")});
            usages.add(MetricEventFactoryKt.newCounterMetric((String)"commit.count", (int)permanentGraph.getAllCommits().size()));
            usages.add(MetricEventFactoryKt.newCounterMetric((String)"branches.count", (int)dataPack.getRefsModel().getBranches().size()));
            usages.add(MetricEventFactoryKt.newCounterMetric((String)"users.count", (int)logData.getAllUsers().size()));
            MultiMap<VcsKey, VirtualFile> groupedRoots = VcsLogRepoSizeCollector.groupRootsByVcs(dataPack.getLogProviders());
            for (VcsKey vcs : groupedRoots.keySet()) {
                FeatureUsageData vcsData = new FeatureUsageData().addData("vcs", VcsLogRepoSizeCollector.getVcsKeySafe(vcs));
                usages.add(MetricEventFactoryKt.newCounterMetric((String)"root.count", (int)groupedRoots.get((Object)vcs).size(), (FeatureUsageData)vcsData));
            }
            return usages;
        }
        return Collections.emptySet();
    }

    @NotNull
    private static String getVcsKeySafe(@NotNull VcsKey vcs) {
        if (PluginInfoDetectorKt.getPluginInfo(vcs.getClass()).isDevelopedByJetBrains()) {
            return UsageDescriptorKeyValidator.ensureProperKey((String)StringUtil.toLowerCase((String)vcs.getName()));
        }
        return "third.party";
    }

    @NotNull
    private static MultiMap<VcsKey, VirtualFile> groupRootsByVcs(@NotNull Map<VirtualFile, VcsLogProvider> providers) {
        MultiMap result2 = MultiMap.create();
        for (Map.Entry<VirtualFile, VcsLogProvider> entry : providers.entrySet()) {
            VirtualFile root = entry.getKey();
            VcsKey vcs = entry.getValue().getSupportedVcs();
            result2.putValue((Object)vcs, (Object)root);
        }
        return result2;
    }

    @NotNull
    public String getGroupId() {
        return "vcs.log.data";
    }

    public int getVersion() {
        return 2;
    }
}

