/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.impl.CacheDiffRequestProcessor;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.NoDiffRequest;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.DiffPreviewUpdateProcessor;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.vcs.log.ui.frame.VcsLogChangesBrowser;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0016J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0014J\b\u0010\u0011\u001a\u00020\u0012H\u0014J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\tH\u0016J\u000e\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\tR\u0016\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/vcs/log/history/FileHistoryDiffProcessor;", "Lcom/intellij/diff/impl/CacheDiffRequestProcessor$Simple;", "Lcom/intellij/openapi/vcs/changes/DiffPreviewUpdateProcessor;", "project", "Lcom/intellij/openapi/project/Project;", "changeGetter", "Lkotlin/Function0;", "Lcom/intellij/openapi/vcs/changes/Change;", "isInEditor", "", "disposable", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/openapi/project/Project;Lkotlin/jvm/functions/Function0;ZLcom/intellij/openapi/Disposable;)V", "clear", "", "getCurrentRequestProvider", "Lcom/intellij/diff/chains/DiffRequestProducer;", "getFastLoadingTimeMillis", "", "refresh", "fromModelRefresh", "updatePreview", "state", "intellij.platform.vcs.log.impl"})
public final class FileHistoryDiffProcessor
extends CacheDiffRequestProcessor.Simple
implements DiffPreviewUpdateProcessor {
    private final Function0<Change> changeGetter;

    public final void updatePreview(boolean state) {
        if (state) {
            this.refresh(false);
        } else {
            this.clear();
        }
    }

    @Override
    public void clear() {
        this.applyRequest((DiffRequest)NoDiffRequest.INSTANCE, false, null);
    }

    @Override
    public void refresh(boolean fromModelRefresh) {
        this.updateRequest();
    }

    protected int getFastLoadingTimeMillis() {
        return 10;
    }

    @Nullable
    protected DiffRequestProducer getCurrentRequestProvider() {
        Change change = (Change)this.changeGetter.invoke();
        if (change == null) {
            return null;
        }
        Change change2 = change;
        Project project = this.getProject();
        if (project == null) {
            Intrinsics.throwNpe();
        }
        return VcsLogChangesBrowser.createDiffRequestProducer(project, change2, new HashMap(), true);
    }

    public FileHistoryDiffProcessor(@NotNull Project project, @NotNull Function0<? extends Change> changeGetter, boolean isInEditor, @NotNull Disposable disposable) {
        super(project, isInEditor ? "Default" : "VcsFileHistoryView");
        this.changeGetter = changeGetter;
        this.myContentPanel.setBorder(IdeBorderFactory.createBorder((int)2));
        Disposer.register((Disposable)disposable, (Disposable)((Disposable)this));
    }
}

