/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.print.elements;

import com.intellij.vcs.log.graph.PrintElement;
import com.intellij.vcs.log.graph.api.elements.GraphElement;
import com.intellij.vcs.log.graph.api.printer.PrintElementManager;
import org.jetbrains.annotations.NotNull;

public abstract class PrintElementWithGraphElement
implements PrintElement {
    protected final int myRowIndex;
    protected final int myPositionInCurrentRow;
    @NotNull
    protected final GraphElement myGraphElement;
    @NotNull
    protected final PrintElementManager myPrintElementManager;

    protected PrintElementWithGraphElement(int rowIndex, int positionInCurrentRow, @NotNull GraphElement graphElement, @NotNull PrintElementManager printElementManager) {
        this.myRowIndex = rowIndex;
        this.myPositionInCurrentRow = positionInCurrentRow;
        this.myGraphElement = graphElement;
        this.myPrintElementManager = printElementManager;
    }

    @NotNull
    public GraphElement getGraphElement() {
        return this.myGraphElement;
    }

    public int getRowIndex() {
        return this.myRowIndex;
    }

    public int getPositionInCurrentRow() {
        return this.myPositionInCurrentRow;
    }

    public int getColorId() {
        return this.myPrintElementManager.getColorId(this.myGraphElement);
    }

    public boolean isSelected() {
        return this.myPrintElementManager.isSelected(this);
    }

    @NotNull
    public static PrintElementWithGraphElement converted(@NotNull PrintElementWithGraphElement element, @NotNull GraphElement convertedGraphElement) {
        return new PrintElementWithGraphElement(element.getRowIndex(), element.getPositionInCurrentRow(), convertedGraphElement, element.myPrintElementManager){};
    }
}

