/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.permanent;

import com.intellij.util.NotNullFunction;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.graph.GraphCommit;
import com.intellij.vcs.log.graph.impl.permanent.DuplicateParentFixer;
import com.intellij.vcs.log.graph.impl.permanent.PermanentLinearGraphImpl;
import com.intellij.vcs.log.graph.utils.Flags;
import com.intellij.vcs.log.graph.utils.impl.BitSetFlags;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PermanentLinearGraphBuilder<CommitId> {
    @NotNull
    private final List<? extends GraphCommit<CommitId>> myCommits;
    @NotNull
    private final Flags mySimpleNodes;
    private final int myNodesCount;
    private final int @NotNull [] myNodeToEdgeIndex;
    private final int @NotNull [] myLongEdges;
    @NotNull
    private final Map<CommitId, List<Integer>> upAdjacentNodes = new HashMap<CommitId, List<Integer>>();

    private PermanentLinearGraphBuilder(@NotNull List<? extends GraphCommit<CommitId>> commits, @NotNull Flags simpleNodes, int longEdgesCount) {
        this.myCommits = commits;
        this.mySimpleNodes = simpleNodes;
        this.myNodesCount = simpleNodes.size();
        this.myNodeToEdgeIndex = new int[this.myNodesCount + 1];
        this.myLongEdges = new int[2 * longEdgesCount];
    }

    @NotNull
    public static <CommitId> PermanentLinearGraphBuilder<CommitId> newInstance(@NotNull List<? extends GraphCommit<CommitId>> graphCommits) {
        graphCommits = DuplicateParentFixer.fixDuplicateParentCommits(graphCommits);
        BitSetFlags simpleNodes = new BitSetFlags(graphCommits.size());
        int longEdgesCount = 0;
        for (int nodeIndex = 0; nodeIndex < graphCommits.size(); ++nodeIndex) {
            GraphCommit<CommitId> commit = graphCommits.get(nodeIndex);
            CommitId nextCommitHashIndex = PermanentLinearGraphBuilder.nextCommitHashIndex(graphCommits, nodeIndex);
            List parents = commit.getParents();
            if (parents.size() == 1 && parents.get(0).equals(nextCommitHashIndex)) {
                simpleNodes.set(nodeIndex, true);
                continue;
            }
            longEdgesCount += parents.size();
        }
        return new PermanentLinearGraphBuilder<CommitId>(graphCommits, simpleNodes, longEdgesCount);
    }

    @Nullable
    private static <CommitId> CommitId nextCommitHashIndex(List<? extends GraphCommit<CommitId>> commits, int nodeIndex) {
        if (nodeIndex < commits.size() - 1) {
            return (CommitId)commits.get(nodeIndex + 1).getId();
        }
        return null;
    }

    private void addUnderdoneEdge(int upNodeIndex, CommitId downCommitId) {
        SmartList upNodes = this.upAdjacentNodes.get(downCommitId);
        if (upNodes == null) {
            upNodes = new SmartList();
            this.upAdjacentNodes.put(downCommitId, (List<Integer>)upNodes);
        }
        upNodes.add(upNodeIndex);
    }

    private void fixUnderdoneEdge(int upNodeIndex, int downNodeIndex, CommitId downCommitId) {
        int end = this.myNodeToEdgeIndex[upNodeIndex + 1];
        GraphCommit<CommitId> upCommit = this.myCommits.get(upNodeIndex);
        List parentHashIndices = upCommit.getParents();
        for (int i = 0; i < parentHashIndices.size(); ++i) {
            if (!parentHashIndices.get(i).equals(downCommitId)) continue;
            int offset = parentHashIndices.size() - i;
            int edgeIndex = end - offset;
            if (this.myLongEdges[edgeIndex] == -1) {
                this.myLongEdges[edgeIndex] = downNodeIndex;
                return;
            }
            throw new IllegalStateException("Edge was set early!. Up node: " + upNodeIndex + ", down node: " + downNodeIndex);
        }
        throw new IllegalStateException("Not found underdone edges for node: " + upNodeIndex + ". Adjacent down node: " + downNodeIndex);
    }

    private void doStep(int nodeIndex) {
        GraphCommit<CommitId> commit = this.myCommits.get(nodeIndex);
        List<Integer> upNodes = this.upAdjacentNodes.remove(commit.getId());
        if (upNodes == null) {
            upNodes = Collections.emptyList();
        }
        int edgeIndex = this.myNodeToEdgeIndex[nodeIndex];
        for (Integer upNodeIndex : upNodes) {
            this.fixUnderdoneEdge(upNodeIndex, nodeIndex, commit.getId());
            this.myLongEdges[edgeIndex] = upNodeIndex;
            ++edgeIndex;
        }
        if (!this.mySimpleNodes.get(nodeIndex)) {
            for (Integer downCommitId : commit.getParents()) {
                this.addUnderdoneEdge(nodeIndex, downCommitId);
                this.myLongEdges[edgeIndex] = -1;
                ++edgeIndex;
            }
        }
        this.myNodeToEdgeIndex[nodeIndex + 1] = edgeIndex;
    }

    private void fixUnderdoneEdgeForNotLoadCommit(int upNodeIndex, int notLoadId) {
        for (int edgeIndex = this.myNodeToEdgeIndex[upNodeIndex]; edgeIndex < this.myNodeToEdgeIndex[upNodeIndex + 1]; ++edgeIndex) {
            if (this.myLongEdges[edgeIndex] != -1) continue;
            this.myLongEdges[edgeIndex] = notLoadId;
            return;
        }
        throw new IllegalStateException("Not found underdone edge to not load commit for node: " + upNodeIndex);
    }

    private void fixUnderdoneEdges(@NotNull NotNullFunction<? super CommitId, Integer> notLoadedCommitToId) {
        ArrayList<CommitId> commitIds = new ArrayList<CommitId>(this.upAdjacentNodes.keySet());
        ContainerUtil.sort(commitIds, Comparator.comparingInt(o -> (Integer)Collections.min((Collection)this.upAdjacentNodes.get(o))));
        for (Object notLoadCommit : commitIds) {
            int notLoadId = (Integer)notLoadedCommitToId.fun(notLoadCommit);
            for (int upNodeIndex : this.upAdjacentNodes.get(notLoadCommit)) {
                this.fixUnderdoneEdgeForNotLoadCommit(upNodeIndex, notLoadId);
            }
        }
    }

    @NotNull
    public PermanentLinearGraphImpl build(@NotNull NotNullFunction<? super CommitId, Integer> notLoadedCommitToId) {
        for (int nodeIndex = 0; nodeIndex < this.myNodesCount; ++nodeIndex) {
            this.doStep(nodeIndex);
        }
        this.fixUnderdoneEdges(notLoadedCommitToId);
        return new PermanentLinearGraphImpl(this.mySimpleNodes, this.myNodeToEdgeIndex, this.myLongEdges);
    }

    @NotNull
    public PermanentLinearGraphImpl build() {
        return this.build(dom -> Integer.MIN_VALUE);
    }
}

