/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.collapsing;

import com.intellij.openapi.util.Pair;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.SmartList;
import com.intellij.vcs.log.graph.api.EdgeFilter;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.elements.GraphEdge;
import com.intellij.vcs.log.graph.api.elements.GraphEdgeType;
import com.intellij.vcs.log.graph.collapsing.EdgeStorage;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EdgeStorageWrapper {
    @NotNull
    private final EdgeStorage myEdgeStorage;
    @NotNull
    private final Function<? super Integer, Integer> myGetNodeIndexById;
    @NotNull
    private final Function<? super Integer, Integer> myGetNodeIdByIndex;

    public EdgeStorageWrapper(@NotNull EdgeStorage edgeStorage, @NotNull LinearGraph graph) {
        this(edgeStorage, (Function<? super Integer, Integer>)((Function)nodeId -> graph.getNodeIndex((int)nodeId)), (Function<? super Integer, Integer>)((Function)nodeIndex -> graph.getNodeId((int)nodeIndex)));
    }

    public EdgeStorageWrapper(@NotNull EdgeStorage edgeStorage, @NotNull Function<? super Integer, Integer> getNodeIndexById, @NotNull Function<? super Integer, Integer> getNodeIdByIndex) {
        this.myEdgeStorage = edgeStorage;
        this.myGetNodeIndexById = getNodeIndexById;
        this.myGetNodeIdByIndex = getNodeIdByIndex;
    }

    public void removeEdge(@NotNull GraphEdge graphEdge) {
        Pair<Integer, Integer> nodeIds = this.getNodeIds(graphEdge);
        this.myEdgeStorage.removeEdge((Integer)nodeIds.first, (Integer)nodeIds.second, graphEdge.getType());
    }

    public void createEdge(@NotNull GraphEdge graphEdge) {
        Pair<Integer, Integer> nodeIds = this.getNodeIds(graphEdge);
        this.myEdgeStorage.createEdge((Integer)nodeIds.first, (Integer)nodeIds.second, graphEdge.getType());
    }

    public boolean hasEdge(int fromIndex, int toIndex) {
        int toId = (Integer)this.myGetNodeIdByIndex.fun((Object)toIndex);
        for (Pair<Integer, GraphEdgeType> edge : this.myEdgeStorage.getEdges((Integer)this.myGetNodeIdByIndex.fun((Object)fromIndex))) {
            if (!((GraphEdgeType)((Object)edge.second)).isNormalEdge() || !LinearGraphUtils.intEqual((Integer)edge.first, toId)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public List<GraphEdge> getAdjacentEdges(int nodeIndex, @NotNull EdgeFilter filter) {
        SmartList result2 = new SmartList();
        for (Pair<Integer, GraphEdgeType> retrievedEdge : this.myEdgeStorage.getEdges((Integer)this.myGetNodeIdByIndex.fun((Object)nodeIndex))) {
            GraphEdge edge = this.decompressEdge(nodeIndex, (Integer)retrievedEdge.first, (GraphEdgeType)((Object)retrievedEdge.second));
            if (!EdgeStorageWrapper.matchedEdge(nodeIndex, edge, filter)) continue;
            result2.add(edge);
        }
        return result2;
    }

    @NotNull
    public Set<GraphEdge> getEdges() {
        HashSet<GraphEdge> result2 = new HashSet<GraphEdge>();
        for (int id : this.myEdgeStorage.getKnownIds()) {
            result2.addAll(this.getAdjacentEdges((Integer)this.myGetNodeIndexById.fun((Object)id), EdgeFilter.ALL));
        }
        return result2;
    }

    @NotNull
    private Pair<Integer, Integer> getNodeIds(@NotNull GraphEdge graphEdge) {
        if (graphEdge.getUpNodeIndex() != null) {
            Integer mainId = (Integer)this.myGetNodeIdByIndex.fun((Object)graphEdge.getUpNodeIndex());
            if (graphEdge.getDownNodeIndex() != null) {
                return Pair.create((Object)mainId, (Object)this.myGetNodeIdByIndex.fun((Object)graphEdge.getDownNodeIndex()));
            }
            return Pair.create((Object)mainId, (Object)EdgeStorageWrapper.convertToInt(graphEdge.getTargetId()));
        }
        assert (graphEdge.getDownNodeIndex() != null);
        return Pair.create((Object)this.myGetNodeIdByIndex.fun((Object)graphEdge.getDownNodeIndex()), (Object)EdgeStorageWrapper.convertToInt(graphEdge.getTargetId()));
    }

    @Nullable
    private GraphEdge decompressEdge(int nodeIndex, @Nullable Integer targetId, @NotNull GraphEdgeType edgeType) {
        if (edgeType.isNormalEdge()) {
            assert (targetId != null);
            Integer anotherNodeIndex = (Integer)this.myGetNodeIndexById.fun((Object)targetId);
            if (anotherNodeIndex == null) {
                return null;
            }
            return GraphEdge.createNormalEdge(nodeIndex, anotherNodeIndex, edgeType);
        }
        return GraphEdge.createEdgeWithTargetId(nodeIndex, targetId, edgeType);
    }

    private static boolean matchedEdge(int startNodeIndex, @Nullable GraphEdge edge, @NotNull EdgeFilter filter) {
        if (edge == null) {
            return false;
        }
        if (edge.getType().isNormalEdge()) {
            return startNodeIndex == EdgeStorageWrapper.convertToInt(edge.getDownNodeIndex()) && filter.upNormal || startNodeIndex == EdgeStorageWrapper.convertToInt(edge.getUpNodeIndex()) && filter.downNormal;
        }
        return filter.special;
    }

    private static int convertToInt(@Nullable Integer value) {
        return value == null ? -134217728 : value;
    }

    public void removeAll() {
        this.myEdgeStorage.removeAll();
    }

    public static EdgeStorageWrapper createSimpleEdgeStorage() {
        return new EdgeStorageWrapper(new EdgeStorage(), (Function<? super Integer, Integer>)Functions.id(), (Function<? super Integer, Integer>)Functions.id());
    }
}

