/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data.index;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.Page;
import com.intellij.util.io.PersistentBTreeEnumerator;
import com.intellij.util.io.PersistentEnumeratorBase;
import com.intellij.util.io.PersistentHashMap;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.index.VcsLogFullDetailsIndex;
import com.intellij.vcs.log.history.EdgeData;
import com.intellij.vcs.log.impl.FatalErrorHandler;
import com.intellij.vcs.log.impl.VcsLogIndexer;
import com.intellij.vcs.log.util.StorageId;
import com.intellij.vcsUtil.VcsFileUtil;
import com.intellij.vcsUtil.VcsUtil;
import gnu.trove.TByteObjectHashMap;
import gnu.trove.THashMap;
import gnu.trove.TObjectIntHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.ObjIntConsumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogPathsIndex
extends VcsLogFullDetailsIndex<List<ChangeKind>, VcsLogIndexer.CompressedDetails> {
    private static final Logger LOG = Logger.getInstance(VcsLogPathsIndex.class);
    public static final String PATHS = "paths";
    public static final String INDEX_PATHS_IDS = "paths-ids";
    public static final String RENAMES_MAP = "renames-map";
    @NotNull
    private final PathsIndexer myPathsIndexer;

    public VcsLogPathsIndex(@NotNull StorageId storageId, @NotNull VcsLogStorage storage, @NotNull Set<VirtualFile> roots, @NotNull FatalErrorHandler fatalErrorHandler, @NotNull Disposable disposableParent) throws IOException {
        super(storageId, PATHS, new PathsIndexer(storage, VcsLogPathsIndex.createPathsEnumerator(roots, storageId), VcsLogPathsIndex.createRenamesMap(storageId)), new ChangeKindListKeyDescriptor(), fatalErrorHandler, disposableParent);
        this.myPathsIndexer = (PathsIndexer)this.myIndexer;
        this.myPathsIndexer.setFatalErrorConsumer((Consumer<? super Exception>)((Consumer)e -> fatalErrorHandler.consume(this, (Throwable)e)));
    }

    @NotNull
    private static PersistentEnumeratorBase<LightFilePath> createPathsEnumerator(@NotNull Collection<VirtualFile> roots, @NotNull StorageId storageId) throws IOException {
        Path storageFile = storageId.getStorageFile(INDEX_PATHS_IDS);
        return new PersistentBTreeEnumerator(storageFile, (KeyDescriptor)new LightFilePathKeyDescriptor(roots), Page.PAGE_SIZE, null, storageId.getVersion());
    }

    @NotNull
    private static PersistentHashMap<Couple<Integer>, Collection<Couple<Integer>>> createRenamesMap(@NotNull StorageId storageId) throws IOException {
        Path storageFile = storageId.getStorageFile(RENAMES_MAP);
        return new PersistentHashMap(storageFile, (KeyDescriptor)new CoupleKeyDescriptor(), (DataExternalizer)new CollectionDataExternalizer(), Page.PAGE_SIZE, storageId.getVersion());
    }

    @Nullable
    public FilePath getPath(int pathId) {
        try {
            return VcsLogPathsIndex.toFilePath((LightFilePath)this.myPathsIndexer.getPathsEnumerator().valueOf(pathId));
        }
        catch (IOException e) {
            this.myPathsIndexer.myFatalErrorConsumer.consume((Object)e);
            return null;
        }
    }

    @Override
    public void flush() throws StorageException {
        super.flush();
        this.myPathsIndexer.myRenamesMap.force();
        this.myPathsIndexer.getPathsEnumerator().force();
    }

    @Nullable
    public EdgeData<FilePath> findRename(int parent, int child, @NotNull VirtualFile root, @NotNull FilePath path2, boolean isChildPath) throws IOException {
        Collection renames = (Collection)this.myPathsIndexer.myRenamesMap.get((Object)Couple.of((Object)parent, (Object)child));
        if (renames == null) {
            return null;
        }
        int pathId = this.myPathsIndexer.myPathsEnumerator.enumerate((Object)new LightFilePath(root, path2));
        for (Couple rename : renames) {
            if ((!isChildPath || (Integer)rename.second != pathId) && (isChildPath || (Integer)rename.first != pathId)) continue;
            FilePath path1 = this.getPath((Integer)rename.first);
            FilePath path22 = this.getPath((Integer)rename.second);
            return new EdgeData<FilePath>(path1, path22);
        }
        return null;
    }

    public void iterateCommits(@NotNull VirtualFile root, @NotNull FilePath path2, @NotNull ObjIntConsumer<? super List<ChangeKind>> consumer) throws IOException, StorageException {
        int pathId = this.myPathsIndexer.myPathsEnumerator.enumerate((Object)new LightFilePath(root, path2));
        this.iterateCommitIdsAndValues(pathId, consumer);
    }

    @NotNull
    VcsLogIndexer.PathsEncoder getPathsEncoder() {
        return new VcsLogIndexer.PathsEncoder(){

            @Override
            public int encode(@NotNull VirtualFile root, @NotNull String relativePath, boolean isDirectory) {
                try {
                    return VcsLogPathsIndex.this.myPathsIndexer.myPathsEnumerator.enumerate((Object)new LightFilePath(root, relativePath, isDirectory));
                }
                catch (IOException e) {
                    VcsLogPathsIndex.this.myPathsIndexer.myFatalErrorConsumer.consume((Object)e);
                    return 0;
                }
            }
        };
    }

    @Override
    public void dispose() {
        super.dispose();
        try {
            this.myPathsIndexer.myRenamesMap.close();
            this.myPathsIndexer.getPathsEnumerator().close();
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    @Contract(value="null -> null; !null -> !null")
    @Nullable
    private static FilePath toFilePath(@Nullable LightFilePath lightFilePath) {
        if (lightFilePath == null) {
            return null;
        }
        return VcsUtil.getFilePath((String)(lightFilePath.getRoot().getPath() + "/" + lightFilePath.getRelativePath()), (boolean)lightFilePath.isDirectory());
    }

    static /* synthetic */ Logger access$1100() {
        return LOG;
    }

    private static class CollectionDataExternalizer
    implements DataExternalizer<Collection<Couple<Integer>>> {
        private CollectionDataExternalizer() {
        }

        public void save(@NotNull DataOutput out, Collection<Couple<Integer>> value) throws IOException {
            out.writeInt(value.size());
            for (Couple<Integer> v : value) {
                out.writeInt((Integer)v.first);
                out.writeInt((Integer)v.second);
            }
        }

        public Collection<Couple<Integer>> read(@NotNull DataInput in) throws IOException {
            SmartList result2 = new SmartList();
            int size = in.readInt();
            for (int i = 0; i < size; ++i) {
                result2.add(Couple.of((Object)in.readInt(), (Object)in.readInt()));
            }
            return result2;
        }
    }

    private static class CoupleKeyDescriptor
    implements KeyDescriptor<Couple<Integer>> {
        private CoupleKeyDescriptor() {
        }

        public int getHashCode(Couple<Integer> value) {
            return value.hashCode();
        }

        public boolean isEqual(Couple<Integer> val1, Couple<Integer> val2) {
            return val1.equals(val2);
        }

        public void save(@NotNull DataOutput out, Couple<Integer> value) throws IOException {
            out.writeInt((Integer)value.first);
            out.writeInt((Integer)value.second);
        }

        public Couple<Integer> read(@NotNull DataInput in) throws IOException {
            return Couple.of((Object)in.readInt(), (Object)in.readInt());
        }
    }

    private static class LightFilePathKeyDescriptor
    implements KeyDescriptor<LightFilePath> {
        @NotNull
        private final List<VirtualFile> myRoots;
        @NotNull
        private final TObjectIntHashMap<VirtualFile> myRootsReversed;

        private LightFilePathKeyDescriptor(@NotNull Collection<VirtualFile> roots) {
            this.myRoots = ContainerUtil.sorted(roots, Comparator.comparing(VirtualFile::getPath));
            this.myRootsReversed = new TObjectIntHashMap();
            for (int i = 0; i < this.myRoots.size(); ++i) {
                this.myRootsReversed.put((Object)this.myRoots.get(i), i);
            }
        }

        public int getHashCode(LightFilePath path2) {
            return path2.hashCode();
        }

        public boolean isEqual(LightFilePath path1, LightFilePath path2) {
            return path1.equals(path2);
        }

        public void save(@NotNull DataOutput out, LightFilePath value) throws IOException {
            out.writeInt(this.myRootsReversed.get((Object)value.getRoot()));
            IOUtil.writeUTF((DataOutput)out, (String)value.getRelativePath());
            out.writeBoolean(value.isDirectory());
        }

        public LightFilePath read(@NotNull DataInput in) throws IOException {
            int rootIndex = in.readInt();
            VirtualFile root = this.myRoots.get(rootIndex);
            if (root == null) {
                throw new IOException("Can not read root for index " + rootIndex + ". All roots " + this.myRoots);
            }
            String path2 = IOUtil.readUTF((DataInput)in);
            boolean isDirectory = in.readBoolean();
            return new LightFilePath(root, path2, isDirectory);
        }
    }

    private static class LightFilePath {
        @NotNull
        private final VirtualFile myRoot;
        @NotNull
        private final String myRelativePath;
        private final boolean myIsDirectory;

        private LightFilePath(@NotNull VirtualFile root, @NotNull String relativePath, boolean directory) {
            this.myRoot = root;
            this.myRelativePath = relativePath;
            this.myIsDirectory = directory;
        }

        private LightFilePath(@NotNull VirtualFile root, @NotNull FilePath filePath) {
            this(root, VcsFileUtil.relativePath(root, filePath), filePath.isDirectory());
        }

        @NotNull
        public VirtualFile getRoot() {
            return this.myRoot;
        }

        @NotNull
        public String getRelativePath() {
            return this.myRelativePath;
        }

        public boolean isDirectory() {
            return this.myIsDirectory;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LightFilePath path2 = (LightFilePath)o;
            return this.myIsDirectory == path2.myIsDirectory && this.myRoot.equals(path2.myRoot) && this.myRelativePath.equals(path2.myRelativePath);
        }

        public int hashCode() {
            return Objects.hash(this.myRoot, this.myRelativePath, this.myIsDirectory);
        }
    }

    public static enum ChangeKind {
        MODIFIED(0),
        NOT_CHANGED(1),
        ADDED(2),
        REMOVED(3);

        public final byte id;
        private static final TByteObjectHashMap<ChangeKind> KINDS;

        private ChangeKind(byte id) {
            this.id = id;
        }

        @NotNull
        public static ChangeKind getChangeKindById(byte id) throws IOException {
            ChangeKind kind = (ChangeKind)((Object)KINDS.get(id));
            if (kind == null) {
                throw new IOException("Change kind by id " + id + " not found.");
            }
            return kind;
        }

        static {
            KINDS = new TByteObjectHashMap();
            for (ChangeKind kind : ChangeKind.values()) {
                KINDS.put(kind.id, (Object)kind);
            }
        }
    }

    private static class ChangeKindListKeyDescriptor
    implements DataExternalizer<List<ChangeKind>> {
        private ChangeKindListKeyDescriptor() {
        }

        public void save(@NotNull DataOutput out, List<ChangeKind> value) throws IOException {
            DataInputOutputUtil.writeINT((DataOutput)out, (int)value.size());
            for (ChangeKind data : value) {
                out.writeByte(data.id);
            }
        }

        public List<ChangeKind> read(@NotNull DataInput in) throws IOException {
            SmartList value = new SmartList();
            int size = DataInputOutputUtil.readINT((DataInput)in);
            for (int i = 0; i < size; ++i) {
                value.add(ChangeKind.getChangeKindById(in.readByte()));
            }
            return value;
        }
    }

    private static class PathsIndexer
    implements DataIndexer<Integer, List<ChangeKind>, VcsLogIndexer.CompressedDetails> {
        @NotNull
        private final VcsLogStorage myStorage;
        @NotNull
        private final PersistentEnumeratorBase<LightFilePath> myPathsEnumerator;
        @NotNull
        private final PersistentHashMap<Couple<Integer>, Collection<Couple<Integer>>> myRenamesMap;
        @NotNull
        private Consumer<? super Exception> myFatalErrorConsumer = arg_0 -> ((Logger)VcsLogPathsIndex.access$1100()).error(arg_0);

        private PathsIndexer(@NotNull VcsLogStorage storage, @NotNull PersistentEnumeratorBase<LightFilePath> enumerator2, @NotNull PersistentHashMap<Couple<Integer>, Collection<Couple<Integer>>> renamesMap) {
            this.myStorage = storage;
            this.myPathsEnumerator = enumerator2;
            this.myRenamesMap = renamesMap;
        }

        public void setFatalErrorConsumer(@NotNull Consumer<? super Exception> fatalErrorConsumer) {
            this.myFatalErrorConsumer = fatalErrorConsumer;
        }

        @NotNull
        public Map<Integer, List<ChangeKind>> map(@NotNull VcsLogIndexer.CompressedDetails inputData) {
            THashMap result2 = new THashMap();
            int parentsCount = inputData.getParents().isEmpty() ? 1 : inputData.getParents().size();
            for (int parentIndex = 0; parentIndex < parentsCount; ++parentIndex) {
                try {
                    int finalParentIndex = parentIndex;
                    SmartList renames = new SmartList();
                    inputData.getRenamedPaths(parentIndex).forEachEntry((arg_0, arg_1) -> PathsIndexer.lambda$map$0((Collection)renames, (Map)result2, parentsCount, finalParentIndex, arg_0, arg_1));
                    if (renames.size() > 0) {
                        int commit = this.myStorage.getCommitIndex((Hash)inputData.getId(), inputData.getRoot());
                        int parent = this.myStorage.getCommitIndex((Hash)inputData.getParents().get(parentIndex), inputData.getRoot());
                        this.myRenamesMap.put((Object)Couple.of((Object)parent, (Object)commit), (Object)renames);
                    }
                    inputData.getModifiedPaths(parentIndex).forEachEntry((arg_0, arg_1) -> PathsIndexer.lambda$map$1((Map)result2, parentsCount, finalParentIndex, arg_0, arg_1));
                    continue;
                }
                catch (IOException e) {
                    this.myFatalErrorConsumer.consume((Object)e);
                }
            }
            return result2;
        }

        @NotNull
        private static List<ChangeKind> getOrCreateChangeKindList(@NotNull Map<Integer, List<ChangeKind>> pathIdToChangeDataListsMap, int pathId, int parentsCount) {
            SmartList changeDataList = pathIdToChangeDataListsMap.get(pathId);
            if (changeDataList == null) {
                changeDataList = new SmartList();
                for (int i = 0; i < parentsCount; ++i) {
                    changeDataList.add(ChangeKind.NOT_CHANGED);
                }
                pathIdToChangeDataListsMap.put(pathId, (List<ChangeKind>)changeDataList);
            }
            return changeDataList;
        }

        @NotNull
        private static ChangeKind createChangeData(@NotNull Change.Type type) {
            switch (type) {
                case NEW: {
                    return ChangeKind.ADDED;
                }
                case DELETED: {
                    return ChangeKind.REMOVED;
                }
            }
            return ChangeKind.MODIFIED;
        }

        @NotNull
        public PersistentEnumeratorBase<LightFilePath> getPathsEnumerator() {
            return this.myPathsEnumerator;
        }

        private static /* synthetic */ boolean lambda$map$1(Map result2, int parentsCount, int finalParentIndex, int pathId, Change.Type changeType) {
            PathsIndexer.getOrCreateChangeKindList(result2, pathId, parentsCount).set(finalParentIndex, PathsIndexer.createChangeData(changeType));
            return true;
        }

        private static /* synthetic */ boolean lambda$map$0(Collection renames, Map result2, int parentsCount, int finalParentIndex, int beforeId, int afterId) {
            renames.add(Couple.of((Object)beforeId, (Object)afterId));
            PathsIndexer.getOrCreateChangeKindList(result2, beforeId, parentsCount).set(finalParentIndex, ChangeKind.REMOVED);
            PathsIndexer.getOrCreateChangeKindList(result2, afterId, parentsCount).set(finalParentIndex, ChangeKind.ADDED);
            return true;
        }
    }
}

