/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data.index;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EventDispatcher;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.EventListener;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="Vcs.Log.Big.Repositories", storages={@Storage(value="vcs.log.big.repos.xml", roamingType=RoamingType.DISABLED)}, reportStatistic=false)
public class VcsLogBigRepositoriesList
implements PersistentStateComponent<State> {
    @NotNull
    private final Object myLock = new Object();
    @NotNull
    private final EventDispatcher<Listener> myDispatcher = EventDispatcher.create(Listener.class);
    private State myState;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VcsLogBigRepositoriesList() {
        Object object = this.myLock;
        synchronized (object) {
            this.myState = new State();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public State getState() {
        Object object = this.myLock;
        synchronized (object) {
            return new State(this.myState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadState(@NotNull State state) {
        Object object = this.myLock;
        synchronized (object) {
            if (state.DIFF_RENAME_LIMIT_ONE) {
                this.myState = new State(state);
            } else {
                this.myState = new State();
                this.myState.DIFF_RENAME_LIMIT_ONE = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRepository(@NotNull VirtualFile root) {
        boolean added;
        Object object = this.myLock;
        synchronized (object) {
            added = this.myState.REPOSITORIES.add(root.getPath());
        }
        if (added) {
            ((Listener)this.myDispatcher.getMulticaster()).onRepositoriesListChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeRepository(@NotNull VirtualFile root) {
        boolean removed;
        Object object = this.myLock;
        synchronized (object) {
            removed = this.myState.REPOSITORIES.remove(root.getPath());
        }
        if (removed) {
            ((Listener)this.myDispatcher.getMulticaster()).onRepositoriesListChanged();
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBig(@NotNull VirtualFile root) {
        Object object = this.myLock;
        synchronized (object) {
            return this.myState.REPOSITORIES.contains(root.getPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRepositoriesCount() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myState.REPOSITORIES.size();
        }
    }

    public void addListener(@NotNull Listener listener2, @NotNull Disposable disposable) {
        this.myDispatcher.addListener((EventListener)listener2, disposable);
    }

    @NotNull
    public static VcsLogBigRepositoriesList getInstance() {
        return (VcsLogBigRepositoriesList)ServiceManager.getService(VcsLogBigRepositoriesList.class);
    }

    public static interface Listener
    extends EventListener {
        public void onRepositoriesListChanged();
    }

    public static class State {
        @XCollection(elementName="repository", valueAttributeName="path")
        public SortedSet<String> REPOSITORIES = new TreeSet<String>();
        @Attribute(value="diff-rename-limit-one")
        public boolean DIFF_RENAME_LIMIT_ONE = false;

        public State() {
        }

        public State(@NotNull State state) {
            this.REPOSITORIES = new TreeSet<String>(state.REPOSITORIES);
            this.DIFF_RENAME_LIMIT_ONE = state.DIFF_RENAME_LIMIT_ONE;
        }
    }
}

