/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.TimedVcsCommit;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.CompressedRefs;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.SingleTaskController;
import com.intellij.vcs.log.data.TopCommitsCache;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.VcsLogJoiner;
import com.intellij.vcs.log.data.VcsLogMultiRepoJoiner;
import com.intellij.vcs.log.data.VcsLogProgress;
import com.intellij.vcs.log.data.VcsLogRefreshNotEnoughDataException;
import com.intellij.vcs.log.data.VcsLogRefresher;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.VcsUserRegistryImpl;
import com.intellij.vcs.log.data.index.VcsLogModifiableIndex;
import com.intellij.vcs.log.graph.GraphCommit;
import com.intellij.vcs.log.graph.GraphCommitImpl;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.impl.RequirementsImpl;
import com.intellij.vcs.log.util.StopWatch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogRefresherImpl
implements VcsLogRefresher,
Disposable {
    private static final Logger LOG = Logger.getInstance(VcsLogRefresherImpl.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final VcsLogStorage myStorage;
    @NotNull
    private final Map<VirtualFile, VcsLogProvider> myProviders;
    @NotNull
    private final VcsUserRegistryImpl myUserRegistry;
    @NotNull
    private final VcsLogModifiableIndex myIndex;
    @NotNull
    private final TopCommitsCache myTopCommitsDetailsCache;
    @NotNull
    private final VcsLogProgress myProgress;
    private final int myRecentCommitCount;
    @NotNull
    private final SingleTaskController<RefreshRequest, DataPack> mySingleTaskController;
    @NotNull
    private volatile DataPack myDataPack = DataPack.EMPTY;

    public VcsLogRefresherImpl(@NotNull Project project, @NotNull VcsLogStorage storage, @NotNull Map<VirtualFile, VcsLogProvider> providers, @NotNull VcsUserRegistryImpl userRegistry, @NotNull VcsLogModifiableIndex index, @NotNull VcsLogProgress progress, @NotNull TopCommitsCache topCommitsDetailsCache, @NotNull Consumer<? super DataPack> dataPackUpdateHandler, int recentCommitsCount) {
        this.myProject = project;
        this.myStorage = storage;
        this.myProviders = providers;
        this.myUserRegistry = userRegistry;
        this.myIndex = index;
        this.myTopCommitsDetailsCache = topCommitsDetailsCache;
        this.myRecentCommitCount = recentCommitsCount;
        this.myProgress = progress;
        this.mySingleTaskController = new SingleTaskController<RefreshRequest, DataPack>("permanent", dataPack -> {
            this.myDataPack = dataPack;
            dataPackUpdateHandler.consume(dataPack);
        }, (Disposable)this){

            @Override
            @NotNull
            protected SingleTaskController.SingleTask startNewBackgroundTask() {
                return VcsLogRefresherImpl.this.startNewBackgroundTask(new MyRefreshTask(VcsLogRefresherImpl.this.myDataPack));
            }
        };
    }

    protected SingleTaskController.SingleTask startNewBackgroundTask(@NotNull Task.Backgroundable refreshTask) {
        LOG.debug("Starting a background task...");
        ProgressIndicator indicator = this.myProgress.createProgressIndicator(VcsLogData.DATA_PACK_REFRESH);
        Future future2 = ((CoreProgressManager)ProgressManager.getInstance()).runProcessWithProgressAsynchronously(refreshTask, indicator, null);
        return new SingleTaskController.SingleTaskImpl(future2, indicator);
    }

    @NotNull
    public DataPack getCurrentDataPack() {
        return this.myDataPack;
    }

    @Override
    @NotNull
    public DataPack readFirstBlock() {
        try {
            LogInfo data = this.loadRecentData(new CommitCountRequirements(this.myRecentCommitCount).asMap(this.myProviders.keySet()));
            Collection<List<GraphCommit<Integer>>> commits = data.getCommits();
            Map<VirtualFile, CompressedRefs> refs = data.getRefs();
            List compoundList = VcsLogRefresherImpl.multiRepoJoin(commits);
            compoundList = ContainerUtil.getFirstItems(compoundList, (int)this.myRecentCommitCount);
            this.myDataPack = DataPack.build(compoundList, refs, this.myProviders, this.myStorage, false);
            this.mySingleTaskController.request((RefreshRequest[])new RefreshRequest[]{RefreshRequest.RELOAD_ALL});
            return this.myDataPack;
        }
        catch (VcsException e) {
            LOG.info((Throwable)e);
            return new DataPack.ErrorDataPack(e);
        }
    }

    @NotNull
    private LogInfo loadRecentData(final @NotNull Map<VirtualFile, VcsLogProvider.Requirements> requirements) throws VcsException {
        final StopWatch sw = StopWatch.start("loading commits");
        final LogInfo logInfo = new LogInfo(this.myStorage);
        new ProviderIterator(){

            @Override
            public void each(@NotNull VirtualFile root, @NotNull VcsLogProvider provider) throws VcsException {
                VcsLogProvider.DetailedLogData data = provider.readFirstBlock(root, (VcsLogProvider.Requirements)requirements.get(root));
                logInfo.put(root, VcsLogRefresherImpl.this.compactCommits(data.getCommits(), root));
                logInfo.put(root, data.getRefs());
                VcsLogRefresherImpl.this.storeUsersAndDetails(data.getCommits());
                sw.rootCompleted(root);
            }
        }.iterate(this.getProvidersForRoots(requirements.keySet()));
        this.myUserRegistry.flush();
        this.myIndex.scheduleIndex(false);
        sw.report();
        return logInfo;
    }

    @NotNull
    private Map<VirtualFile, VcsLogProvider> getProvidersForRoots(@NotNull Set<VirtualFile> roots) {
        return ContainerUtil.map2Map(roots, root -> Pair.create((Object)root, (Object)this.myProviders.get(root)));
    }

    @Override
    public void refresh(@NotNull Collection<VirtualFile> rootsToRefresh) {
        if (!rootsToRefresh.isEmpty()) {
            this.mySingleTaskController.request((RefreshRequest[])new RefreshRequest[]{new RefreshRequest(rootsToRefresh)});
        }
    }

    @NotNull
    private static <T extends GraphCommit<Integer>> List<T> multiRepoJoin(@NotNull Collection<? extends List<T>> commits) {
        StopWatch sw = StopWatch.start("multi-repo join");
        List joined = new VcsLogMultiRepoJoiner().join(commits);
        sw.report();
        return joined;
    }

    @NotNull
    private List<GraphCommit<Integer>> compactCommits(@NotNull List<? extends TimedVcsCommit> commits, @NotNull VirtualFile root) {
        StopWatch sw = StopWatch.start("compacting commits");
        List map2 = ContainerUtil.map(commits, commit -> this.compactCommit((TimedVcsCommit)commit, root));
        this.myStorage.flush();
        sw.report();
        return map2;
    }

    @NotNull
    private GraphCommit<Integer> compactCommit(@NotNull TimedVcsCommit commit, @NotNull VirtualFile root) {
        List parents = ContainerUtil.map((Collection)commit.getParents(), (Function)((NotNullFunction)hash -> this.myStorage.getCommitIndex((Hash)hash, root)));
        int index = this.myStorage.getCommitIndex((Hash)commit.getId(), root);
        this.myIndex.markForIndexing(index, root);
        return GraphCommitImpl.createIntCommit(index, parents, commit.getTimestamp());
    }

    private void storeUsersAndDetails(@NotNull List<? extends VcsCommitMetadata> metadatas) {
        for (VcsCommitMetadata vcsCommitMetadata : metadatas) {
            this.myUserRegistry.addUser(vcsCommitMetadata.getAuthor());
            this.myUserRegistry.addUser(vcsCommitMetadata.getCommitter());
        }
        this.myTopCommitsDetailsCache.storeDetails(metadatas);
    }

    @NotNull
    public VcsLogProgress getProgress() {
        return this.myProgress;
    }

    public void dispose() {
    }

    private static class LogInfo {
        private final VcsLogStorage myStorage;
        private final Map<VirtualFile, CompressedRefs> myRefs = new HashMap<VirtualFile, CompressedRefs>();
        private final Map<VirtualFile, List<GraphCommit<Integer>>> myCommits = new HashMap<VirtualFile, List<GraphCommit<Integer>>>();

        LogInfo(VcsLogStorage storage) {
            this.myStorage = storage;
        }

        void put(@NotNull VirtualFile root, @NotNull List<GraphCommit<Integer>> commits) {
            this.myCommits.put(root, commits);
        }

        void put(@NotNull VirtualFile root, @NotNull Set<VcsRef> refs) {
            this.myRefs.put(root, new CompressedRefs(refs, this.myStorage));
        }

        void put(@NotNull VirtualFile root, @NotNull CompressedRefs refs) {
            this.myRefs.put(root, refs);
        }

        @NotNull
        Collection<List<GraphCommit<Integer>>> getCommits() {
            return this.myCommits.values();
        }

        List<GraphCommit<Integer>> getCommits(@NotNull VirtualFile root) {
            return this.myCommits.get(root);
        }

        @NotNull
        Map<VirtualFile, CompressedRefs> getRefs() {
            return this.myRefs;
        }
    }

    private static class CommitCountRequirements
    implements VcsLogProvider.Requirements {
        private final int myCommitCount;

        CommitCountRequirements(int commitCount) {
            this.myCommitCount = commitCount;
        }

        public int getCommitCount() {
            return this.myCommitCount;
        }

        @NotNull
        Map<VirtualFile, VcsLogProvider.Requirements> asMap(@NotNull Collection<VirtualFile> roots) {
            return ContainerUtil.map2Map(roots, root -> Pair.create((Object)root, (Object)this));
        }
    }

    private static abstract class ProviderIterator {
        private ProviderIterator() {
        }

        abstract void each(@NotNull VirtualFile var1, @NotNull VcsLogProvider var2) throws VcsException;

        final void iterate(@NotNull Map<VirtualFile, VcsLogProvider> providers) throws VcsException {
            for (Map.Entry<VirtualFile, VcsLogProvider> entry : providers.entrySet()) {
                this.each(entry.getKey(), entry.getValue());
            }
        }
    }

    private static class RefreshRequest {
        private static final RefreshRequest RELOAD_ALL = new RefreshRequest((Collection)Collections.emptyList()){

            @Override
            public String toString() {
                return "RELOAD_ALL";
            }
        };
        private final Collection<VirtualFile> rootsToRefresh;

        RefreshRequest(@NotNull Collection<VirtualFile> rootsToRefresh) {
            this.rootsToRefresh = rootsToRefresh;
        }

        public String toString() {
            return "{" + this.rootsToRefresh + "}";
        }
    }

    private class MyRefreshTask
    extends Task.Backgroundable {
        @NotNull
        private DataPack myCurrentDataPack;
        @NotNull
        private final LogInfo myLoadedInfo;

        MyRefreshTask(DataPack currentDataPack) {
            super(VcsLogRefresherImpl.this.myProject, VcsLogBundle.message((String)"vcs.log.refreshing.process", (Object[])new Object[0]), false);
            this.myLoadedInfo = new LogInfo(VcsLogRefresherImpl.this.myStorage);
            this.myCurrentDataPack = currentDataPack;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            LOG.debug("Refresh task started");
            indicator.setIndeterminate(true);
            DataPack dataPack = this.myCurrentDataPack;
            while (true) {
                List requests = VcsLogRefresherImpl.this.mySingleTaskController.popRequests();
                Collection<VirtualFile> rootsToRefresh = this.getRootsToRefresh(requests);
                LOG.debug("Requests: " + requests + ". roots to refresh: " + rootsToRefresh);
                if (rootsToRefresh.isEmpty()) break;
                dataPack = this.doRefresh(rootsToRefresh);
            }
            VcsLogRefresherImpl.this.mySingleTaskController.taskCompleted(dataPack);
        }

        @NotNull
        private Collection<VirtualFile> getRootsToRefresh(@NotNull List<? extends RefreshRequest> requests) {
            ArrayList<VirtualFile> rootsToRefresh = new ArrayList<VirtualFile>();
            for (RefreshRequest refreshRequest : requests) {
                if (refreshRequest == RefreshRequest.RELOAD_ALL) {
                    this.myCurrentDataPack = DataPack.EMPTY;
                    return VcsLogRefresherImpl.this.myProviders.keySet();
                }
                rootsToRefresh.addAll(refreshRequest.rootsToRefresh);
            }
            return rootsToRefresh;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        private DataPack doRefresh(@NotNull Collection<? extends VirtualFile> roots) {
            StopWatch sw = StopWatch.start("refresh");
            PermanentGraph<Integer> permanentGraph = this.myCurrentDataPack.isFull() ? this.myCurrentDataPack.getPermanentGraph() : null;
            Map<VirtualFile, CompressedRefs> currentRefs = this.myCurrentDataPack.getRefsModel().getAllRefsByRoot();
            try {
                if (permanentGraph != null) {
                    int commitCount = VcsLogRefresherImpl.this.myRecentCommitCount;
                    for (int attempt = 0; attempt <= 1; ++attempt) {
                        this.loadLogAndRefs(roots, currentRefs, commitCount);
                        List compoundLog = VcsLogRefresherImpl.multiRepoJoin(this.myLoadedInfo.getCommits());
                        Map<VirtualFile, CompressedRefs> allNewRefs = this.getAllNewRefs(this.myLoadedInfo, currentRefs);
                        List<? extends GraphCommit<Integer>> joinedFullLog = this.join(compoundLog, new ArrayList(permanentGraph.getAllCommits()), currentRefs, allNewRefs);
                        if (joinedFullLog == null) {
                            commitCount *= 5;
                            continue;
                        }
                        DataPack dataPack = DataPack.build(joinedFullLog, allNewRefs, VcsLogRefresherImpl.this.myProviders, VcsLogRefresherImpl.this.myStorage, true);
                        return dataPack;
                    }
                    LOG.info("Couldn't join " + commitCount / 5 + " recent commits to the log (" + permanentGraph.getAllCommits().size() + " commits)");
                }
                DataPack commitCount = this.loadFullLog();
                return commitCount;
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.info((Throwable)e);
                DataPack.ErrorDataPack errorDataPack = new DataPack.ErrorDataPack(e);
                return errorDataPack;
            }
            finally {
                sw.report();
            }
        }

        @NotNull
        private Map<VirtualFile, CompressedRefs> getAllNewRefs(@NotNull LogInfo newInfo, @NotNull Map<VirtualFile, CompressedRefs> previousRefs) {
            HashMap<VirtualFile, CompressedRefs> result2 = new HashMap<VirtualFile, CompressedRefs>();
            for (VirtualFile root : previousRefs.keySet()) {
                CompressedRefs newInfoRefs = newInfo.getRefs().get(root);
                result2.put(root, newInfoRefs != null ? newInfoRefs : previousRefs.get(root));
            }
            return result2;
        }

        private void loadLogAndRefs(@NotNull Collection<? extends VirtualFile> roots, @NotNull Map<VirtualFile, CompressedRefs> prevRefs, int commitCount) throws VcsException {
            LogInfo logInfo = VcsLogRefresherImpl.this.loadRecentData(this.prepareRequirements(roots, commitCount, prevRefs));
            for (VirtualFile virtualFile : roots) {
                this.myLoadedInfo.put(virtualFile, logInfo.getCommits(virtualFile));
                this.myLoadedInfo.put(virtualFile, logInfo.getRefs().get(virtualFile));
            }
        }

        @NotNull
        private Map<VirtualFile, VcsLogProvider.Requirements> prepareRequirements(@NotNull Collection<? extends VirtualFile> roots, int commitCount, @NotNull Map<VirtualFile, CompressedRefs> prevRefs) {
            HashMap<VirtualFile, VcsLogProvider.Requirements> requirements = new HashMap<VirtualFile, VcsLogProvider.Requirements>();
            for (VirtualFile virtualFile : roots) {
                requirements.put(virtualFile, (VcsLogProvider.Requirements)new RequirementsImpl(commitCount, true, prevRefs.get(virtualFile).getRefs()));
            }
            return requirements;
        }

        @Nullable
        private List<? extends GraphCommit<Integer>> join(@NotNull List<? extends GraphCommit<Integer>> recentCommits, @NotNull List<? extends GraphCommit<Integer>> fullLog, @NotNull Map<VirtualFile, CompressedRefs> previousRefs, @NotNull Map<VirtualFile, CompressedRefs> newRefs) {
            if (fullLog.isEmpty()) {
                return recentCommits;
            }
            StopWatch sw = StopWatch.start("joining new commits");
            Collection prevRefIndices = previousRefs.values().stream().flatMap(refs -> refs.getCommits().stream()).collect(Collectors.toSet());
            Collection newRefIndices = newRefs.values().stream().flatMap(refs -> refs.getCommits().stream()).collect(Collectors.toSet());
            try {
                List commits = (List)new VcsLogJoiner<CommitId, GraphCommit<Integer>>().addCommits(fullLog, prevRefIndices, recentCommits, newRefIndices).first;
                sw.report();
                return commits;
            }
            catch (VcsLogRefreshNotEnoughDataException e) {
                LOG.info((Throwable)e);
            }
            catch (IllegalStateException e) {
                LOG.info((Throwable)e);
            }
            return null;
        }

        @NotNull
        private DataPack loadFullLog() throws VcsException {
            StopWatch sw = StopWatch.start("full log reload");
            LogInfo logInfo = this.readFullLogFromVcs();
            List graphCommits = VcsLogRefresherImpl.multiRepoJoin(logInfo.getCommits());
            DataPack dataPack = DataPack.build(graphCommits, logInfo.getRefs(), VcsLogRefresherImpl.this.myProviders, VcsLogRefresherImpl.this.myStorage, true);
            sw.report();
            return dataPack;
        }

        @NotNull
        private LogInfo readFullLogFromVcs() throws VcsException {
            final StopWatch sw = StopWatch.start("read full log from VCS");
            final LogInfo logInfo = new LogInfo(VcsLogRefresherImpl.this.myStorage);
            new ProviderIterator(){

                @Override
                void each(@NotNull VirtualFile root, @NotNull VcsLogProvider provider) throws VcsException {
                    ArrayList<GraphCommit<Integer>> graphCommits = new ArrayList<GraphCommit<Integer>>();
                    VcsLogProvider.LogData data = provider.readAllHashes(root, commit -> graphCommits.add(VcsLogRefresherImpl.this.compactCommit(commit, root)));
                    logInfo.put(root, graphCommits);
                    logInfo.put(root, data.getRefs());
                    VcsLogRefresherImpl.this.myUserRegistry.addUsers(data.getUsers());
                    sw.rootCompleted(root);
                }
            }.iterate(VcsLogRefresherImpl.this.myProviders);
            VcsLogRefresherImpl.this.myUserRegistry.flush();
            VcsLogRefresherImpl.this.myIndex.scheduleIndex(true);
            sw.report();
            return logInfo;
        }
    }
}

