/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.vcs.log.graph.GraphCommit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class VcsLogMultiRepoJoiner<CommitId, Commit extends GraphCommit<CommitId>> {
    @NotNull
    public List<Commit> join(@NotNull Collection<? extends List<Commit>> logsFromRepos) {
        if (logsFromRepos.size() == 1) {
            return logsFromRepos.iterator().next();
        }
        int size = 0;
        for (List<Commit> repo : logsFromRepos) {
            size += repo.size();
        }
        ArrayList result2 = new ArrayList(size);
        HashMap<Object, Iterator> nextCommits = new HashMap<Object, Iterator>();
        for (List<Commit> log : logsFromRepos) {
            Iterator<Commit> iterator = log.iterator();
            if (!iterator.hasNext()) continue;
            nextCommits.put(iterator.next(), iterator);
        }
        while (!nextCommits.isEmpty()) {
            Object lastCommit = this.findLatestCommit(nextCommits.keySet());
            Iterator iterator = (Iterator)nextCommits.get(lastCommit);
            result2.add(lastCommit);
            nextCommits.remove(lastCommit);
            if (!iterator.hasNext()) continue;
            nextCommits.put(iterator.next(), iterator);
        }
        return result2;
    }

    @NotNull
    private Commit findLatestCommit(@NotNull Set<? extends Commit> commits) {
        long maxTimeStamp = Long.MIN_VALUE;
        GraphCommit lastCommit = null;
        for (GraphCommit commit : commits) {
            if (commit.getTimestamp() < maxTimeStamp) continue;
            maxTimeStamp = commit.getTimestamp();
            lastCommit = commit;
        }
        assert (lastCommit != null);
        return (Commit)lastCommit;
    }
}

