/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogDataProvider;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.VcsUserRegistry;
import com.intellij.vcs.log.data.CommitDetailsGetter;
import com.intellij.vcs.log.data.ContainingBranchesGetter;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.DataPackChangeListener;
import com.intellij.vcs.log.data.EmptyIndex;
import com.intellij.vcs.log.data.InMemoryStorage;
import com.intellij.vcs.log.data.MiniDetailsGetter;
import com.intellij.vcs.log.data.SingleTaskController;
import com.intellij.vcs.log.data.TopCommitsCache;
import com.intellij.vcs.log.data.VcsLogProgress;
import com.intellij.vcs.log.data.VcsLogRefresherImpl;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.VcsLogStorageImpl;
import com.intellij.vcs.log.data.VcsUserRegistryImpl;
import com.intellij.vcs.log.data.index.VcsLogIndex;
import com.intellij.vcs.log.data.index.VcsLogModifiableIndex;
import com.intellij.vcs.log.data.index.VcsLogPersistentIndex;
import com.intellij.vcs.log.impl.FatalErrorHandler;
import com.intellij.vcs.log.impl.VcsLogCachesInvalidator;
import com.intellij.vcs.log.impl.VcsLogSharedSettings;
import com.intellij.vcs.log.util.PersistentUtil;
import com.intellij.vcs.log.util.StopWatch;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogData
implements Disposable,
VcsLogDataProvider {
    private static final Logger LOG = Logger.getInstance(VcsLogData.class);
    public static final int RECENT_COMMITS_COUNT = Registry.intValue((String)"vcs.log.recent.commits.count");
    public static final VcsLogProgress.ProgressKey DATA_PACK_REFRESH = new VcsLogProgress.ProgressKey("data pack");
    @NotNull
    private final Project myProject;
    @NotNull
    private final Map<VirtualFile, VcsLogProvider> myLogProviders;
    @NotNull
    private final MiniDetailsGetter myMiniDetailsGetter;
    @NotNull
    private final CommitDetailsGetter myDetailsGetter;
    private final Map<VirtualFile, VcsUser> myCurrentUser = new HashMap<VirtualFile, VcsUser>();
    @NotNull
    private final TopCommitsCache myTopCommitsDetailsCache;
    @NotNull
    private final VcsUserRegistryImpl myUserRegistry;
    @NotNull
    private final VcsLogStorage myStorage;
    @NotNull
    private final ContainingBranchesGetter myContainingBranchesGetter;
    @NotNull
    private final VcsLogRefresherImpl myRefresher;
    @NotNull
    private final List<DataPackChangeListener> myDataPackChangeListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    @NotNull
    private final FatalErrorHandler myFatalErrorsConsumer;
    @NotNull
    private final VcsLogModifiableIndex myIndex;
    @NotNull
    private final Object myLock = new Object();
    @NotNull
    private State myState = State.CREATED;
    @Nullable
    private SingleTaskController.SingleTask myInitialization = null;

    public VcsLogData(@NotNull Project project, @NotNull Map<VirtualFile, VcsLogProvider> logProviders, @NotNull FatalErrorHandler fatalErrorsConsumer, @NotNull Disposable parentDisposable) {
        this.myProject = project;
        this.myLogProviders = logProviders;
        this.myUserRegistry = (VcsUserRegistryImpl)ServiceManager.getService((Project)project, VcsUserRegistry.class);
        this.myFatalErrorsConsumer = fatalErrorsConsumer;
        VcsLogProgress progress = new VcsLogProgress(this);
        if (VcsLogCachesInvalidator.getInstance().isValid()) {
            this.myStorage = this.createStorage();
            if (VcsLogSharedSettings.isIndexSwitchedOn(this.myProject)) {
                this.myIndex = new VcsLogPersistentIndex(this.myProject, this.myStorage, progress, logProviders, this.myFatalErrorsConsumer, this);
            } else {
                LOG.info("Vcs log index is turned off for project " + this.myProject.getName());
                this.myIndex = new EmptyIndex();
            }
        } else {
            LOG.error("Could not delete caches at " + PersistentUtil.LOG_CACHE);
            this.myFatalErrorsConsumer.displayFatalErrorMessage(VcsLogBundle.message((String)"vcs.log.fatal.error.message", (Object[])new Object[]{PersistentUtil.LOG_CACHE, ApplicationNamesInfo.getInstance().getFullProductName()}));
            this.myStorage = new InMemoryStorage();
            this.myIndex = new EmptyIndex();
        }
        this.myTopCommitsDetailsCache = new TopCommitsCache(this.myStorage);
        this.myMiniDetailsGetter = new MiniDetailsGetter(this.myProject, this.myStorage, logProviders, this.myTopCommitsDetailsCache, this.myIndex, this);
        this.myDetailsGetter = new CommitDetailsGetter(this.myStorage, logProviders, this.myIndex, this);
        this.myRefresher = new VcsLogRefresherImpl(this.myProject, this.myStorage, this.myLogProviders, this.myUserRegistry, this.myIndex, progress, this.myTopCommitsDetailsCache, (Consumer<? super DataPack>)((Consumer)this::fireDataPackChangeEvent), RECENT_COMMITS_COUNT);
        Disposer.register((Disposable)this, (Disposable)this.myRefresher);
        this.myContainingBranchesGetter = new ContainingBranchesGetter(this, this);
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        Disposer.register((Disposable)this, () -> {
            Object object = this.myLock;
            synchronized (object) {
                if (this.myInitialization != null) {
                    this.myInitialization.cancel();
                }
            }
        });
    }

    @NotNull
    private VcsLogStorage createStorage() {
        VcsLogStorage hashMap;
        try {
            hashMap = new VcsLogStorageImpl(this.myProject, this.myLogProviders, this.myFatalErrorsConsumer, this);
        }
        catch (IOException e) {
            hashMap = new InMemoryStorage();
            LOG.error("Falling back to in-memory hashes", (Throwable)e);
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myState.equals((Object)State.CREATED)) {
                this.myState = State.INITIALIZED;
                final StopWatch stopWatch = StopWatch.start("initialize");
                Task.Backgroundable backgroundable = new Task.Backgroundable(this.myProject, VcsLogBundle.message((String)"vcs.log.initial.loading.process", (Object[])new Object[0]), false){

                    public void run(@NotNull ProgressIndicator indicator) {
                        indicator.setIndeterminate(true);
                        VcsLogData.this.resetState();
                        VcsLogData.this.readCurrentUser();
                        DataPack dataPack = VcsLogData.this.myRefresher.readFirstBlock();
                        VcsLogData.this.fireDataPackChangeEvent(dataPack);
                        stopWatch.report();
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onCancel() {
                        Object object = VcsLogData.this.myLock;
                        synchronized (object) {
                            if (VcsLogData.this.myState.equals((Object)State.INITIALIZED)) {
                                VcsLogData.this.myState = State.CREATED;
                                VcsLogData.this.myInitialization = null;
                            }
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onThrowable(@NotNull Throwable error) {
                        Object object = VcsLogData.this.myLock;
                        synchronized (object) {
                            LOG.error(error);
                            if (VcsLogData.this.myState.equals((Object)State.INITIALIZED)) {
                                VcsLogData.this.myState = State.CREATED;
                                VcsLogData.this.myInitialization = null;
                            }
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onSuccess() {
                        Object object = VcsLogData.this.myLock;
                        synchronized (object) {
                            if (VcsLogData.this.myState.equals((Object)State.INITIALIZED)) {
                                VcsLogData.this.myInitialization = null;
                            }
                        }
                    }
                };
                CoreProgressManager manager = (CoreProgressManager)ProgressManager.getInstance();
                ProgressIndicator indicator = this.myRefresher.getProgress().createProgressIndicator(DATA_PACK_REFRESH);
                Future future2 = manager.runProcessWithProgressAsynchronously(backgroundable, indicator, null);
                this.myInitialization = new SingleTaskController.SingleTaskImpl(future2, indicator);
            }
        }
    }

    private void readCurrentUser() {
        StopWatch sw = StopWatch.start("readCurrentUser");
        for (Map.Entry<VirtualFile, VcsLogProvider> entry : this.myLogProviders.entrySet()) {
            VirtualFile root = entry.getKey();
            try {
                VcsUser me = entry.getValue().getCurrentUser(root);
                if (me != null) {
                    this.myCurrentUser.put(root, me);
                    continue;
                }
                LOG.info("Username not configured for root " + root);
            }
            catch (VcsException e) {
                LOG.warn("Couldn't read the username from root " + root, (Throwable)e);
            }
        }
        sw.report();
    }

    private void fireDataPackChangeEvent(@NotNull DataPack dataPack) {
        ApplicationManager.getApplication().invokeLater(() -> {
            for (DataPackChangeListener listener2 : this.myDataPackChangeListeners) {
                listener2.onDataPackChange(dataPack);
            }
        }, o -> Disposer.isDisposed((Disposable)this));
    }

    public void addDataPackChangeListener(@NotNull DataPackChangeListener listener2) {
        this.myDataPackChangeListeners.add(listener2);
    }

    public void removeDataPackChangeListener(@NotNull DataPackChangeListener listener2) {
        this.myDataPackChangeListeners.remove(listener2);
    }

    @NotNull
    public DataPack getDataPack() {
        return this.myRefresher.getCurrentDataPack();
    }

    @Nullable
    public CommitId getCommitId(int commitIndex) {
        return this.myStorage.getCommitId(commitIndex);
    }

    public int getCommitIndex(@NotNull Hash hash, @NotNull VirtualFile root) {
        return this.myStorage.getCommitIndex(hash, root);
    }

    @NotNull
    public VcsLogStorage getStorage() {
        return this.myStorage;
    }

    private void resetState() {
        this.myTopCommitsDetailsCache.clear();
    }

    @NotNull
    public Set<VcsUser> getAllUsers() {
        return this.myUserRegistry.getUsers();
    }

    @NotNull
    public Map<VirtualFile, VcsUser> getCurrentUser() {
        return this.myCurrentUser;
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public Collection<VirtualFile> getRoots() {
        return this.myLogProviders.keySet();
    }

    @NotNull
    public Map<VirtualFile, VcsLogProvider> getLogProviders() {
        return this.myLogProviders;
    }

    @NotNull
    public ContainingBranchesGetter getContainingBranchesGetter() {
        return this.myContainingBranchesGetter;
    }

    public void refresh(@NotNull Collection<VirtualFile> roots) {
        this.initialize();
        this.myRefresher.refresh(roots);
    }

    @NotNull
    public CommitDetailsGetter getCommitDetailsGetter() {
        return this.myDetailsGetter;
    }

    @NotNull
    public MiniDetailsGetter getMiniDetailsGetter() {
        return this.myMiniDetailsGetter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        SingleTaskController.SingleTask initialization;
        Object object = this.myLock;
        synchronized (object) {
            initialization = this.myInitialization;
            this.myInitialization = null;
            this.myState = State.DISPOSED;
        }
        if (initialization != null) {
            initialization.cancel();
            try {
                initialization.waitFor(1L, TimeUnit.MINUTES);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                LOG.warn((Throwable)e);
            }
        }
        this.resetState();
    }

    @NotNull
    public VcsLogProvider getLogProvider(@NotNull VirtualFile root) {
        return this.myLogProviders.get(root);
    }

    @NotNull
    public VcsUserRegistryImpl getUserRegistry() {
        return this.myUserRegistry;
    }

    @NotNull
    public VcsLogProgress getProgress() {
        return this.myRefresher.getProgress();
    }

    @NotNull
    public TopCommitsCache getTopCommitsCache() {
        return this.myTopCommitsDetailsCache;
    }

    @NotNull
    public VcsLogIndex getIndex() {
        return this.getModifiableIndex();
    }

    @NotNull
    VcsLogModifiableIndex getModifiableIndex() {
        return this.myIndex;
    }

    private static enum State {
        CREATED,
        INITIALIZED,
        DISPOSED;

    }
}

