/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Consumer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SingleTaskController<Request, Result>
implements Disposable {
    protected static final Logger LOG = Logger.getInstance(SingleTaskController.class);
    @NotNull
    @NonNls
    private final String myName;
    @NotNull
    private final Consumer<? super Result> myResultHandler;
    @NotNull
    private final Object LOCK = new Object();
    @NotNull
    private List<Request> myAwaitingRequests;
    @Nullable
    private SingleTask myRunningTask;
    private boolean myIsClosed = false;

    public SingleTaskController(@NotNull @NonNls String name, @NotNull Consumer<? super Result> handler, @NotNull Disposable parent) {
        this.myName = name;
        this.myResultHandler = handler;
        this.myAwaitingRequests = new LinkedList<Request>();
        Disposer.register((Disposable)parent, (Disposable)this);
    }

    public final void request(Request ... requests) {
        this.request(Arrays.asList(requests));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void request(@NotNull List<Request> requestList) {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.myIsClosed) {
                return;
            }
            this.myAwaitingRequests.addAll(requestList);
            this.debug("Added requests: " + requestList);
            if (this.myRunningTask != null && this.cancelRunningTasks(requestList)) {
                this.cancelTask(this.myRunningTask);
            }
            if (this.myRunningTask == null) {
                this.myRunningTask = this.startNewBackgroundTask();
                this.debug("Started a new bg task " + this.myRunningTask);
            }
        }
    }

    protected boolean cancelRunningTasks(@NotNull List<Request> requests) {
        return false;
    }

    private void debug(@NotNull String message) {
        LOG.debug("[" + this.myName + "] " + message);
    }

    private void cancelTask(@NotNull SingleTask t) {
        if (t.isRunning()) {
            t.cancel();
            this.debug("Canceled task " + this.myRunningTask);
        }
    }

    @NotNull
    protected abstract SingleTask startNewBackgroundTask();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<Request> popRequests() {
        Object object = this.LOCK;
        synchronized (object) {
            List<Request> requests = this.myAwaitingRequests;
            this.myAwaitingRequests = new LinkedList<Request>();
            this.debug("Popped requests: " + requests);
            return requests;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<Request> peekRequests() {
        Object object = this.LOCK;
        synchronized (object) {
            ArrayList<Request> requests = new ArrayList<Request>(this.myAwaitingRequests);
            this.debug("Peeked requests: " + requests);
            return requests;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeRequests(@NotNull List<Request> requests) {
        Object object = this.LOCK;
        synchronized (object) {
            this.myAwaitingRequests.removeAll(requests);
            this.debug("Removed requests: " + requests);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Request popRequest() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.myAwaitingRequests.isEmpty()) {
                return null;
            }
            Request request = this.myAwaitingRequests.remove(0);
            this.debug("Popped request: " + request);
            return request;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void taskCompleted(@Nullable Result result2) {
        if (result2 != null) {
            this.myResultHandler.consume(result2);
            this.debug("Handled result: " + result2);
        }
        Object object = this.LOCK;
        synchronized (object) {
            if (this.myAwaitingRequests.isEmpty()) {
                this.myRunningTask = null;
                this.debug("No more requests");
            } else {
                this.myRunningTask = this.startNewBackgroundTask();
                this.debug("Restarted a bg task " + this.myRunningTask);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeQueue() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.myIsClosed) {
                return;
            }
            this.myIsClosed = true;
            if (this.myRunningTask != null) {
                this.myRunningTask.cancel();
            }
            this.myAwaitingRequests.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        SingleTask task2 = null;
        Object object = this.LOCK;
        synchronized (object) {
            this.closeQueue();
            if (this.myRunningTask != null) {
                task2 = this.myRunningTask;
                this.myRunningTask = null;
            }
        }
        if (!ApplicationManager.getApplication().isDispatchThread() && task2 != null) {
            try {
                task2.waitFor(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.debug((Throwable)e);
            }
            catch (TimeoutException e) {
                LOG.warn("Wait time out ", (Throwable)e);
            }
        }
    }

    public static class SingleTaskImpl
    implements SingleTask {
        @NotNull
        private final Future<?> myFuture;
        @NotNull
        private final ProgressIndicator myIndicator;

        public SingleTaskImpl(@NotNull Future<?> future2, @NotNull ProgressIndicator indicator) {
            this.myFuture = future2;
            this.myIndicator = indicator;
        }

        @Override
        public void waitFor(long timeout, @NotNull TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            this.myFuture.get(timeout, unit);
        }

        @Override
        public void cancel() {
            this.myIndicator.cancel();
        }

        @Override
        public boolean isRunning() {
            return this.myIndicator.isRunning();
        }
    }

    public static interface SingleTask {
        public void waitFor(long var1, @NotNull TimeUnit var3) throws InterruptedException, ExecutionException, TimeoutException;

        public void cancel();

        public boolean isRunning();
    }
}

