/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogRefs;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.CompressedRefs;
import com.intellij.vcs.log.data.VcsLogStorage;
import gnu.trove.TIntObjectHashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefsModel
implements VcsLogRefs {
    private static final Logger LOG = Logger.getInstance(RefsModel.class);
    @NotNull
    private final VcsLogStorage myStorage;
    @NotNull
    private final Map<VirtualFile, CompressedRefs> myRefs;
    @NotNull
    private final TIntObjectHashMap<VcsRef> myBestRefForHead;
    @NotNull
    private final TIntObjectHashMap<VirtualFile> myRootForHead;

    public RefsModel(@NotNull Map<VirtualFile, CompressedRefs> refs, @NotNull Set<Integer> heads, @NotNull VcsLogStorage storage, @NotNull Map<VirtualFile, VcsLogProvider> providers) {
        this.myRefs = refs;
        this.myStorage = storage;
        this.myBestRefForHead = new TIntObjectHashMap();
        this.myRootForHead = new TIntObjectHashMap();
        for (int head : heads) {
            CommitId commitId = this.myStorage.getCommitId(head);
            if (commitId == null) continue;
            VirtualFile root = commitId.getRoot();
            this.myRootForHead.put(head, (Object)root);
            Optional bestRef = this.myRefs.get(root).refsToCommit(head).stream().min(providers.get(root).getReferenceManager().getBranchLayoutComparator());
            if (bestRef.isPresent()) {
                this.myBestRefForHead.put(head, bestRef.get());
                continue;
            }
            LOG.debug("No references at head " + commitId);
        }
    }

    @Nullable
    public VcsRef bestRefToHead(int headIndex) {
        return (VcsRef)this.myBestRefForHead.get(headIndex);
    }

    @NotNull
    public VirtualFile rootAtHead(int headIndex) {
        return (VirtualFile)this.myRootForHead.get(headIndex);
    }

    @NotNull
    public Map<VirtualFile, CompressedRefs> getAllRefsByRoot() {
        return this.myRefs;
    }

    @NotNull
    public List<VcsRef> refsToCommit(int index) {
        if (this.myRefs.size() <= 10) {
            for (CompressedRefs refs : this.myRefs.values()) {
                if (!refs.contains(index)) continue;
                return refs.refsToCommit(index);
            }
            return Collections.emptyList();
        }
        CommitId id = this.myStorage.getCommitId(index);
        if (id == null) {
            return Collections.emptyList();
        }
        VirtualFile root = id.getRoot();
        return this.myRefs.get(root).refsToCommit(index);
    }

    @NotNull
    public Collection<VcsRef> getBranches() {
        return this.myRefs.values().stream().flatMap(CompressedRefs::streamBranches).collect(Collectors.toList());
    }

    @NotNull
    public Stream<VcsRef> stream() {
        assert (!ApplicationManager.getApplication().isDispatchThread());
        return this.myRefs.values().stream().flatMap(CompressedRefs::stream);
    }

    @NotNull
    public static RefsModel createEmptyInstance(@NotNull VcsLogStorage storage) {
        return new RefsModel(Collections.emptyMap(), Collections.emptySet(), storage, Collections.emptyMap());
    }
}

