/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogRefManager;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.CompressedRefs;
import com.intellij.vcs.log.data.DataPackBase;
import com.intellij.vcs.log.data.EmptyPermanentGraph;
import com.intellij.vcs.log.data.RefsModel;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.VcsLogStorageImpl;
import com.intellij.vcs.log.graph.GraphColorManagerImpl;
import com.intellij.vcs.log.graph.GraphCommit;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.graph.impl.facade.PermanentGraphImpl;
import com.intellij.vcs.log.util.StopWatch;
import gnu.trove.TIntHashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class DataPack
extends DataPackBase {
    public static final DataPack EMPTY = new DataPack(RefsModel.createEmptyInstance(VcsLogStorageImpl.EMPTY), EmptyPermanentGraph.getInstance(), Collections.emptyMap(), false);
    @NotNull
    private final PermanentGraph<Integer> myPermanentGraph;

    DataPack(@NotNull RefsModel refsModel, @NotNull PermanentGraph<Integer> permanentGraph, @NotNull Map<VirtualFile, VcsLogProvider> providers, boolean full) {
        super(providers, refsModel, full);
        this.myPermanentGraph = permanentGraph;
    }

    @NotNull
    public static DataPack build(@NotNull List<? extends GraphCommit<Integer>> commits, @NotNull Map<VirtualFile, CompressedRefs> refs, @NotNull Map<VirtualFile, VcsLogProvider> providers, @NotNull VcsLogStorage storage, boolean full) {
        PermanentGraph<Integer> permanentGraph;
        RefsModel refsModel;
        if (commits.isEmpty()) {
            refsModel = new RefsModel(refs, new HashSet<Integer>(), storage, providers);
            permanentGraph = EmptyPermanentGraph.getInstance();
        } else {
            refsModel = new RefsModel(refs, DataPack.getHeads(commits), storage, providers);
            Function<Integer, Hash> hashGetter = VcsLogStorageImpl.createHashGetter(storage);
            GraphColorManagerImpl colorManager = new GraphColorManagerImpl(refsModel, hashGetter, DataPack.getRefManagerMap(providers));
            Set<Integer> branches = DataPack.getBranchCommitHashIndexes(refsModel.getBranches(), storage);
            StopWatch sw = StopWatch.start("building graph");
            permanentGraph = PermanentGraphImpl.newInstance(commits, colorManager, branches);
            sw.report();
        }
        return new DataPack(refsModel, permanentGraph, providers, full);
    }

    @NotNull
    private static Set<Integer> getHeads(@NotNull List<? extends GraphCommit<Integer>> commits) {
        TIntHashSet parents = new TIntHashSet();
        for (GraphCommit<Integer> graphCommit : commits) {
            Iterator iterator = graphCommit.getParents().iterator();
            while (iterator.hasNext()) {
                int parent = (Integer)iterator.next();
                parents.add(parent);
            }
        }
        HashSet<Integer> heads = new HashSet<Integer>();
        for (GraphCommit<Integer> graphCommit : commits) {
            if (parents.contains(((Integer)graphCommit.getId()).intValue())) continue;
            heads.add((Integer)graphCommit.getId());
        }
        return heads;
    }

    @NotNull
    private static Set<Integer> getBranchCommitHashIndexes(@NotNull Collection<? extends VcsRef> branches, @NotNull VcsLogStorage storage) {
        HashSet<Integer> result2 = new HashSet<Integer>();
        for (VcsRef vcsRef : branches) {
            result2.add(storage.getCommitIndex(vcsRef.getCommitHash(), vcsRef.getRoot()));
        }
        return result2;
    }

    @NotNull
    public static Map<VirtualFile, VcsLogRefManager> getRefManagerMap(@NotNull Map<VirtualFile, VcsLogProvider> logProviders) {
        HashMap<VirtualFile, VcsLogRefManager> map2 = new HashMap<VirtualFile, VcsLogRefManager>();
        for (Map.Entry<VirtualFile, VcsLogProvider> entry : logProviders.entrySet()) {
            map2.put(entry.getKey(), entry.getValue().getReferenceManager());
        }
        return map2;
    }

    @NotNull
    public PermanentGraph<Integer> getPermanentGraph() {
        return this.myPermanentGraph;
    }

    public String toString() {
        return "{DataPack. " + this.myPermanentGraph.getAllCommits().size() + " commits in " + this.myLogProviders.keySet().size() + " roots}";
    }

    public static class ErrorDataPack
    extends DataPack {
        @NotNull
        private final Throwable myError;

        public ErrorDataPack(@NotNull Throwable error) {
            super(RefsModel.createEmptyInstance(VcsLogStorageImpl.EMPTY), EmptyPermanentGraph.getInstance(), Collections.emptyMap(), false);
            this.myError = error;
        }

        @NotNull
        public Throwable getError() {
            return this.myError;
        }
    }
}

