/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.commit.message;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionToolsSupplier;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.ToolsImpl;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.util.messages.Topic;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import com.intellij.vcs.commit.message.BodyLimitInspection;
import com.intellij.vcs.commit.message.BodyLimitSettings;
import com.intellij.vcs.commit.message.CommitMessageSpellCheckingInspection;
import com.intellij.vcs.commit.message.SubjectBodySeparationInspection;
import com.intellij.vcs.commit.message.SubjectLimitInspection;
import java.util.Arrays;
import java.util.EventListener;
import java.util.List;
import java.util.Objects;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@com.intellij.openapi.components.State(name="CommitMessageInspectionProfile", storages={@Storage(value="vcs.xml")})
public class CommitMessageInspectionProfile
extends InspectionProfileImpl
implements PersistentStateComponent<State> {
    @NotNull
    public static final Topic<ProfileListener> TOPIC = Topic.create((String)"commit message inspection changes", ProfileListener.class);
    private static final String PROFILE_NAME = "Commit Dialog";
    public static final InspectionProfileImpl DEFAULT = new InspectionProfileImpl("Commit Dialog", (InspectionToolsSupplier)new CommitMessageInspectionToolSupplier(), (InspectionProfileImpl)null);
    @NotNull
    private final Project myProject;

    public CommitMessageInspectionProfile(@NotNull Project project) {
        super(PROFILE_NAME, (InspectionToolsSupplier)new CommitMessageInspectionToolSupplier(), DEFAULT);
        this.myProject = project;
    }

    @NotNull
    public static CommitMessageInspectionProfile getInstance(@NotNull Project project) {
        return (CommitMessageInspectionProfile)((Object)ServiceManager.getService((Project)project, CommitMessageInspectionProfile.class));
    }

    @NotNull
    public static BodyLimitSettings getBodyLimitSettings(@NotNull Project project) {
        VcsConfiguration configuration = VcsConfiguration.getInstance((Project)project);
        CommitMessageInspectionProfile profile = CommitMessageInspectionProfile.getInstance(project);
        return new BodyLimitSettings(profile.getBodyRightMargin(), configuration.USE_COMMIT_MESSAGE_MARGIN && profile.isToolEnabled(BodyLimitInspection.class), configuration.WRAP_WHEN_TYPING_REACHES_RIGHT_MARGIN);
    }

    public static int getBodyRightMargin(@NotNull Project project) {
        return CommitMessageInspectionProfile.getInstance(project).getBodyRightMargin();
    }

    public static int getSubjectRightMargin(@NotNull Project project) {
        return CommitMessageInspectionProfile.getInstance(project).getSubjectRightMargin();
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    private int getBodyRightMargin() {
        return this.getTool(BodyLimitInspection.class).RIGHT_MARGIN;
    }

    private int getSubjectRightMargin() {
        return this.getTool(SubjectLimitInspection.class).RIGHT_MARGIN;
    }

    @NotNull
    public <T extends LocalInspectionTool> T getTool(@NotNull Class<T> aClass) {
        InspectionToolWrapper tool = this.getInspectionTool(InspectionProfileEntry.getShortName((String)aClass.getSimpleName()), this.myProject);
        return (T)((LocalInspectionTool)Objects.requireNonNull(tool).getTool());
    }

    public <T extends LocalInspectionTool> boolean isToolEnabled(@NotNull Class<T> aClass) {
        ToolsImpl tools = this.getToolsOrNull(InspectionProfileEntry.getShortName((String)aClass.getSimpleName()), this.myProject);
        return tools != null && tools.isEnabled();
    }

    protected boolean forceInitInspectionTools() {
        return true;
    }

    @Transient
    @NotNull
    public String getName() {
        return super.getName();
    }

    @NotNull
    public State getState() {
        Element element = CommitMessageInspectionProfile.newProfileElement();
        this.writeExternal(element);
        State state = new State();
        state.myProfile = element;
        return state;
    }

    public void loadState(@NotNull State state) {
        this.readExternal(state.myProfile);
    }

    @NotNull
    private static Element newProfileElement() {
        return new Element("profile");
    }

    @NotNull
    private static Element newProfileWithVersionElement() {
        Element result2 = CommitMessageInspectionProfile.newProfileElement();
        CommitMessageInspectionProfile.writeVersion((Element)result2);
        return result2;
    }

    static /* synthetic */ Element access$100() {
        return CommitMessageInspectionProfile.newProfileWithVersionElement();
    }

    public static interface ProfileListener
    extends EventListener {
        public void profileChanged();
    }

    private static class CommitMessageInspectionToolSupplier
    extends InspectionToolsSupplier {
        private CommitMessageInspectionToolSupplier() {
        }

        @NotNull
        public List<InspectionToolWrapper<?, ?>> createTools() {
            return Arrays.asList(new LocalInspectionToolWrapper((LocalInspectionTool)new SubjectBodySeparationInspection()), new LocalInspectionToolWrapper((LocalInspectionTool)new SubjectLimitInspection()), new LocalInspectionToolWrapper((LocalInspectionTool)new BodyLimitInspection()), new LocalInspectionToolWrapper((LocalInspectionTool)new CommitMessageSpellCheckingInspection()));
        }
    }

    public static class State {
        @Tag(value="profile")
        public Element myProfile = CommitMessageInspectionProfile.access$100();
    }
}

