/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.update;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.util.ui.update.Update;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class DisposableUpdate
extends Update {
    private final Disposable myParentDisposable;

    public DisposableUpdate(@NotNull Disposable parentDisposable, @NonNls @NotNull Object identity) {
        super(identity);
        this.myParentDisposable = parentDisposable;
    }

    public final void run() {
        BackgroundTaskUtil.runUnderDisposeAwareIndicator((Disposable)this.myParentDisposable, this::doRun);
    }

    protected abstract void doRun();

    public static DisposableUpdate createDisposable(@NotNull Disposable parentDisposable, @NonNls @NotNull Object identity, final @NotNull Runnable runnable) {
        return new DisposableUpdate(parentDisposable, identity){

            @Override
            public void doRun() {
                runnable.run();
            }
        };
    }
}

