/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.unscramble;

import com.intellij.execution.filters.FileHyperlinkInfo;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.impl.EditorHyperlinkSupport;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorGutterAction;
import com.intellij.openapi.editor.TextAnnotationGutterProvider;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.annotate.AnnotationSource;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.annotate.ShowAllAffectedGenericAction;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsHistorySession;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.intellij.vcs.history.VcsHistoryProviderEx;
import com.intellij.vcsUtil.VcsUtil;
import com.intellij.xml.util.XmlStringUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.awt.Color;
import java.awt.Cursor;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AnnotateStackTraceAction
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance(AnnotateStackTraceAction.class);
    private boolean myIsLoading = false;

    public void update(@NotNull AnActionEvent e) {
        ConsoleViewImpl consoleView = (ConsoleViewImpl)e.getData(LangDataKeys.CONSOLE_VIEW);
        boolean isShown = consoleView != null && consoleView.getEditor().getGutter().isAnnotationsShown();
        e.getPresentation().setEnabled(consoleView != null && !isShown && !this.myIsLoading);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        this.myIsLoading = true;
        ConsoleViewImpl consoleView = (ConsoleViewImpl)e.getData(LangDataKeys.CONSOLE_VIEW);
        if (consoleView == null) {
            return;
        }
        final Editor editor = consoleView.getEditor();
        final EditorHyperlinkSupport hyperlinks = consoleView.getHyperlinks();
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(editor.getProject(), LangBundle.message((String)"progress.title.getting.file.history", (Object[])new Object[0]), true){
            private final Object LOCK;
            private final MergingUpdateQueue myUpdateQueue;
            private MyActiveAnnotationGutter myGutter;
            {
                super(x0, x1, x2);
                this.LOCK = new Object();
                this.myUpdateQueue = new MergingUpdateQueue("AnnotateStackTraceAction", 200, true, null);
            }

            public void onCancel() {
                editor.getGutter().closeAllAnnotations();
            }

            public void onFinished() {
                AnnotateStackTraceAction.this.myIsLoading = false;
                Disposer.dispose((Disposable)this.myUpdateQueue);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(final @NotNull ProgressIndicator indicator) {
                Object2ObjectOpenHashMap files2lines = new Object2ObjectOpenHashMap();
                Int2ObjectOpenHashMap revisions = new Int2ObjectOpenHashMap();
                ApplicationManager.getApplication().runReadAction(() -> {
                    for (int line = 0; line < editor.getDocument().getLineCount(); ++line) {
                        indicator.checkCanceled();
                        VirtualFile file = AnnotateStackTraceAction.getHyperlinkVirtualFile(hyperlinks.findAllHyperlinksOnLine(line));
                        if (file == null) continue;
                        ((IntArrayList)files2lines.computeIfAbsent((Object)file, __ -> new IntArrayList())).add(line);
                    }
                });
                for (Map.Entry entry : Object2ObjectMaps.fastIterable((Object2ObjectMap)files2lines)) {
                    VirtualFile file = (VirtualFile)entry.getKey();
                    IntArrayList value = (IntArrayList)entry.getValue();
                    indicator.checkCanceled();
                    LastRevision revision = this.getLastRevision(file);
                    if (revision == null) continue;
                    Object object = this.LOCK;
                    synchronized (object) {
                        IntListIterator iterator = value.iterator();
                        while (iterator.hasNext()) {
                            revisions.put(iterator.nextInt(), (Object)revision);
                        }
                    }
                    this.myUpdateQueue.queue(new Update("update", (Int2ObjectMap)revisions){
                        final /* synthetic */ Int2ObjectMap val$revisions;
                        {
                            this.val$revisions = int2ObjectMap;
                            super(x0);
                        }

                        public void run() {
                            this.updateGutter(indicator, (Map)this.val$revisions);
                        }
                    });
                }
                ApplicationManager.getApplication().invokeLater(() -> this.lambda$run$2(indicator, (Int2ObjectMap)revisions));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void updateGutter(@NotNull ProgressIndicator indicator, @NotNull Map<Integer, LastRevision> revisions) {
                HashMap<Integer, LastRevision> revisionsCopy;
                if (indicator.isCanceled()) {
                    return;
                }
                if (this.myGutter == null) {
                    this.myGutter = new MyActiveAnnotationGutter(this.getProject(), hyperlinks, indicator);
                    editor.getGutter().registerTextAnnotation((TextAnnotationGutterProvider)this.myGutter, (EditorGutterAction)this.myGutter);
                }
                Object object = this.LOCK;
                synchronized (object) {
                    revisionsCopy = new HashMap<Integer, LastRevision>(revisions);
                }
                this.myGutter.updateData(revisionsCopy);
                ((EditorGutterComponentEx)editor.getGutter()).revalidateMarkup();
            }

            @Nullable
            private LastRevision getLastRevision(@NotNull VirtualFile file) {
                try {
                    AbstractVcs vcs = VcsUtil.getVcsFor((Project)editor.getProject(), (VirtualFile)file);
                    if (vcs == null) {
                        return null;
                    }
                    VcsHistoryProvider historyProvider = vcs.getVcsHistoryProvider();
                    if (historyProvider == null) {
                        return null;
                    }
                    FilePath filePath = VcsContextFactory.SERVICE.getInstance().createFilePathOn(file);
                    if (historyProvider instanceof VcsHistoryProviderEx) {
                        VcsFileRevision revision = ((VcsHistoryProviderEx)historyProvider).getLastRevision(filePath);
                        if (revision == null) {
                            return null;
                        }
                        return LastRevision.create(revision);
                    }
                    VcsHistorySession session = historyProvider.createSessionFor(filePath);
                    if (session == null) {
                        return null;
                    }
                    List list = session.getRevisionList();
                    if (list == null || list.isEmpty()) {
                        return null;
                    }
                    return LastRevision.create((VcsFileRevision)list.get(0));
                }
                catch (VcsException ignored) {
                    LOG.warn((Throwable)ignored);
                    return null;
                }
            }

            private /* synthetic */ void lambda$run$2(ProgressIndicator indicator, Int2ObjectMap revisions) {
                this.updateGutter(indicator, (Map<Integer, LastRevision>)revisions);
            }
        });
    }

    @Nullable
    private static VirtualFile getHyperlinkVirtualFile(@NotNull List<RangeHighlighter> links) {
        RangeHighlighter key = (RangeHighlighter)ContainerUtil.getLastItem(links);
        if (key == null) {
            return null;
        }
        HyperlinkInfo info = EditorHyperlinkSupport.getHyperlinkInfo((RangeHighlighter)key);
        if (!(info instanceof FileHyperlinkInfo)) {
            return null;
        }
        OpenFileDescriptor descriptor = ((FileHyperlinkInfo)info).getDescriptor();
        return descriptor != null ? descriptor.getFile() : null;
    }

    private static class MyActiveAnnotationGutter
    implements TextAnnotationGutterProvider,
    EditorGutterAction {
        @NotNull
        private final Project myProject;
        @NotNull
        private final EditorHyperlinkSupport myHyperlinks;
        @NotNull
        private final ProgressIndicator myIndicator;
        @NotNull
        private Map<Integer, LastRevision> myRevisions = Collections.emptyMap();
        private Date myNewestDate = null;
        private int myMaxDateLength = 0;

        MyActiveAnnotationGutter(@NotNull Project project, @NotNull EditorHyperlinkSupport hyperlinks, @NotNull ProgressIndicator indicator) {
            this.myProject = project;
            this.myHyperlinks = hyperlinks;
            this.myIndicator = indicator;
        }

        public void doAction(int lineNum) {
            LastRevision revision = this.myRevisions.get(lineNum);
            if (revision == null) {
                return;
            }
            VirtualFile file = AnnotateStackTraceAction.getHyperlinkVirtualFile(this.myHyperlinks.findAllHyperlinksOnLine(lineNum));
            if (file == null) {
                return;
            }
            AbstractVcs vcs = ProjectLevelVcsManager.getInstance((Project)this.myProject).getVcsFor(file);
            if (vcs != null) {
                VcsRevisionNumber number = revision.getNumber();
                VcsKey vcsKey = vcs.getKeyInstanceMethod();
                ShowAllAffectedGenericAction.showSubmittedFiles((Project)this.myProject, (VcsRevisionNumber)number, (VirtualFile)file, (VcsKey)vcsKey);
            }
        }

        public Cursor getCursor(int lineNum) {
            return this.myRevisions.containsKey(lineNum) ? Cursor.getPredefinedCursor(12) : Cursor.getDefaultCursor();
        }

        public String getLineText(int line, Editor editor) {
            LastRevision revision = this.myRevisions.get(line);
            if (revision != null) {
                return String.format("%" + this.myMaxDateLength + "s", FileAnnotation.formatDate((Date)revision.getDate())) + " " + revision.getAuthor();
            }
            return "";
        }

        public String getToolTip(int line, Editor editor) {
            LastRevision revision = this.myRevisions.get(line);
            if (revision != null) {
                return XmlStringUtil.escapeString((String)(revision.getAuthor() + " " + DateFormatUtil.formatDateTime((Date)revision.getDate()) + "\n" + VcsUtil.trimCommitMessageToSaneSize((String)revision.getMessage())));
            }
            return null;
        }

        public EditorFontType getStyle(int line, Editor editor) {
            LastRevision revision = this.myRevisions.get(line);
            return revision != null && revision.getDate().equals(this.myNewestDate) ? EditorFontType.BOLD : EditorFontType.PLAIN;
        }

        public ColorKey getColor(int line, Editor editor) {
            return AnnotationSource.LOCAL.getColor();
        }

        public Color getBgColor(int line, Editor editor) {
            return null;
        }

        public List<AnAction> getPopupActions(int line, Editor editor) {
            return Collections.emptyList();
        }

        public void gutterClosed() {
            this.myIndicator.cancel();
        }

        public void updateData(@NotNull Map<Integer, LastRevision> revisions) {
            this.myRevisions = revisions;
            Date newestDate = null;
            int maxDateLength = 0;
            for (LastRevision revision : this.myRevisions.values()) {
                int length;
                Date date = revision.getDate();
                if (newestDate == null || date.after(newestDate)) {
                    newestDate = date;
                }
                if ((length = DateFormatUtil.formatPrettyDate((Date)date).length()) <= maxDateLength) continue;
                maxDateLength = length;
            }
            this.myNewestDate = newestDate;
            this.myMaxDateLength = maxDateLength;
        }
    }

    private static class LastRevision {
        @NotNull
        private final VcsRevisionNumber myNumber;
        @NotNull
        private final String myAuthor;
        @NotNull
        private final Date myDate;
        @NotNull
        private final String myMessage;

        LastRevision(@NotNull VcsRevisionNumber number, @NotNull String author, @NotNull Date date, @NotNull String message) {
            this.myNumber = number;
            this.myAuthor = author;
            this.myDate = date;
            this.myMessage = message;
        }

        @NotNull
        public static LastRevision create(@NotNull VcsFileRevision revision) {
            VcsRevisionNumber number = revision.getRevisionNumber();
            String author = StringUtil.notNullize((String)revision.getAuthor(), (String)"Unknown");
            Date date = revision.getRevisionDate();
            String message = StringUtil.notNullize((String)revision.getCommitMessage());
            return new LastRevision(number, author, date, message);
        }

        @NotNull
        public VcsRevisionNumber getNumber() {
            return this.myNumber;
        }

        @NotNull
        public String getAuthor() {
            return this.myAuthor;
        }

        @NotNull
        public Date getDate() {
            return this.myDate;
        }

        @NotNull
        public String getMessage() {
            return this.myMessage;
        }
    }
}

