/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.vfs;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.vfs.AbstractVcsVirtualFile;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.util.ArrayUtilRt;
import com.intellij.vcsUtil.VcsUtil;
import java.io.IOException;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsVirtualFile
extends AbstractVcsVirtualFile {
    private static final Logger LOG = Logger.getInstance(VcsVirtualFile.class);
    private final VcsFileRevision myFileRevision;
    private volatile byte[] myContent;
    private volatile boolean myContentLoadFailed;
    private volatile Charset myCharset;
    private final Object LOCK = new Object();

    public VcsVirtualFile(@NotNull String path2, @Nullable VcsFileRevision revision, @NotNull VirtualFileSystem fileSystem) {
        super(path2, fileSystem);
        this.myFileRevision = revision;
    }

    public VcsVirtualFile(@NotNull VirtualFile parent, @NotNull String name, @Nullable VcsFileRevision revision, VirtualFileSystem fileSystem) {
        super(parent, name, fileSystem);
        this.myFileRevision = revision;
    }

    public VcsVirtualFile(@NotNull String path2, byte @NotNull [] content2, @Nullable String revision, @NotNull VirtualFileSystem fileSystem) {
        this(path2, null, fileSystem);
        this.myContent = content2;
        this.setRevision(revision);
    }

    @Override
    public byte @NotNull [] contentsToByteArray() throws IOException {
        if (this.myContentLoadFailed) {
            return ArrayUtilRt.EMPTY_BYTE_ARRAY;
        }
        if (this.myContent == null) {
            this.loadContent();
        }
        return this.myContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadContent() throws IOException {
        assert (this.myFileRevision != null);
        if (this.myContent != null) {
            return;
        }
        try {
            byte[] content2 = this.myFileRevision.loadContent();
            Object object = this.LOCK;
            synchronized (object) {
                this.setRevision(VcsUtil.getShortRevisionString((VcsRevisionNumber)this.myFileRevision.getRevisionNumber()));
                this.myContent = content2;
                this.myContentLoadFailed = false;
                if (this.myContent != null) {
                    this.myCharset = new CharsetToolkit(this.myContent).guessEncoding(this.myContent.length);
                }
            }
        }
        catch (VcsException e) {
            Object object = this.LOCK;
            synchronized (object) {
                this.myContentLoadFailed = true;
                this.myContent = ArrayUtilRt.EMPTY_BYTE_ARRAY;
                this.setRevision("0");
            }
            this.showLoadingContentFailedMessage(e);
        }
    }

    @Nullable
    public VcsFileRevision getFileRevision() {
        return this.myFileRevision;
    }

    @NotNull
    public Charset getCharset() {
        if (this.myCharset != null) {
            return this.myCharset;
        }
        return super.getCharset();
    }

    public boolean isDirectory() {
        return false;
    }

    public String getRevision() {
        if (this.myRevision == null) {
            try {
                this.loadContent();
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
        }
        return this.myRevision;
    }
}

