/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.update;

import com.intellij.openapi.util.Clock;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.update.ActionInfo;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.util.text.DateFormatUtil;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

final class UpdateInfo {
    private UpdatedFiles myUpdatedFiles;
    private String myDate;
    private ActionInfo myActionInfo;
    @NonNls
    private static final String DATE_ATTR = "date";
    @NonNls
    private static final String FILE_INFO_ELEMENTS = "UpdatedFiles";
    @NonNls
    private static final String ACTION_INFO_ATTRIBUTE_NAME = "ActionInfo";

    UpdateInfo(UpdatedFiles updatedFiles, ActionInfo actionInfo) {
        this.myActionInfo = actionInfo;
        this.myUpdatedFiles = updatedFiles;
        this.myDate = DateFormatUtil.formatPrettyDateTime((long)Clock.getTime());
    }

    UpdateInfo() {
    }

    public void writeExternal(@NotNull Element element) {
        if (this.myUpdatedFiles == null) {
            return;
        }
        element.setAttribute(DATE_ATTR, this.myDate);
        element.setAttribute(ACTION_INFO_ATTRIBUTE_NAME, this.myActionInfo.getActionName());
        Element filesElement = new Element(FILE_INFO_ELEMENTS);
        this.myUpdatedFiles.writeExternal(filesElement);
        element.addContent(filesElement);
    }

    public void readExternal(@NotNull Element element) {
        this.myDate = element.getAttributeValue(DATE_ATTR);
        Element fileInfoElement = element.getChild(FILE_INFO_ELEMENTS);
        if (fileInfoElement == null) {
            return;
        }
        String actionInfoName = element.getAttributeValue(ACTION_INFO_ATTRIBUTE_NAME);
        this.myActionInfo = UpdateInfo.getActionInfoByName(actionInfoName);
        if (this.myActionInfo == null) {
            return;
        }
        UpdatedFiles updatedFiles = UpdatedFiles.create();
        updatedFiles.readExternal(fileInfoElement);
        this.myUpdatedFiles = updatedFiles;
    }

    private static ActionInfo getActionInfoByName(String actionInfoName) {
        if (ActionInfo.UPDATE.getActionName().equals(actionInfoName)) {
            return ActionInfo.UPDATE;
        }
        if (ActionInfo.STATUS.getActionName().equals(actionInfoName)) {
            return ActionInfo.STATUS;
        }
        return null;
    }

    public UpdatedFiles getFileInformation() {
        return this.myUpdatedFiles;
    }

    public String getCaption() {
        return VcsBundle.message((String)"toolwindow.title.update.project", (Object[])new Object[]{this.myDate});
    }

    public boolean isEmpty() {
        return this.myUpdatedFiles == null || this.myUpdatedFiles.isEmpty();
    }

    public ActionInfo getActionInfo() {
        return this.myActionInfo;
    }
}

