/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.roots;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.VcsRootChecker;
import com.intellij.openapi.vcs.impl.projectlevelman.AllVcses;
import com.intellij.openapi.vcs.roots.VcsRootDetector;
import com.intellij.openapi.vcs.roots.VcsRootScanner;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsRootDetectorImpl
implements VcsRootDetector {
    private static final Logger LOG = Logger.getInstance(VcsRootDetectorImpl.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final ProjectLevelVcsManager myVcsManager;
    @Nullable
    private Collection<DetectedVcsRoot> myDetectedRoots;
    @NotNull
    private final Object LOCK = new Object();

    public VcsRootDetectorImpl(@NotNull Project project) {
        this.myProject = project;
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Collection<VcsRoot> detect() {
        Object object = this.LOCK;
        synchronized (object) {
            Collection<VcsRoot> roots = this.scanForRootsInContentRoots();
            this.myDetectedRoots = ContainerUtil.map(roots, x$0 -> new DetectedVcsRoot((VcsRoot)x$0));
            return roots;
        }
    }

    @NotNull
    public Collection<VcsRoot> detect(@Nullable VirtualFile startDir) {
        if (startDir == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableSet(this.scanForDirectory(startDir));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Collection<VcsRoot> getOrDetect() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.myDetectedRoots != null) {
                return ContainerUtil.mapNotNull(this.myDetectedRoots, it -> it.toVcsRoot(this.myProject));
            }
            return this.detect();
        }
    }

    @NotNull
    private Set<VcsRoot> scanForDirectory(@NotNull VirtualFile dirToScan) {
        if (!VcsRootChecker.EXTENSION_POINT_NAME.hasAnyExtensions()) {
            return Collections.emptySet();
        }
        HashSet<VcsRoot> detectedRoots = new HashSet<VcsRoot>(this.scanForRootsInsideDir(dirToScan, null));
        detectedRoots.addAll(this.scanForRootsAboveDirs(Collections.singletonList(dirToScan), detectedRoots));
        return detectedRoots;
    }

    @NotNull
    private Collection<VcsRoot> scanForRootsInContentRoots() {
        if (this.myProject.isDisposed()) {
            return Collections.emptyList();
        }
        if (!VcsRootChecker.EXTENSION_POINT_NAME.hasAnyExtensions()) {
            return Collections.emptyList();
        }
        ArrayList contentRoots = ContainerUtil.newArrayList((Object[])ProjectRootManager.getInstance((Project)this.myProject).getContentRoots());
        VirtualFile baseDir = this.myProject.getBaseDir();
        if (baseDir != null && !contentRoots.contains(baseDir)) {
            contentRoots.add(baseDir);
        }
        HashSet<VcsRoot> detectedRoots = new HashSet<VcsRoot>();
        HashSet<VirtualFile> skipDirs = new HashSet<VirtualFile>();
        ContainerUtil.sort((List)contentRoots, Comparator.comparing(root -> -root.getPath().length()));
        for (VirtualFile dir : contentRoots) {
            detectedRoots.addAll(this.scanForRootsInsideDir(dir, skipDirs));
            skipDirs.add(dir);
        }
        detectedRoots.addAll(this.scanForRootsAboveDirs(contentRoots, detectedRoots));
        return detectedRoots;
    }

    private Set<VcsRoot> scanForRootsInsideDir(@NotNull VirtualFile root, @Nullable Set<VirtualFile> skipDirs) {
        HashSet<VcsRoot> roots = new HashSet<VcsRoot>();
        VcsRootScanner.visitDirsRecursivelyWithoutExcluded(this.myProject, ProjectRootManager.getInstance((Project)this.myProject), root, dir -> {
            if (skipDirs != null && skipDirs.contains(dir)) {
                return VirtualFileVisitor.SKIP_CHILDREN;
            }
            VcsRoot vcsRoot = this.getVcsRootFor((VirtualFile)dir);
            if (vcsRoot != null) {
                LOG.debug("Found VCS " + vcsRoot.getVcs() + " in " + vcsRoot.getPath() + " under " + root.getPath());
                roots.add(vcsRoot);
            }
            return VirtualFileVisitor.CONTINUE;
        });
        return roots;
    }

    @NotNull
    private Collection<VcsRoot> scanForRootsAboveDirs(@NotNull Collection<VirtualFile> dirsToScan, @NotNull Collection<VcsRoot> detectedRoots) {
        HashSet<VcsRoot> result2 = new HashSet<VcsRoot>();
        HashSet<VirtualFile> skipDirs = new HashSet<VirtualFile>();
        for (VcsRoot root : detectedRoots) {
            skipDirs.add(root.getPath());
        }
        ContainerUtil.addIfNotNull(skipDirs, (Object)VfsUtil.getUserHomeDir());
        for (VirtualFile dir : dirsToScan) {
            VcsRoot root = this.scanForRootsAboveDir(dir, skipDirs);
            if (root == null) continue;
            result2.add(root);
        }
        return result2;
    }

    @Nullable
    private VcsRoot scanForRootsAboveDir(@NotNull VirtualFile root, @NotNull Set<VirtualFile> skipDirs) {
        Pattern ignorePattern = VcsRootScanner.parseDirIgnorePattern();
        if (VcsRootScanner.isUnderIgnoredDirectory(this.myProject, ignorePattern, root)) {
            return null;
        }
        for (VirtualFile parent = root; parent != null && skipDirs.add(parent); parent = parent.getParent()) {
            VcsRoot vcsRoot = this.getVcsRootFor(parent, root);
            if (vcsRoot == null) continue;
            LOG.debug("Found VCS " + vcsRoot.getVcs() + " in " + vcsRoot.getPath() + " above " + root.getPath());
            return vcsRoot;
        }
        return null;
    }

    @Nullable
    private VcsRoot getVcsRootFor(@NotNull VirtualFile dir) {
        return this.getVcsRootFor(dir, null);
    }

    @Nullable
    private VcsRoot getVcsRootFor(@NotNull VirtualFile maybeRoot, @Nullable VirtualFile dirToCheckForIgnore) {
        ProgressManager.checkCanceled();
        String path2 = maybeRoot.getPath();
        return (VcsRoot)VcsRootChecker.EXTENSION_POINT_NAME.computeSafeIfAny(checker -> {
            if (checker.isRoot(path2) && (dirToCheckForIgnore == null || !checker.isIgnored(maybeRoot, dirToCheckForIgnore))) {
                AbstractVcs vcs = this.myVcsManager.findVcsByName(checker.getSupportedVcs().getName());
                if (vcs != null) {
                    return new VcsRoot(vcs, maybeRoot);
                }
                return null;
            }
            return null;
        });
    }

    private static class DetectedVcsRoot {
        @Nullable
        private final String myVcsName;
        @NotNull
        private final VirtualFile myPath;

        private DetectedVcsRoot(@NotNull VcsRoot root) {
            AbstractVcs vcs = root.getVcs();
            this.myVcsName = vcs != null ? vcs.getName() : null;
            this.myPath = root.getPath();
        }

        @Nullable
        public VcsRoot toVcsRoot(@NotNull Project project) {
            if (this.myVcsName == null) {
                return null;
            }
            AbstractVcs vcs = AllVcses.getInstance(project).getByName(this.myVcsName);
            return vcs != null ? new VcsRoot(vcs, this.myPath) : null;
        }
    }
}

