/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl.projectlevelman;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsListener;
import com.intellij.openapi.vcs.VcsRootChecker;
import com.intellij.openapi.vcs.impl.DefaultVcsRootPolicy;
import com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl;
import com.intellij.openapi.vcs.impl.projectlevelman.AllVcses;
import com.intellij.openapi.vcs.impl.projectlevelman.FilePathMapping;
import com.intellij.openapi.vcs.impl.projectlevelman.FileWatchRequestsManager;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerListener;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.Alarm;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.update.DisposableUpdate;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewMappings
implements Disposable {
    private static final Comparator<MappedRoot> ROOT_COMPARATOR = Comparator.comparing(it -> it.root.getPath());
    private static final Comparator<VcsDirectoryMapping> MAPPINGS_COMPARATOR = Comparator.comparing(VcsDirectoryMapping::getDirectory);
    private static final Logger LOG = Logger.getInstance(NewMappings.class);
    private final Object myUpdateLock = new Object();
    private FileWatchRequestsManager myFileWatchRequestsManager;
    private final DefaultVcsRootPolicy myDefaultVcsRootPolicy;
    private final ProjectLevelVcsManager myVcsManager;
    private final Project myProject;
    @NotNull
    private Disposable myFilePointerDisposable = Disposer.newDisposable();
    private volatile List<VcsDirectoryMapping> myMappings = Collections.emptyList();
    private volatile List<MappedRoot> myMappedRoots = Collections.emptyList();
    private volatile RootMapping myMappedRootsMapping = new RootMapping(Collections.emptyList());
    private volatile List<AbstractVcs> myActiveVcses = Collections.emptyList();
    private volatile boolean myActivated = false;
    @NotNull
    private final MergingUpdateQueue myRootUpdateQueue;
    private final VirtualFilePointerListener myFilePointerListener;

    public NewMappings(@NotNull Project project, @NotNull ProjectLevelVcsManagerImpl vcsManager2) {
        this.myProject = project;
        this.myVcsManager = vcsManager2;
        this.myFileWatchRequestsManager = new FileWatchRequestsManager(this.myProject, this);
        this.myDefaultVcsRootPolicy = DefaultVcsRootPolicy.getInstance(project);
        this.myRootUpdateQueue = new MergingUpdateQueue("NewMappings", 1000, true, null, (Disposable)this, null, Alarm.ThreadToUse.POOLED_THREAD).usePassThroughInUnitTestMode();
        this.myFilePointerListener = new VirtualFilePointerListener(){

            public void validityChanged(VirtualFilePointer @NotNull [] pointers) {
                NewMappings.this.scheduleMappedRootsUpdate();
            }
        };
        VcsRootChecker.EXTENSION_POINT_NAME.addChangeListener(() -> this.scheduleMappedRootsUpdate(), (Disposable)project);
    }

    public void setFileWatchRequestsManager(FileWatchRequestsManager fileWatchRequestsManager) {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        this.myFileWatchRequestsManager = fileWatchRequestsManager;
    }

    public AbstractVcs @NotNull [] getActiveVcses() {
        return this.myActiveVcses.toArray(new AbstractVcs[0]);
    }

    public boolean hasActiveVcss() {
        return !this.myActiveVcses.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activateActiveVcses() {
        Object object = this.myUpdateLock;
        synchronized (object) {
            if (this.myActivated) {
                return;
            }
            this.myActivated = true;
            LOG.debug("activated");
        }
        this.updateActiveVcses();
        this.updateMappedRoots(true);
    }

    private boolean updateActiveVcses() {
        MyVcsActivator activator = (MyVcsActivator)ReadAction.compute(() -> {
            Object object = this.myUpdateLock;
            synchronized (object) {
                return this.myActivated ? this.createVcsActivator() : null;
            }
        });
        if (activator != null) {
            activator.activate();
        }
        return activator != null;
    }

    public void setMapping(@NotNull String path2, @Nullable String activeVcsName) {
        LOG.debug("setMapping path = '" + path2 + "' vcs = " + activeVcsName);
        VcsDirectoryMapping newMapping = new VcsDirectoryMapping(path2, activeVcsName);
        ArrayList<VcsDirectoryMapping> newMappings = new ArrayList<VcsDirectoryMapping>(this.myMappings);
        newMappings.removeIf(mapping -> Objects.equals(mapping.getDirectory(), newMapping.getDirectory()));
        newMappings.add(newMapping);
        this.updateVcsMappings(newMappings);
    }

    public void waitMappedRootsUpdate() {
        this.myRootUpdateQueue.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMappedVcsesImmediately() {
        LOG.debug("updateMappingsImmediately");
        if (!this.updateActiveVcses()) {
            return;
        }
        Object object = this.myUpdateLock;
        synchronized (object) {
            Disposer.dispose((Disposable)this.myFilePointerDisposable);
            this.myFilePointerDisposable = Disposer.newDisposable();
            this.myMappedRoots = Collections.emptyList();
            this.myMappedRootsMapping = new RootMapping(Collections.emptyList());
            this.dumpMappedRootsToLog();
        }
        this.mappingsChanged();
        this.scheduleMappedRootsUpdate();
    }

    public void scheduleMappedRootsUpdate() {
        this.myRootUpdateQueue.queue((Update)new DisposableUpdate(this, "update"){

            @Override
            public void doRun() {
                NewMappings.this.updateMappedRoots(true);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateVcsMappings(@NotNull Collection<? extends VcsDirectoryMapping> mappings) {
        this.myRootUpdateQueue.cancelAllUpdates();
        List newMappings = Collections.unmodifiableList(ContainerUtil.sorted(NewMappings.removeDuplicates(mappings), MAPPINGS_COMPARATOR));
        Object object = this.myUpdateLock;
        synchronized (object) {
            boolean mappingsChanged;
            boolean bl = mappingsChanged = !this.myMappings.equals(newMappings);
            if (!mappingsChanged) {
                return;
            }
            this.myMappings = newMappings;
            this.dumpMappingsToLog();
        }
        this.updateActiveVcses();
        this.updateMappedRoots(false);
        this.mappingsChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMappedRoots(boolean fireMappingsChangedEvent) {
        boolean mappedRootsChanged;
        this.myRootUpdateQueue.cancelAllUpdates();
        if (!this.myActivated) {
            return;
        }
        LOG.debug("updateMappedRoots");
        List<VcsDirectoryMapping> mappings = this.myMappings;
        Mappings newMappedRoots = this.collectMappedRoots(mappings);
        Object object = this.myUpdateLock;
        synchronized (object) {
            if (this.myMappings != mappings) {
                Disposer.dispose((Disposable)newMappedRoots.filePointerDisposable);
                return;
            }
            Disposer.dispose((Disposable)this.myFilePointerDisposable);
            this.myFilePointerDisposable = newMappedRoots.filePointerDisposable;
            boolean bl = mappedRootsChanged = !this.myMappedRoots.equals(newMappedRoots.mappedRoots);
            if (mappedRootsChanged) {
                this.myMappedRoots = newMappedRoots.mappedRoots;
                this.myMappedRootsMapping = new RootMapping(newMappedRoots.mappedRoots);
                this.dumpMappedRootsToLog();
            }
        }
        if (fireMappingsChangedEvent && mappedRootsChanged) {
            this.mappingsChanged();
        }
    }

    @NotNull
    private static List<VcsDirectoryMapping> removeDuplicates(@NotNull Collection<? extends VcsDirectoryMapping> mappings) {
        ArrayList<VcsDirectoryMapping> newMapping = new ArrayList<VcsDirectoryMapping>();
        HashSet<String> paths = new HashSet<String>();
        for (VcsDirectoryMapping mapping : ContainerUtil.reverse(new ArrayList<VcsDirectoryMapping>(mappings))) {
            if (!paths.add(mapping.getDirectory())) continue;
            newMapping.add(mapping);
        }
        return newMapping;
    }

    @NotNull
    private Mappings collectMappedRoots(@NotNull List<VcsDirectoryMapping> mappings) {
        VirtualFilePointerManager pointerManager = VirtualFilePointerManager.getInstance();
        HashMap mappedRoots = new HashMap();
        Disposable pointerDisposable = Disposer.newDisposable();
        try {
            AbstractVcs vcs;
            for (VcsDirectoryMapping mapping : mappings) {
                if (mapping.isDefaultMapping()) continue;
                vcs = this.getMappingsVcs(mapping);
                String rootPath = mapping.getDirectory();
                ReadAction.run(() -> {
                    VirtualFile vcsRoot = LocalFileSystem.getInstance().findFileByPath(rootPath);
                    if (vcsRoot != null && vcsRoot.isDirectory()) {
                        if (this.checkMappedRoot(vcs, vcsRoot)) {
                            mappedRoots.putIfAbsent(vcsRoot, new MappedRoot(vcs, mapping, vcsRoot));
                        } else {
                            mappedRoots.putIfAbsent(vcsRoot, new MappedRoot(null, mapping, vcsRoot));
                        }
                    }
                    pointerManager.create(VfsUtilCore.pathToUrl((String)rootPath), pointerDisposable, this.myFilePointerListener);
                });
            }
            for (VcsDirectoryMapping mapping : mappings) {
                if (!mapping.isDefaultMapping() || (vcs = this.getMappingsVcs(mapping)) == null) continue;
                Collection<VirtualFile> defaultRoots = this.detectDefaultRootsFor(vcs, this.myDefaultVcsRootPolicy.getDefaultVcsRoots(), ContainerUtil.map2Set(mappedRoots.values(), it -> it.root));
                ReadAction.run(() -> {
                    for (VirtualFile vcsRoot : defaultRoots) {
                        if (vcsRoot == null || !vcsRoot.isDirectory()) continue;
                        mappedRoots.putIfAbsent(vcsRoot, new MappedRoot(vcs, mapping, vcsRoot));
                        pointerManager.create(vcsRoot, pointerDisposable, this.myFilePointerListener);
                    }
                });
            }
            return new Mappings(Collections.unmodifiableList(ContainerUtil.sorted(mappedRoots.values(), ROOT_COMPARATOR)), pointerDisposable);
        }
        catch (Throwable e) {
            Disposer.dispose((Disposable)pointerDisposable);
            ExceptionUtil.rethrow((Throwable)e);
            return null;
        }
    }

    @Nullable
    private AbstractVcs getMappingsVcs(@NotNull VcsDirectoryMapping mapping) {
        return AllVcses.getInstance(this.myProject).getByName(mapping.getVcs());
    }

    private boolean checkMappedRoot(@Nullable AbstractVcs vcs, @NotNull VirtualFile vcsRoot) {
        try {
            if (vcs == null) {
                return false;
            }
            VcsRootChecker rootChecker = this.myVcsManager.getRootChecker(vcs);
            return rootChecker.validateRoot(vcsRoot.getPath());
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error(e);
            return false;
        }
    }

    @NotNull
    private Collection<VirtualFile> detectDefaultRootsFor(@NotNull AbstractVcs vcs, @NotNull Collection<VirtualFile> projectRoots, @NotNull Set<VirtualFile> mappedDirs) {
        try {
            if (vcs.needsLegacyDefaultMappings()) {
                return projectRoots;
            }
            DirectoryIndex directoryIndex = DirectoryIndex.getInstance((Project)this.myProject);
            VcsRootChecker rootChecker = this.myVcsManager.getRootChecker(vcs);
            HashMap<VirtualFile, Boolean> checkedDirs = new HashMap<VirtualFile, Boolean>();
            HashSet<VirtualFile> vcsRoots = new HashSet<VirtualFile>();
            block3: for (VirtualFile f : projectRoots) {
                while (f != null && !vcsRoots.contains(f) && !mappedDirs.contains(f)) {
                    if (NewMappings.isVcsRoot(rootChecker, checkedDirs, f)) {
                        vcsRoots.add(f);
                        continue block3;
                    }
                    VirtualFile parent = f.getParent();
                    if (parent != null && !this.isUnderProject(directoryIndex, parent)) {
                        if (!rootChecker.areChildrenValidMappings()) continue block3;
                        while (parent != null && !vcsRoots.contains(parent) && !mappedDirs.contains(parent)) {
                            if (NewMappings.isVcsRoot(rootChecker, checkedDirs, parent)) {
                                vcsRoots.add(f);
                                continue block3;
                            }
                            parent = parent.getParent();
                        }
                        continue block3;
                    }
                    f = parent;
                }
            }
            return vcsRoots;
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error(e);
            return Collections.emptyList();
        }
    }

    private static boolean isVcsRoot(@NotNull VcsRootChecker rootChecker, @NotNull Map<VirtualFile, Boolean> checkedDirs, @NotNull VirtualFile file) {
        ProgressManager.checkCanceled();
        return checkedDirs.computeIfAbsent(file, key -> rootChecker.isRoot(key.getPath()));
    }

    private boolean isUnderProject(@NotNull DirectoryIndex directoryIndex, @NotNull VirtualFile f) {
        return (Boolean)ReadAction.compute(() -> {
            if (this.myProject.isDisposed()) {
                throw new ProcessCanceledException();
            }
            return directoryIndex.getInfoForFile(f).isInProject(f);
        });
    }

    public void mappingsChanged() {
        ((VcsListener)BackgroundTaskUtil.syncPublisher((Project)this.myProject, (Topic)ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED)).directoryMappingChanged();
        this.myFileWatchRequestsManager.ping();
    }

    private void dumpMappingsToLog() {
        for (VcsDirectoryMapping mapping : this.myMappings) {
            String path2 = mapping.isDefaultMapping() ? "<Project>" : mapping.getDirectory();
            String vcs = mapping.getVcs();
            LOG.info(String.format("VCS Root: [%s] - [%s]", vcs, path2));
        }
    }

    private void dumpMappedRootsToLog() {
        if (LOG.isDebugEnabled()) {
            for (MappedRoot root : this.myMappedRoots) {
                LOG.debug(String.format("Mapped Root: [%s] - [%s]", root.vcs, root.root.getPath()));
            }
        } else if (this.haveDefaultMapping() != null) {
            LOG.info("Mapped Roots: " + this.myMappedRoots.size());
        }
    }

    public void setDirectoryMappings(@NotNull List<? extends VcsDirectoryMapping> items) {
        LOG.debug("setDirectoryMappings, size: " + items.size());
        this.updateVcsMappings(items);
    }

    @Nullable
    public MappedRoot getMappedRootFor(@Nullable VirtualFile file) {
        if (file == null || !file.isInLocalFileSystem()) {
            return null;
        }
        if (this.myMappedRoots.isEmpty()) {
            return null;
        }
        if (this.myVcsManager.isIgnored(file)) {
            return null;
        }
        return this.myMappedRootsMapping.getRootFor(file);
    }

    @Nullable
    public MappedRoot getMappedRootFor(@Nullable FilePath file) {
        if (file == null || file.isNonLocal()) {
            return null;
        }
        if (this.myMappedRoots.isEmpty()) {
            return null;
        }
        if (this.myVcsManager.isIgnored(file)) {
            return null;
        }
        return this.myMappedRootsMapping.getRootFor(file);
    }

    @NotNull
    public List<VirtualFile> getMappingsAsFilesUnderVcs(@NotNull AbstractVcs vcs) {
        return ContainerUtil.mapNotNull(this.myMappedRoots, root -> vcs.equals((Object)root.vcs) ? root.root : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        MyVcsActivator activator;
        LOG.debug("disposed");
        Object object = this.myUpdateLock;
        synchronized (object) {
            Disposer.dispose((Disposable)this.myFilePointerDisposable);
            this.myMappings = Collections.emptyList();
            this.myMappedRoots = Collections.emptyList();
            this.myFilePointerDisposable = Disposer.newDisposable();
            activator = this.createVcsActivator();
        }
        activator.activate();
    }

    public List<VcsDirectoryMapping> getDirectoryMappings() {
        return this.myMappings;
    }

    public List<VcsDirectoryMapping> getDirectoryMappings(String vcsName) {
        return ContainerUtil.filter(this.myMappings, mapping -> Objects.equals(mapping.getVcs(), vcsName));
    }

    @Nullable
    public String haveDefaultMapping() {
        VcsDirectoryMapping defaultMapping = (VcsDirectoryMapping)ContainerUtil.find(this.myMappings, mapping -> mapping.isDefaultMapping());
        return defaultMapping != null ? defaultMapping.getVcs() : null;
    }

    public boolean isEmpty() {
        return ContainerUtil.all(this.myMappings, mapping -> mapping.isNoneMapping());
    }

    public void removeDirectoryMapping(@NotNull VcsDirectoryMapping mapping) {
        LOG.debug("remove mapping: " + mapping.getDirectory());
        ArrayList<VcsDirectoryMapping> newMappings = new ArrayList<VcsDirectoryMapping>(this.myMappings);
        newMappings.remove(mapping);
        this.updateVcsMappings(newMappings);
    }

    public void cleanupMappings() {
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        ArrayList<VcsDirectoryMapping> oldMappings = new ArrayList<VcsDirectoryMapping>(this.getDirectoryMappings());
        ArrayList<VcsDirectoryMapping> filteredMappings = new ArrayList<VcsDirectoryMapping>();
        VcsDirectoryMapping defaultMapping = (VcsDirectoryMapping)ContainerUtil.find(oldMappings, it -> it.isDefaultMapping());
        if (defaultMapping != null) {
            oldMappings.remove(defaultMapping);
            filteredMappings.add(defaultMapping);
        }
        MultiMap groupedMappings = new MultiMap();
        for (VcsDirectoryMapping mapping : oldMappings) {
            groupedMappings.putValue((Object)mapping.getVcs(), (Object)mapping);
        }
        for (Map.Entry entry : groupedMappings.entrySet()) {
            String vcsName = (String)entry.getKey();
            Collection mappings = (Collection)entry.getValue();
            List objects = ContainerUtil.mapNotNull((Collection)mappings, dm -> {
                VirtualFile vf = lfs.refreshAndFindFileByPath(dm.getDirectory());
                return vf == null ? null : Pair.create((Object)vf, (Object)dm);
            });
            if (StringUtil.isEmptyOrSpaces((String)vcsName)) {
                filteredMappings.addAll(ContainerUtil.map((Collection)objects, (Function)Functions.pairSecond()));
                continue;
            }
            AbstractVcs vcs = this.myVcsManager.findVcsByName(vcsName);
            if (vcs == null) {
                VcsBalloonProblemNotifier.showOverChangesView(this.myProject, "VCS plugin not found for mapping to : '" + vcsName + "'", MessageType.ERROR, new NamedRunnable[0]);
                filteredMappings.addAll(mappings);
                continue;
            }
            filteredMappings.addAll(ContainerUtil.map((Collection)vcs.filterUniqueRoots(objects, pair -> (VirtualFile)pair.getFirst()), (Function)Functions.pairSecond()));
        }
        this.updateVcsMappings(filteredMappings);
    }

    @NotNull
    private MyVcsActivator createVcsActivator() {
        Set newVcses = ContainerUtil.map2SetNotNull(this.myMappings, mapping -> this.getMappingsVcs((VcsDirectoryMapping)mapping));
        List<AbstractVcs> oldVcses = this.myActiveVcses;
        this.myActiveVcses = Collections.unmodifiableList(new ArrayList(newVcses));
        Collection toAdd = ContainerUtil.subtract(this.myActiveVcses, oldVcses);
        Collection toRemove = ContainerUtil.subtract(oldVcses, this.myActiveVcses);
        return new MyVcsActivator(toAdd, toRemove);
    }

    public boolean haveActiveVcs(String name) {
        return ContainerUtil.exists(this.myActiveVcses, vcs -> Objects.equals(vcs.getName(), name));
    }

    public void beingUnregistered(String name) {
        ArrayList<VcsDirectoryMapping> newMappings = new ArrayList<VcsDirectoryMapping>(this.myMappings);
        newMappings.removeIf(mapping -> Objects.equals(mapping.getVcs(), name));
        this.updateVcsMappings(newMappings);
    }

    private static class RootMapping {
        private final Map<VirtualFile, MappedRoot> myVFMap = new HashMap<VirtualFile, MappedRoot>();
        private final FilePathMapping<MappedRoot> myPathMapping = new FilePathMapping(SystemInfo.isFileSystemCaseSensitive);

        private RootMapping(@NotNull List<MappedRoot> mappedRoots) {
            for (MappedRoot root : mappedRoots) {
                this.myVFMap.put(root.root, root);
                this.myPathMapping.add(root.root.getPath(), root);
            }
        }

        @Nullable
        public MappedRoot getRootFor(@NotNull VirtualFile file) {
            while (file != null) {
                MappedRoot root = this.myVFMap.get(file);
                if (root != null) {
                    return root;
                }
                file = file.getParent();
            }
            return null;
        }

        @Nullable
        public MappedRoot getRootFor(@NotNull FilePath filePath) {
            return this.myPathMapping.getMappingFor(filePath);
        }
    }

    private static class Mappings {
        @NotNull
        public final List<MappedRoot> mappedRoots;
        @NotNull
        public final Disposable filePointerDisposable;

        private Mappings(@NotNull List<MappedRoot> mappedRoots, @NotNull Disposable filePointerDisposable) {
            this.mappedRoots = mappedRoots;
            this.filePointerDisposable = filePointerDisposable;
        }
    }

    public static class MappedRoot {
        @Nullable
        public final AbstractVcs vcs;
        @NotNull
        public final VcsDirectoryMapping mapping;
        @NotNull
        public final VirtualFile root;

        private MappedRoot(@Nullable AbstractVcs vcs, @NotNull VcsDirectoryMapping mapping, @NotNull VirtualFile root) {
            this.vcs = vcs;
            this.mapping = mapping;
            this.root = root;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MappedRoot other = (MappedRoot)o;
            return Objects.equals(this.vcs, other.vcs) && this.mapping.equals((Object)other.mapping) && this.root.equals(other.root);
        }

        public int hashCode() {
            return Objects.hash(this.vcs, this.mapping, this.root);
        }
    }

    private static class MyVcsActivator {
        @NotNull
        private final Collection<? extends AbstractVcs> myAddVcses;
        @NotNull
        private final Collection<? extends AbstractVcs> myRemoveVcses;

        private MyVcsActivator(@NotNull Collection<? extends AbstractVcs> addVcses, @NotNull Collection<? extends AbstractVcs> removeVcses) {
            this.myAddVcses = addVcses;
            this.myRemoveVcses = removeVcses;
        }

        public void activate() {
            for (AbstractVcs abstractVcs : this.myAddVcses) {
                try {
                    abstractVcs.doActivate();
                }
                catch (VcsException e) {
                    LOG.error((Throwable)e);
                }
            }
            for (AbstractVcs abstractVcs : this.myRemoveVcses) {
                try {
                    abstractVcs.doDeactivate();
                }
                catch (VcsException e) {
                    LOG.error((Throwable)e);
                }
            }
        }
    }
}

