/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.history.VcsHistoryCache;
import com.intellij.openapi.vcs.impl.ContentRevisionCache;
import com.intellij.openapi.vcs.impl.VcsEP;
import com.intellij.openapi.vcs.update.UpdatedFilesListener;
import com.intellij.util.messages.MessageBusConnection;
import org.jetbrains.annotations.NotNull;

public class VcsCacheManager {
    private final VcsHistoryCache myVcsHistoryCache = new VcsHistoryCache();
    private final ContentRevisionCache myContentRevisionCache = new ContentRevisionCache();

    public static VcsCacheManager getInstance(Project project) {
        return (VcsCacheManager)project.getService(VcsCacheManager.class);
    }

    public VcsCacheManager(@NotNull Project project) {
        MessageBusConnection connection = project.getMessageBus().connect();
        connection.subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, () -> ((VcsHistoryCache)this.myVcsHistoryCache).clearAll());
        connection.subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED_IN_PLUGIN, () -> ((VcsHistoryCache)this.myVcsHistoryCache).clearAll());
        connection.subscribe(UpdatedFilesListener.UPDATED_FILES, arg_0 -> ((ContentRevisionCache)this.myContentRevisionCache).clearCurrent(arg_0));
        VcsEP.EP_NAME.addChangeListener(() -> {
            this.myVcsHistoryCache.clearAll();
            this.myContentRevisionCache.clearAll();
        }, (Disposable)project);
    }

    public VcsHistoryCache getVcsHistoryCache() {
        return this.myVcsHistoryCache;
    }

    public ContentRevisionCache getContentRevisionCache() {
        return this.myContentRevisionCache;
    }
}

