/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListChange;
import com.intellij.openapi.vcs.changes.ChangeListManagerEx;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.conflicts.ChangelistConflictTracker;
import com.intellij.openapi.vcs.ex.ExclusionState;
import com.intellij.openapi.vcs.ex.LineStatusTracker;
import com.intellij.openapi.vcs.ex.PartialLocalLineStatusTracker;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManagerI;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.ThreeStateCheckBox;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PartialChangesUtil {
    private static final Logger LOG = Logger.getInstance(PartialChangesUtil.class);

    @Nullable
    public static PartialLocalLineStatusTracker getPartialTracker(@NotNull Project project, @NotNull Change change) {
        VirtualFile file = PartialChangesUtil.getVirtualFile(change);
        if (file == null) {
            return null;
        }
        return PartialChangesUtil.getPartialTracker(project, file);
    }

    @Nullable
    public static PartialLocalLineStatusTracker getPartialTracker(@NotNull Project project, @NotNull VirtualFile file) {
        LineStatusTracker<?> tracker = LineStatusTrackerManager.getInstance(project).getLineStatusTracker(file);
        return (PartialLocalLineStatusTracker)ObjectUtils.tryCast(tracker, PartialLocalLineStatusTracker.class);
    }

    @Nullable
    public static VirtualFile getVirtualFile(@NotNull Change change) {
        ContentRevision revision = change.getAfterRevision();
        if (!(revision instanceof CurrentContentRevision)) {
            return null;
        }
        return ((CurrentContentRevision)revision).getVirtualFile();
    }

    @NotNull
    public static List<Change> processPartialChanges(@NotNull Project project, @NotNull Collection<? extends Change> changes, boolean executeOnEDT, @NotNull PairFunction<? super List<ChangeListChange>, ? super PartialLocalLineStatusTracker, Boolean> partialProcessor) {
        if (!ContainerUtil.exists(changes, it -> it instanceof ChangeListChange)) {
            return new ArrayList<Change>(changes);
        }
        ArrayList<Change> otherChanges = new ArrayList<Change>();
        Runnable task2 = () -> {
            VirtualFile virtualFile;
            MultiMap partialChangesMap = new MultiMap();
            for (Change change : changes) {
                if (change instanceof ChangeListChange) {
                    ChangeListChange changelistChange = (ChangeListChange)change;
                    virtualFile = PartialChangesUtil.getVirtualFile(change);
                    if (virtualFile != null) {
                        partialChangesMap.putValue((Object)virtualFile, (Object)changelistChange);
                        continue;
                    }
                    otherChanges.add(changelistChange.getChange());
                    continue;
                }
                otherChanges.add(change);
            }
            LineStatusTrackerManagerI lstManager = LineStatusTrackerManager.getInstance(project);
            for (Map.Entry entry : partialChangesMap.entrySet()) {
                virtualFile = (VirtualFile)entry.getKey();
                List partialChanges = (List)entry.getValue();
                Change actualChange = ((ChangeListChange)partialChanges.get(0)).getChange();
                PartialLocalLineStatusTracker tracker = (PartialLocalLineStatusTracker)ObjectUtils.tryCast(lstManager.getLineStatusTracker(virtualFile), PartialLocalLineStatusTracker.class);
                if (tracker == null) {
                    otherChanges.add(actualChange);
                    continue;
                }
                boolean success2 = (Boolean)partialProcessor.fun((Object)partialChanges, (Object)tracker);
                if (success2) continue;
                otherChanges.add(actualChange);
            }
        };
        if (executeOnEDT && !ApplicationManager.getApplication().isDispatchThread()) {
            ApplicationManager.getApplication().invokeAndWait(task2);
        } else {
            task2.run();
        }
        return otherChanges;
    }

    public static void runUnderChangeList(@NotNull Project project, @Nullable LocalChangeList targetChangeList, @NotNull Runnable task2) {
        PartialChangesUtil.computeUnderChangeList(project, targetChangeList, null, () -> {
            task2.run();
            return null;
        }, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T computeUnderChangeList(@NotNull Project project, @Nullable LocalChangeList targetChangeList, @Nullable String title2, @NotNull Computable<T> task2, boolean shouldAwaitCLMRefresh) {
        Object object;
        block6: {
            LocalChangeList oldDefaultList;
            ChangeListManagerImpl clm;
            block5: {
                InvokeAfterUpdateMode mode;
                clm = ChangeListManagerImpl.getInstanceImpl(project);
                oldDefaultList = clm.getDefaultChangeList();
                if (targetChangeList == null || targetChangeList.equals(oldDefaultList)) {
                    return (T)task2.compute();
                }
                PartialChangesUtil.switchChangeList(clm, targetChangeList, oldDefaultList);
                ChangelistConflictTracker clmConflictTracker = clm.getConflictTracker();
                try {
                    clmConflictTracker.setIgnoreModifications(true);
                    object = task2.compute();
                    clmConflictTracker.setIgnoreModifications(false);
                    if (!shouldAwaitCLMRefresh) break block5;
                    mode = title2 != null ? InvokeAfterUpdateMode.BACKGROUND_NOT_CANCELLABLE : InvokeAfterUpdateMode.SILENT_CALLBACK_POOLED;
                }
                catch (Throwable throwable) {
                    clmConflictTracker.setIgnoreModifications(false);
                    if (shouldAwaitCLMRefresh) {
                        InvokeAfterUpdateMode mode2 = title2 != null ? InvokeAfterUpdateMode.BACKGROUND_NOT_CANCELLABLE : InvokeAfterUpdateMode.SILENT_CALLBACK_POOLED;
                        clm.invokeAfterUpdate(() -> PartialChangesUtil.restoreChangeList(clm, targetChangeList, oldDefaultList), mode2, title2, ModalityState.NON_MODAL);
                    } else {
                        PartialChangesUtil.restoreChangeList(clm, targetChangeList, oldDefaultList);
                    }
                    throw throwable;
                }
                clm.invokeAfterUpdate(() -> PartialChangesUtil.restoreChangeList(clm, targetChangeList, oldDefaultList), mode, title2, ModalityState.NON_MODAL);
                break block6;
            }
            PartialChangesUtil.restoreChangeList(clm, targetChangeList, oldDefaultList);
        }
        return (T)object;
    }

    private static void switchChangeList(@NotNull ChangeListManagerEx clm, @NotNull LocalChangeList targetChangeList, @NotNull LocalChangeList oldDefaultList) {
        clm.setDefaultChangeList(targetChangeList, true);
        LOG.debug(String.format("Active changelist changed: %s -> %s", oldDefaultList.getName(), targetChangeList.getName()));
    }

    private static void restoreChangeList(@NotNull ChangeListManagerEx clm, @NotNull LocalChangeList targetChangeList, @NotNull LocalChangeList oldDefaultList) {
        LocalChangeList defaultChangeList = clm.getDefaultChangeList();
        if (Objects.equals(defaultChangeList.getId(), targetChangeList.getId())) {
            clm.setDefaultChangeList(oldDefaultList, true);
            LOG.debug(String.format("Active changelist restored: %s -> %s", targetChangeList.getName(), oldDefaultList.getName()));
        } else {
            LOG.warn(new Throwable(String.format("Active changelist was changed during the operation. Expected: %s -> %s, actual default: %s", targetChangeList.getName(), oldDefaultList.getName(), defaultChangeList.getName())));
        }
    }

    @NotNull
    public static ThreeStateCheckBox.State convertExclusionState(@NotNull ExclusionState exclusionState) {
        if (exclusionState == ExclusionState.ALL_INCLUDED) {
            return ThreeStateCheckBox.State.SELECTED;
        }
        if (exclusionState == ExclusionState.ALL_EXCLUDED) {
            return ThreeStateCheckBox.State.NOT_SELECTED;
        }
        return ThreeStateCheckBox.State.DONT_CARE;
    }
}

