/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.CommonBundle;
import com.intellij.ide.actions.CloseTabToolbarAction;
import com.intellij.ide.errorTreeView.ErrorTreeElementKind;
import com.intellij.ide.errorTreeView.HotfixData;
import com.intellij.ide.errorTreeView.SimpleErrorData;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.TransactionProvider;
import com.intellij.openapi.vcs.TransactionRunnable;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.actions.AnnotateToggleAction;
import com.intellij.openapi.vcs.annotate.AnnotationProvider;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.CommitResultHandler;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.committed.ChangesBrowserDialog;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesFilterDialog;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesTableModel;
import com.intellij.openapi.vcs.changes.committed.RepositoryLocationCommittedChangesPanel;
import com.intellij.openapi.vcs.changes.ui.ChangeListViewerDialog;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentI;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.vcs.changes.ui.CommitChangeListDialog;
import com.intellij.openapi.vcs.changes.ui.SelectFilePathsDialog;
import com.intellij.openapi.vcs.changes.ui.SelectFilesDialog;
import com.intellij.openapi.vcs.history.FileHistoryRefresher;
import com.intellij.openapi.vcs.history.FileHistoryRefresherI;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.BackgroundableActionLock;
import com.intellij.openapi.vcs.impl.VcsBackgroundableActions;
import com.intellij.openapi.vcs.impl.VcsErrorViewPanel;
import com.intellij.openapi.vcs.merge.MergeDialogCustomizer;
import com.intellij.openapi.vcs.merge.MergeProvider;
import com.intellij.openapi.vcs.merge.MultipleFileMergeDialog;
import com.intellij.openapi.vcs.update.RefreshVFsSynchronously;
import com.intellij.openapi.vcs.versionBrowser.ChangeBrowserSettings;
import com.intellij.openapi.vcs.versionBrowser.ChangesBrowserSettingsEditor;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.AppIcon;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManagerUtil;
import com.intellij.ui.content.MessageView;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.AsynchConsumer;
import com.intellij.util.BufferedListConsumer;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ConfirmationDialog;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.commit.AbstractCommitWorkflow;
import com.intellij.vcs.history.VcsHistoryProviderEx;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.Component;
import java.awt.Window;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbstractVcsHelperImpl
extends AbstractVcsHelper {
    private static final Logger LOG = Logger.getInstance(AbstractVcsHelperImpl.class);
    private static final String CHANGES_DETAILS_WINDOW_KEY = "CommittedChangesDetailsLock";
    private Consumer<VcsException> myCustomHandler = null;

    protected AbstractVcsHelperImpl(@NotNull Project project) {
        super(project);
    }

    public void openMessagesView(VcsErrorViewPanel errorTreeView, @NotNull String tabDisplayName) {
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        commandProcessor.executeCommand(this.myProject, () -> {
            MessageView messageView = MessageView.SERVICE.getInstance((Project)this.myProject);
            messageView.runWhenInitialized(() -> {
                Content content2 = ContentFactory.SERVICE.getInstance().createContent((JComponent)((Object)errorTreeView), tabDisplayName, true);
                messageView.getContentManager().addContent(content2);
                Disposer.register((Disposable)content2, (Disposable)errorTreeView);
                messageView.getContentManager().setSelectedContent(content2);
                ContentManagerUtil.cleanupContents((Content)content2, (Project)this.myProject, (String)tabDisplayName);
                ToolWindowManager.getInstance((Project)this.myProject).getToolWindow("Messages").activate(null);
            });
        }, VcsBundle.message((String)"command.name.open.error.message.view", (Object[])new Object[0]), null);
    }

    public void showFileHistory(@NotNull VcsHistoryProvider historyProvider, @NotNull FilePath path2, @NotNull AbstractVcs vcs) {
        this.showFileHistory(historyProvider, vcs.getAnnotationProvider(), path2, vcs);
    }

    public void showFileHistory(@NotNull VcsHistoryProvider historyProvider, @Nullable AnnotationProvider annotationProvider, @NotNull FilePath path2, @NotNull AbstractVcs vcs) {
        FileHistoryRefresherI refresher = FileHistoryRefresher.findOrCreate(historyProvider, path2, vcs);
        refresher.selectContent();
        refresher.refresh(true);
    }

    public void showFileHistory(@NotNull VcsHistoryProviderEx historyProvider, @NotNull FilePath path2, @NotNull AbstractVcs vcs, @Nullable VcsRevisionNumber startingRevisionNumber) {
        FileHistoryRefresherI refresher = FileHistoryRefresher.findOrCreate(historyProvider, path2, vcs, startingRevisionNumber);
        refresher.selectContent();
        refresher.refresh(true);
    }

    @Nullable
    public Collection<VirtualFile> selectFilesToProcess(List<? extends VirtualFile> files, @NlsContexts.DialogTitle String title2, @Nullable String prompt, @Nullable String singleFileTitle, @Nullable String singleFilePromptTemplate, @NotNull VcsShowConfirmationOption confirmationOption) {
        if (files == null || files.isEmpty()) {
            return null;
        }
        String okActionName = CommonBundle.getAddButtonText();
        String cancelActionName = CommonBundle.getCancelButtonText();
        if (files.size() == 1 && singleFileTitle != null && singleFilePromptTemplate != null) {
            String filePrompt = MessageFormat.format(singleFilePromptTemplate, FileUtil.getLocationRelativeToUserHome((String)files.get(0).getPresentableUrl()));
            if (ConfirmationDialog.requestForConfirmation((VcsShowConfirmationOption)confirmationOption, (Project)this.myProject, (String)filePrompt, (String)singleFileTitle, (Icon)Messages.getQuestionIcon(), (String)okActionName, (String)cancelActionName)) {
                return new ArrayList<VirtualFile>(files);
            }
            return null;
        }
        SelectFilesDialog dlg = SelectFilesDialog.init(this.myProject, files, prompt, confirmationOption, true, false, okActionName, cancelActionName);
        dlg.setTitle(title2);
        if (!confirmationOption.isPersistent()) {
            dlg.setDoNotAskOption(null);
        }
        if (dlg.showAndGet()) {
            Collection<VirtualFile> selection = dlg.getSelectedFiles();
            ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>();
            for (VirtualFile virtualFile : files) {
                if (!selection.contains(virtualFile)) continue;
                result2.add(virtualFile);
            }
            return result2;
        }
        return null;
    }

    @Nullable
    public Collection<FilePath> selectFilePathsToProcess(@NotNull List<? extends FilePath> files, String title2, @Nullable String prompt, @Nullable String singleFileTitle, @Nullable String singleFilePromptTemplate, @NotNull VcsShowConfirmationOption confirmationOption, @Nullable String okActionName, @Nullable String cancelActionName) {
        if (files.size() == 1 && singleFileTitle != null && singleFilePromptTemplate != null) {
            String filePrompt = MessageFormat.format(singleFilePromptTemplate, files.get(0).getPresentableUrl());
            if (ConfirmationDialog.requestForConfirmation((VcsShowConfirmationOption)confirmationOption, (Project)this.myProject, (String)filePrompt, (String)singleFileTitle, (Icon)Messages.getQuestionIcon(), (String)okActionName, (String)cancelActionName)) {
                return new ArrayList<FilePath>(files);
            }
            return null;
        }
        SelectFilePathsDialog dlg = new SelectFilePathsDialog(this.myProject, files, prompt, confirmationOption, okActionName, cancelActionName, true);
        dlg.setTitle(title2);
        if (!confirmationOption.isPersistent()) {
            dlg.setDoNotAskOption(null);
        }
        return dlg.showAndGet() ? dlg.getSelectedFiles() : null;
    }

    @Nullable
    public Collection<FilePath> selectFilePathsToProcess(@NotNull List<? extends FilePath> files, String title2, @Nullable String prompt, @Nullable String singleFileTitle, @Nullable String singleFilePromptTemplate, @NotNull VcsShowConfirmationOption confirmationOption) {
        return this.selectFilePathsToProcess(files, title2, prompt, singleFileTitle, singleFilePromptTemplate, confirmationOption, null, null);
    }

    public void showErrors(List<? extends VcsException> abstractVcsExceptions, @NotNull String tabDisplayName) {
        this.showErrorsImpl(abstractVcsExceptions.isEmpty(), (Getter<? extends VcsException>)((Getter)() -> (VcsException)((Object)((Object)abstractVcsExceptions.get(0)))), tabDisplayName, (Consumer<? super VcsErrorViewPanel>)((Consumer)vcsErrorViewPanel -> AbstractVcsHelperImpl.addDirectMessages(vcsErrorViewPanel, abstractVcsExceptions)));
    }

    public boolean commitChanges(@NotNull Collection<? extends Change> changes, @NotNull LocalChangeList initialChangeList, @NotNull String commitMessage2, @Nullable CommitResultHandler customResultHandler) {
        return CommitChangeListDialog.commitChanges(this.myProject, changes, initialChangeList, AbstractCommitWorkflow.getCommitExecutors(this.myProject, changes), true, commitMessage2, customResultHandler);
    }

    private static void addDirectMessages(VcsErrorViewPanel vcsErrorViewPanel, List<? extends VcsException> abstractVcsExceptions) {
        for (VcsException vcsException : abstractVcsExceptions) {
            String[] messages = AbstractVcsHelperImpl.getExceptionMessages(vcsException);
            vcsErrorViewPanel.addMessage(AbstractVcsHelperImpl.getErrorCategory(vcsException), messages, vcsException.getVirtualFile(), -1, -1, null);
        }
    }

    private static String[] getExceptionMessages(@NotNull VcsException exception) {
        String[] messages = exception.getMessages();
        if (messages.length == 0) {
            messages = new String[]{VcsBundle.message((String)"exception.text.unknown.error", (Object[])new Object[0])};
        }
        ArrayList list = new ArrayList();
        for (String message : messages) {
            list.addAll(StringUtil.split((String)StringUtil.convertLineSeparators((String)message), (String)"\n"));
        }
        return ArrayUtilRt.toStringArray(list);
    }

    private void showErrorsImpl(boolean isEmpty, Getter<? extends VcsException> firstGetter, @NotNull String tabDisplayName, Consumer<? super VcsErrorViewPanel> viewFiller) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            VcsException exception;
            if (!isEmpty && !this.handleCustom(exception = (VcsException)((Object)firstGetter.get()))) {
                throw new RuntimeException(exception);
            }
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            if (isEmpty) {
                ContentManagerUtil.cleanupContents(null, (Project)this.myProject, (String)tabDisplayName);
                return;
            }
            VcsErrorViewPanel errorTreeView = new VcsErrorViewPanel(this.myProject);
            this.openMessagesView(errorTreeView, tabDisplayName);
            viewFiller.consume((Object)errorTreeView);
        });
    }

    public boolean handleCustom(VcsException exception) {
        if (this.myCustomHandler != null) {
            this.myCustomHandler.consume((Object)exception);
            return true;
        }
        return false;
    }

    public void showErrors(Map<HotfixData, List<VcsException>> exceptionGroups, @NotNull String tabDisplayName) {
        this.showErrorsImpl(exceptionGroups.isEmpty(), (Getter<? extends VcsException>)((Getter)() -> {
            List exceptionList = (List)exceptionGroups.values().iterator().next();
            return exceptionList == null ? null : (exceptionList.isEmpty() ? null : (VcsException)((Object)((Object)exceptionList.get(0))));
        }), tabDisplayName, (Consumer<? super VcsErrorViewPanel>)((Consumer)vcsErrorViewPanel -> {
            for (Map.Entry entry : exceptionGroups.entrySet()) {
                if (entry.getKey() == null) {
                    AbstractVcsHelperImpl.addDirectMessages(vcsErrorViewPanel, (List)entry.getValue());
                    continue;
                }
                List exceptionList = (List)entry.getValue();
                ArrayList<SimpleErrorData> list = new ArrayList<SimpleErrorData>(exceptionList.size());
                for (VcsException exception : exceptionList) {
                    String[] messages = AbstractVcsHelperImpl.getExceptionMessages(exception);
                    list.add(new SimpleErrorData(ErrorTreeElementKind.convertMessageFromCompilerErrorType((int)AbstractVcsHelperImpl.getErrorCategory(exception)), messages, exception.getVirtualFile()));
                }
                vcsErrorViewPanel.addHotfixGroup((HotfixData)entry.getKey(), list);
            }
        }));
    }

    private static int getErrorCategory(VcsException exception) {
        if (exception.isWarning()) {
            return 5;
        }
        return 4;
    }

    public List<VcsException> runTransactionRunnable(AbstractVcs vcs, TransactionRunnable runnable, Object vcsParameters) {
        boolean transactionSupported;
        ArrayList<VcsException> exceptions = new ArrayList<VcsException>();
        TransactionProvider transactionProvider = vcs.getTransactionProvider();
        boolean bl = transactionSupported = transactionProvider != null;
        if (transactionSupported) {
            transactionProvider.startTransaction(vcsParameters);
        }
        runnable.run(exceptions);
        if (transactionSupported) {
            if (exceptions.isEmpty()) {
                try {
                    transactionProvider.commitTransaction(vcsParameters);
                }
                catch (VcsException e) {
                    exceptions.add(e);
                    transactionProvider.rollbackTransaction(vcsParameters);
                }
            } else {
                transactionProvider.rollbackTransaction(vcsParameters);
            }
        }
        return exceptions;
    }

    public void showAnnotation(FileAnnotation annotation, VirtualFile file, AbstractVcs vcs) {
        this.showAnnotation(annotation, file, vcs, 0);
    }

    public void showAnnotation(FileAnnotation annotation, VirtualFile file, AbstractVcs vcs, int line) {
        Editor editor;
        TextEditor textFileEditor;
        FileEditor fileEditor = FileEditorManager.getInstance((Project)this.myProject).getSelectedEditor(file);
        if (fileEditor instanceof TextEditor) {
            textFileEditor = (TextEditor)fileEditor;
        } else {
            Object[] editors = FileEditorManager.getInstance((Project)this.myProject).getEditors(file);
            textFileEditor = (TextEditor)ContainerUtil.findInstance((Object[])editors, TextEditor.class);
        }
        if (textFileEditor != null) {
            editor = textFileEditor.getEditor();
        } else {
            OpenFileDescriptor openFileDescriptor = new OpenFileDescriptor(this.myProject, file, line, 0);
            editor = FileEditorManager.getInstance((Project)this.myProject).openTextEditor(openFileDescriptor, true);
        }
        if (editor == null) {
            Messages.showMessageDialog((String)VcsBundle.message((String)"message.text.cannot.open.editor", (Object[])new Object[]{file.getPresentableUrl()}), (String)VcsBundle.message((String)"message.title.cannot.open.editor", (Object[])new Object[0]), (Icon)Messages.getInformationIcon());
            return;
        }
        AnnotateToggleAction.doAnnotate(editor, this.myProject, annotation, vcs);
    }

    private ChangesBrowserDialog createChangesBrowserDialog(CommittedChangesTableModel changelists, @Nullable String title2, @Nullable Component parent, Consumer<? super ChangesBrowserDialog> initRunnable) {
        ChangesBrowserDialog dlg;
        ChangesBrowserDialog.Mode mode = ChangesBrowserDialog.Mode.Browse;
        ChangesBrowserDialog changesBrowserDialog = dlg = parent != null ? new ChangesBrowserDialog(this.myProject, parent, changelists, mode, initRunnable) : new ChangesBrowserDialog(this.myProject, changelists, mode, initRunnable);
        if (title2 != null) {
            dlg.setTitle(title2);
        }
        return dlg;
    }

    public void showChangesListBrowser(@NotNull CommittedChangeList changelist, @Nullable @Nls String title2) {
        ChangeListViewerDialog dlg = new ChangeListViewerDialog(this.myProject, changelist, null);
        if (title2 != null) {
            dlg.setTitle(title2);
        }
        dlg.show();
    }

    public void showWhatDiffersBrowser(@NotNull Collection<Change> changes, @Nullable @Nls String title2) {
        ChangeListViewerDialog dlg = new ChangeListViewerDialog(this.myProject, changes);
        if (title2 != null) {
            dlg.setTitle(title2);
        }
        dlg.show();
    }

    @NotNull
    public List<VirtualFile> showMergeDialog(@NotNull List<? extends VirtualFile> files, @NotNull MergeProvider provider, @NotNull MergeDialogCustomizer mergeDialogCustomizer) {
        if (files.isEmpty()) {
            return Collections.emptyList();
        }
        RefreshVFsSynchronously.refreshVirtualFiles(files);
        MultipleFileMergeDialog fileMergeDialog = new MultipleFileMergeDialog(this.myProject, files, provider, mergeDialogCustomizer);
        AppIcon.getInstance().requestAttention(this.myProject, true);
        fileMergeDialog.show();
        return fileMergeDialog.getProcessedFiles();
    }

    public void showCommittedChangesBrowser(@NotNull CommittedChangesProvider provider, @NotNull RepositoryLocation location, @Nullable @Nls String title2, @Nullable Component parent) {
        ChangesBrowserSettingsEditor filterUI = provider.createFilterUI(true);
        CommittedChangesFilterDialog filterDialog = new CommittedChangesFilterDialog(this.myProject, filterUI, provider.createDefaultSettings());
        if (filterDialog.showAndGet()) {
            ChangeBrowserSettings settings = filterDialog.getSettings();
            if (this.myProject.isDefault() || ProjectLevelVcsManager.getInstance((Project)this.myProject).getAllActiveVcss().length == 0 || !ModalityState.NON_MODAL.equals(ModalityState.current())) {
                ArrayList<CommittedChangeList> versions = new ArrayList<CommittedChangeList>();
                if (parent == null || !parent.isValid()) {
                    parent = WindowManager.getInstance().suggestParentWindow(this.myProject);
                }
                CommittedChangesTableModel model = new CommittedChangesTableModel(versions, true);
                AsynchronousListsLoader[] task2 = new AsynchronousListsLoader[1];
                ChangesBrowserDialog dlg = this.createChangesBrowserDialog(model, title2, parent, (Consumer<? super ChangesBrowserDialog>)((Consumer)changesBrowserDialog -> {
                    task2[0] = new AsynchronousListsLoader(this.myProject, provider, location, settings, (ChangesBrowserDialog)((Object)changesBrowserDialog));
                    ProgressManager.getInstance().run((Task)task2[0]);
                }));
                dlg.startLoading();
                dlg.show();
                if (task2[0] != null) {
                    task2[0].cancel();
                    List<VcsException> exceptions = task2[0].getExceptions();
                    if (!exceptions.isEmpty()) {
                        Messages.showErrorDialog((Project)this.myProject, (String)VcsBundle.message((String)"browse.changes.error.message", (Object[])new Object[]{exceptions.get(0).getMessage()}), (String)VcsBundle.message((String)"browse.changes.error.title", (Object[])new Object[0]));
                        return;
                    }
                    if (!task2[0].isRevisionsReturned()) {
                        Messages.showInfoMessage((Project)this.myProject, (String)VcsBundle.message((String)"browse.changes.nothing.found", (Object[])new Object[0]), (String)VcsBundle.message((String)"browse.changes.nothing.found.title", (Object[])new Object[0]));
                    }
                }
            } else {
                this.openCommittedChangesTab(provider, location, settings, 0, title2);
            }
        }
    }

    public void openCommittedChangesTab(@NotNull CommittedChangesProvider provider, @NotNull RepositoryLocation location, @NotNull ChangeBrowserSettings settings, int maxCount, @Nullable String title2) {
        DefaultActionGroup extraActions = new DefaultActionGroup();
        RepositoryLocationCommittedChangesPanel<ChangeBrowserSettings> panel2 = new RepositoryLocationCommittedChangesPanel<ChangeBrowserSettings>(this.myProject, provider, location, extraActions);
        panel2.setMaxCount(maxCount);
        panel2.setSettings(settings);
        panel2.refreshChanges();
        ContentFactory factory = ContentFactory.SERVICE.getInstance();
        if (title2 == null) {
            title2 = VcsBundle.message((String)"browse.changes.content.title", (Object[])new Object[]{location.toPresentableString()});
        }
        final Content content2 = factory.createContent(panel2, title2, false);
        final ChangesViewContentI contentManager = ChangesViewContentManager.getInstance(this.myProject);
        contentManager.addContent(content2);
        contentManager.setSelectedContent(content2);
        extraActions.add((AnAction)new CloseTabToolbarAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                contentManager.removeContent(content2);
            }
        });
        ToolWindow window = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow("Version Control");
        if (!window.isVisible()) {
            window.activate(null);
        }
    }

    public void loadAndShowCommittedChangesDetails(@NotNull Project project, @NotNull VcsRevisionNumber revision, @NotNull VirtualFile virtualFile, @NotNull VcsKey vcsKey, @Nullable RepositoryLocation location, boolean isNonLocal) {
        AbstractVcs vcs = ProjectLevelVcsManager.getInstance((Project)project).findVcsByName(vcsKey.getName());
        if (vcs == null) {
            return;
        }
        CommittedChangesProvider provider = vcs.getCommittedChangesProvider();
        if (provider == null) {
            return;
        }
        if (isNonLocal && provider.getForNonLocal(virtualFile) == null) {
            return;
        }
        FilePath filePath = VcsUtil.getFilePath((VirtualFile)virtualFile);
        AbstractVcsHelperImpl.loadAndShowCommittedChangesDetails(project, revision, filePath, () -> AbstractVcsHelperImpl.getAffectedChanges(provider, virtualFile, revision, location, isNonLocal));
    }

    public static void loadAndShowCommittedChangesDetails(@NotNull Project project, @NotNull VcsRevisionNumber revision, @NotNull FilePath filePath, @NotNull CommittedChangeListProvider changelistProvider) {
        String title2 = VcsBundle.message((String)"paths.affected.in.revision", (Object[])new Object[]{VcsUtil.getShortRevisionString((VcsRevisionNumber)revision)});
        BackgroundableActionLock lock = BackgroundableActionLock.getLock(project, new Object[]{VcsBackgroundableActions.COMMITTED_CHANGES_DETAILS, revision, filePath.getPath()});
        if (lock.isLocked()) {
            for (Window window : Window.getWindows()) {
                Object windowLock = UIUtil.getWindowClientProperty((Window)window, (Object)CHANGES_DETAILS_WINDOW_KEY);
                if (windowLock == null || !lock.equals(windowLock)) continue;
                UIUtil.toFront((Window)window);
                break;
            }
            return;
        }
        lock.lock();
        ChangeListViewerDialog dlg = new ChangeListViewerDialog(project);
        dlg.setTitle(title2);
        UIUtil.putWindowClientProperty((Window)dlg.getWindow(), (Object)CHANGES_DETAILS_WINDOW_KEY, (Object)lock);
        Disposer.register((Disposable)dlg.getDisposable(), () -> lock.unlock());
        dlg.loadChangesInBackground((ThrowableComputable<? extends ChangeListViewerDialog.ChangelistData, ? extends VcsException>)((ThrowableComputable)() -> {
            try {
                Pair<? extends CommittedChangeList, FilePath> pair = changelistProvider.loadChangelist();
                if (pair == null || pair.getFirst() == null) {
                    throw new VcsException(AbstractVcsHelperImpl.failedText(filePath, revision));
                }
                CommittedChangeList changeList = (CommittedChangeList)pair.getFirst();
                FilePath targetPath = (FilePath)pair.getSecond();
                FilePath navigateToPath = (FilePath)ObjectUtils.notNull((Object)targetPath, (Object)filePath);
                return new ChangeListViewerDialog.ChangelistData(changeList, navigateToPath);
            }
            catch (VcsException e) {
                throw new VcsException(AbstractVcsHelperImpl.failedText(filePath, revision), (Throwable)e);
            }
        }));
        dlg.show();
    }

    @Nullable
    private static Pair<CommittedChangeList, FilePath> getAffectedChanges(@NotNull CommittedChangesProvider provider, @NotNull VirtualFile virtualFile, @NotNull VcsRevisionNumber revision, @Nullable RepositoryLocation location, boolean isNonLocal) throws VcsException {
        if (!isNonLocal) {
            Pair pair = provider.getOneList(virtualFile, revision);
            if (pair != null) {
                return pair;
            }
        } else if (location != null) {
            ChangeBrowserSettings settings = provider.createDefaultSettings();
            settings.USE_CHANGE_BEFORE_FILTER = true;
            settings.CHANGE_BEFORE = revision.asString();
            List changes = provider.getCommittedChanges(settings, location, 1);
            if (changes.size() == 1) {
                return Pair.create(changes.get(0), null);
            }
        } else {
            CommittedChangeList list = AbstractVcsHelperImpl.getRemoteList(provider, revision, virtualFile);
            if (list != null) {
                return Pair.create((Object)list, null);
            }
        }
        LOG.warn(String.format("Can't get affected files: path: %s; revision: %s; location: %s; nonLocal: %s", virtualFile.getPath(), revision.asString(), location, isNonLocal), new Throwable());
        return null;
    }

    @Nullable
    public static CommittedChangeList getRemoteList(@NotNull CommittedChangesProvider provider, @NotNull VcsRevisionNumber revision, @NotNull VirtualFile nonLocal) throws VcsException {
        RepositoryLocation local = provider.getForNonLocal(nonLocal);
        if (local != null) {
            String number = revision.asString();
            ChangeBrowserSettings settings = provider.createDefaultSettings();
            List changes = provider.getCommittedChanges(settings, local, provider.getUnlimitedCountValue());
            for (CommittedChangeList change : changes) {
                if (!number.equals(String.valueOf(change.getNumber()))) continue;
                return change;
            }
        }
        return null;
    }

    @NotNull
    private static String failedText(@NotNull FilePath filePath, @NotNull VcsRevisionNumber revision) {
        return "Show all affected files for " + filePath.getPath() + " at " + revision.asString() + " failed";
    }

    public static void setCustomExceptionHandler(Project project, Consumer<VcsException> customHandler) {
        ((AbstractVcsHelperImpl)AbstractVcsHelperImpl.getInstance((Project)project)).myCustomHandler = customHandler;
    }

    public static interface CommittedChangeListProvider {
        @Nullable
        public Pair<? extends CommittedChangeList, FilePath> loadChangelist() throws VcsException;
    }

    private static class AsynchronousListsLoader
    extends Task.Backgroundable {
        @NotNull
        private final CommittedChangesProvider myProvider;
        @NotNull
        private final RepositoryLocation myLocation;
        private final ChangeBrowserSettings mySettings;
        private final ChangesBrowserDialog myDlg;
        private final List<VcsException> myExceptions;
        private volatile boolean myCanceled;
        private boolean myRevisionsReturned;

        private AsynchronousListsLoader(@Nullable Project project, @NotNull CommittedChangesProvider provider, @NotNull RepositoryLocation location, @NotNull ChangeBrowserSettings settings, ChangesBrowserDialog dlg) {
            super(project, VcsBundle.message((String)"browse.changes.progress.title", (Object[])new Object[0]), true);
            this.myProvider = provider;
            this.myLocation = location;
            this.mySettings = settings;
            this.myDlg = dlg;
            this.myExceptions = new ArrayList<VcsException>();
        }

        public void cancel() {
            this.myCanceled = true;
        }

        public void run(final @NotNull ProgressIndicator indicator) {
            final AsynchConsumer<List<CommittedChangeList>> appender2 = this.myDlg.getAppender();
            final BufferedListConsumer bufferedListConsumer = new BufferedListConsumer(10, appender2, -1);
            final Application application = ApplicationManager.getApplication();
            try {
                this.myProvider.loadCommittedChanges(this.mySettings, this.myLocation, 0, (AsynchConsumer)new AsynchConsumer<CommittedChangeList>(){

                    public void consume(CommittedChangeList committedChangeList) {
                        myRevisionsReturned = true;
                        bufferedListConsumer.consumeOne((Object)committedChangeList);
                        if (myCanceled) {
                            indicator.cancel();
                        }
                    }

                    public void finished() {
                        bufferedListConsumer.flush();
                        appender2.finished();
                        if (!myRevisionsReturned) {
                            application.invokeLater(() -> myDlg.close(-1), ModalityState.stateForComponent((Component)myDlg.getWindow()));
                        }
                    }
                });
            }
            catch (VcsException e) {
                this.myExceptions.add(e);
                application.invokeLater(() -> this.myDlg.close(-1), ModalityState.stateForComponent((Component)this.myDlg.getWindow()));
            }
        }

        public List<VcsException> getExceptions() {
            return this.myExceptions;
        }

        public boolean isRevisionsReturned() {
            return this.myRevisionsReturned;
        }
    }
}

