/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.checkin;

import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.OutOfSourcesChecker;
import com.intellij.openapi.roots.GeneratedSourcesFilter;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.project.ProjectKt;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiUtilCore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JCheckBox;
import org.jetbrains.annotations.NotNull;

public final class CheckinHandlerUtil {
    public static List<VirtualFile> filterOutGeneratedAndExcludedFiles(@NotNull Collection<? extends VirtualFile> files, @NotNull Project project) {
        ProjectFileIndex fileIndex = ProjectFileIndex.SERVICE.getInstance((Project)project);
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>(files.size());
        for (VirtualFile virtualFile : files) {
            if (fileIndex.isExcluded(virtualFile) || GeneratedSourcesFilter.isGeneratedSourceByAnyFilter((VirtualFile)virtualFile, (Project)project)) continue;
            result2.add(virtualFile);
        }
        return result2;
    }

    public static PsiFile[] getPsiFiles(Project project, Collection<? extends VirtualFile> selectedFiles) {
        ArrayList<PsiFile> result2 = new ArrayList<PsiFile>();
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        IProjectStore projectStore = ProjectKt.getStateStore((Project)project);
        for (VirtualFile virtualFile : selectedFiles) {
            PsiFile psiFile;
            if (!virtualFile.isValid() || projectStore.isProjectFile(virtualFile) || !CheckinHandlerUtil.isFileUnderSourceRoot(project, virtualFile) || CheckinHandlerUtil.isOutOfSources(project, virtualFile) || (psiFile = psiManager.findFile(virtualFile)) == null) continue;
            result2.add(psiFile);
        }
        return PsiUtilCore.toPsiFileArray(result2);
    }

    private static boolean isFileUnderSourceRoot(@NotNull Project project, @NotNull VirtualFile file) {
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)project).getFileIndex();
        return index.isInContent(file) && !index.isInLibrarySource(file);
    }

    private static boolean isOutOfSources(@NotNull Project project, @NotNull VirtualFile file) {
        return OutOfSourcesChecker.EP_NAME.getExtensionList().stream().anyMatch(checker -> FileTypeRegistry.getInstance().isFileOfType(file, checker.getFileType()) && checker.isOutOfSources(project, file));
    }

    public static void disableWhenDumb(@NotNull Project project, @NotNull JCheckBox checkBox, @NotNull String tooltip) {
        boolean dumb = DumbService.isDumb((Project)project);
        checkBox.setEnabled(!dumb);
        checkBox.setToolTipText(dumb ? tooltip : "");
    }
}

