/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch.tool;

import com.intellij.diff.DiffContext;
import com.intellij.diff.merge.MergeContext;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.MergeResult;
import com.intellij.diff.merge.MergeTool;
import com.intellij.diff.merge.MergeUtil;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.changes.patch.tool.ApplyPatchChange;
import com.intellij.openapi.vcs.changes.patch.tool.ApplyPatchMergeRequest;
import com.intellij.openapi.vcs.changes.patch.tool.ApplyPatchViewer;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApplyPatchMergeTool
implements MergeTool {
    @NotNull
    public MergeTool.MergeViewer createComponent(@NotNull MergeContext context, @NotNull MergeRequest request) {
        return new MyApplyPatchViewer(context, (ApplyPatchMergeRequest)request);
    }

    public boolean canShow(@NotNull MergeContext context, @NotNull MergeRequest request) {
        return request instanceof ApplyPatchMergeRequest;
    }

    private static class MyApplyPatchViewer
    extends ApplyPatchViewer
    implements MergeTool.MergeViewer {
        @NotNull
        private final MergeContext myMergeContext;
        @NotNull
        private final ApplyPatchMergeRequest myMergeRequest;

        MyApplyPatchViewer(@NotNull MergeContext context, @NotNull ApplyPatchMergeRequest request) {
            super(MyApplyPatchViewer.createWrapperDiffContext(context), request);
            this.myMergeContext = context;
            this.myMergeRequest = request;
            this.getResultEditor().putUserData(DiffUserDataKeys.MERGE_EDITOR_FLAG, (Object)true);
        }

        @NotNull
        private static DiffContext createWrapperDiffContext(@NotNull MergeContext mergeContext) {
            return new MergeUtil.ProxyDiffContext(mergeContext);
        }

        @NotNull
        public MergeTool.ToolbarComponents init() {
            this.initPatchViewer();
            MergeTool.ToolbarComponents components = new MergeTool.ToolbarComponents();
            components.statusPanel = this.getStatusPanel();
            components.toolbarActions = this.createToolbarActions();
            components.closeHandler = () -> MergeUtil.showExitWithoutApplyingChangesDialog((MergeTool.MergeViewer)this, (MergeRequest)this.myMergeRequest, (MergeContext)this.myMergeContext, (boolean)true);
            return components;
        }

        @Nullable
        public Action getResolveAction(final @NotNull MergeResult result2) {
            if (result2 == MergeResult.LEFT || result2 == MergeResult.RIGHT) {
                return null;
            }
            String caption = MergeUtil.getResolveActionTitle((MergeResult)result2, (MergeRequest)this.myMergeRequest, (MergeContext)this.myMergeContext);
            return new AbstractAction(caption){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int unresolved;
                    if (result2 == MergeResult.RESOLVED && (unresolved = this.getUnresolvedCount()) != 0 && Messages.showConfirmationDialog((JComponent)this.getComponent().getRootPane(), (String)DiffBundle.message((String)"apply.patch.partially.resolved.changes.confirmation.message", (Object[])new Object[]{unresolved}), (String)DiffBundle.message((String)"apply.partially.resolved.merge.dialog.title", (Object[])new Object[0]), (String)DiffBundle.message((String)"merge.save.and.finish.button", (Object[])new Object[0]), (String)DiffBundle.message((String)"merge.continue.button", (Object[])new Object[0])) != 0) {
                        return;
                    }
                    if (result2 == MergeResult.CANCEL && !MergeUtil.showExitWithoutApplyingChangesDialog((MergeTool.MergeViewer)this, (MergeRequest)myMergeRequest, (MergeContext)myMergeContext, (boolean)true)) {
                        return;
                    }
                    myMergeContext.finishMerge(result2);
                }
            };
        }

        private int getUnresolvedCount() {
            int count = 0;
            for (ApplyPatchChange change : this.getPatchChanges()) {
                if (change.isResolved()) continue;
                ++count;
            }
            return count;
        }

        @Override
        protected void onChangeResolved() {
            super.onChangeResolved();
            if (!ContainerUtil.exists(this.getModelChanges(), c -> !c.isResolved())) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (this.isDisposed()) {
                        return;
                    }
                    JComponent component = this.getComponent();
                    int yOffset = new RelativePoint((Component)this.getResultEditor().getComponent(), (Point)new Point((int)0, (int)JBUIScale.scale((int)5))).getPoint((Component)component).y;
                    RelativePoint point = new RelativePoint((Component)component, new Point(component.getWidth() / 2, yOffset));
                    String message = DiffBundle.message((String)"apply.patch.all.changes.processed.message.text", (Object[])new Object[0]);
                    DiffUtil.showSuccessPopup((String)message, (RelativePoint)point, (Disposable)this, () -> {
                        if (this.isDisposed()) {
                            return;
                        }
                        this.myMergeContext.finishMerge(MergeResult.RESOLVED);
                    });
                });
            }
        }
    }
}

