/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ignore.reference;

import com.intellij.openapi.vcs.changes.ignore.codeInsight.FileExtensionCompletionContributor;
import com.intellij.openapi.vcs.changes.ignore.psi.IgnoreEntry;
import com.intellij.openapi.vcs.changes.ignore.psi.IgnoreFile;
import com.intellij.openapi.vcs.changes.ignore.reference.IgnoreReferenceSet;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;

public class IgnoreReferenceContributor
extends PsiReferenceContributor {
    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar psiReferenceRegistrar) {
        psiReferenceRegistrar.registerReferenceProvider((ElementPattern)PlatformPatterns.psiElement().inFile((ElementPattern)PlatformPatterns.psiFile(IgnoreFile.class)), (PsiReferenceProvider)new IgnoreReferenceProvider());
    }

    private static class IgnoreReferenceProvider
    extends PsiReferenceProvider {
        private IgnoreReferenceProvider() {
        }

        public boolean acceptsTarget(@NotNull PsiElement target) {
            return target instanceof PsiFileSystemItem;
        }

        public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement psiElement, @NotNull ProcessingContext processingContext) {
            String text2 = psiElement.getText();
            if (psiElement instanceof IgnoreEntry && !IgnoreReferenceProvider.shouldSkipCompletion(text2)) {
                return new IgnoreReferenceSet((IgnoreEntry)psiElement).getAllReferences();
            }
            return PsiReference.EMPTY_ARRAY;
        }

        private static boolean shouldSkipCompletion(@NotNull String text2) {
            return FileExtensionCompletionContributor.Companion.completionSupported(text2);
        }
    }
}

