/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ignore.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.ignore.lang.IgnoreLanguage;
import com.intellij.openapi.vcs.changes.ignore.lang.Syntax;
import com.intellij.openapi.vcs.changes.ignore.psi.IgnoreElementImpl;
import com.intellij.openapi.vcs.changes.ignore.psi.IgnoreEntry;
import com.intellij.openapi.vcs.changes.ignore.psi.IgnoreNegation;
import com.intellij.openapi.vcs.changes.ignore.psi.IgnoreSyntax;
import com.intellij.openapi.vcs.changes.ignore.psi.IgnoreTypes;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;

public abstract class IgnoreEntryExtImpl
extends IgnoreElementImpl
implements IgnoreEntry {
    public IgnoreEntryExtImpl(ASTNode node) {
        super(node);
    }

    @Override
    public boolean isNegated() {
        return this.getFirstChild() instanceof IgnoreNegation;
    }

    @Override
    @NotNull
    public Syntax getSyntax() {
        for (PsiElement previous = this.getPrevSibling(); previous != null; previous = previous.getPrevSibling()) {
            Syntax syntax;
            if (!previous.getNode().getElementType().equals(IgnoreTypes.SYNTAX) || (syntax = Syntax.find(((IgnoreSyntax)previous).getValue().getText())) == null) continue;
            return syntax;
        }
        return ((IgnoreLanguage)this.getContainingFile().getLanguage()).getDefaultSyntax();
    }

    @Override
    @NotNull
    public String getValue() {
        String value = this.getText();
        if (this.isNegated()) {
            value = StringUtil.trimStart((String)value, (String)"!");
        }
        return value;
    }
}

