/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ignore.psi;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.changes.ignore.lang.IgnoreFileType;
import com.intellij.openapi.vcs.changes.ignore.lang.IgnoreLanguage;
import com.intellij.openapi.vcs.changes.ignore.psi.IgnoreEntry;
import com.intellij.openapi.vcs.changes.ignore.psi.IgnoreNegation;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class IgnoreEntryManipulator
extends AbstractElementManipulator<IgnoreEntry> {
    public IgnoreEntry handleContentChange(@NotNull IgnoreEntry entry, @NotNull TextRange range, String newContent) throws IncorrectOperationException {
        if (!(entry.getLanguage() instanceof IgnoreLanguage)) {
            return entry;
        }
        IgnoreLanguage language = (IgnoreLanguage)entry.getLanguage();
        IgnoreFileType fileType = (IgnoreFileType)language.getAssociatedFileType();
        assert (fileType != null);
        PsiFile file = PsiFileFactory.getInstance((Project)entry.getProject()).createFileFromText(language.getFilename(), (FileType)fileType, (CharSequence)range.replace(entry.getText(), newContent));
        IgnoreEntry newEntry = (IgnoreEntry)PsiTreeUtil.findChildOfType((PsiElement)file, IgnoreEntry.class);
        assert (newEntry != null);
        return (IgnoreEntry)entry.replace(newEntry);
    }

    @NotNull
    public TextRange getRangeInElement(@NotNull IgnoreEntry element) {
        IgnoreNegation negation = element.getNegation();
        if (negation != null) {
            return TextRange.create((int)(negation.getStartOffsetInParent() + negation.getTextLength()), (int)element.getTextLength());
        }
        return super.getRangeInElement((PsiElement)element);
    }
}

