/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ignore.cache;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.ignore.lang.Syntax;
import com.intellij.openapi.vcs.changes.ignore.psi.IgnoreEntry;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PatternCache
implements Disposable {
    private final ConcurrentMap<String, String> GLOBS_CACHE = new ConcurrentHashMap<String, String>();
    private final ConcurrentMap<String, Pattern> PATTERNS_CACHE = new ConcurrentHashMap<String, Pattern>();

    public PatternCache(@NotNull Project project) {
        Disposer.register((Disposable)project, (Disposable)this);
    }

    @Nullable
    public Pattern createPattern(@NotNull String rule, @NotNull Syntax syntax) {
        return this.createPattern(rule, syntax, false);
    }

    @Nullable
    public Pattern createPattern(@NotNull IgnoreEntry entry) {
        return this.createPattern(entry, false);
    }

    @Nullable
    public Pattern createPattern(@NotNull IgnoreEntry entry, boolean acceptChildren) {
        return this.createPattern(entry.getValue(), entry.getSyntax(), acceptChildren);
    }

    @Nullable
    public Pattern createPattern(@NotNull String rule, @NotNull Syntax syntax, boolean acceptChildren) {
        String regex = this.getRegex(rule, syntax, acceptChildren);
        return this.getOrCreatePattern(regex);
    }

    @NotNull
    public String getRegex(@NotNull String rule, @NotNull Syntax syntax, boolean acceptChildren) {
        return syntax.equals((Object)Syntax.GLOB) ? this.createRegex(rule, acceptChildren) : rule;
    }

    @Nullable
    public Pattern getOrCreatePattern(@NotNull String regex) {
        try {
            if (!this.PATTERNS_CACHE.containsKey(regex)) {
                this.PATTERNS_CACHE.put(regex, Pattern.compile(regex));
            }
            return (Pattern)this.PATTERNS_CACHE.get(regex);
        }
        catch (PatternSyntaxException e) {
            return null;
        }
    }

    @Nullable
    public Pattern getPattern(@NotNull String regex) {
        return (Pattern)this.PATTERNS_CACHE.get(regex);
    }

    @NotNull
    private String createRegex(@NotNull String glob, boolean acceptChildren) {
        char[] chars;
        String cached = (String)this.GLOBS_CACHE.get(glob = glob.trim());
        if (cached != null) {
            return cached;
        }
        StringBuilder sb = new StringBuilder("^");
        boolean escape = false;
        boolean star = false;
        boolean doubleStar = false;
        boolean bracket = false;
        int beginIndex = 0;
        if (StringUtil.startsWith((CharSequence)glob, (CharSequence)"**")) {
            sb.append("(?:[^/]*?/)*");
            beginIndex = 2;
            doubleStar = true;
        } else if (StringUtil.startsWith((CharSequence)glob, (CharSequence)"*/")) {
            sb.append("[^/]*");
            beginIndex = 1;
            star = true;
        } else if (StringUtil.equals((CharSequence)"*", (CharSequence)glob)) {
            sb.append(".*");
        } else if (StringUtil.startsWithChar((CharSequence)glob, (char)'*')) {
            sb.append(".*?");
        } else if (StringUtil.startsWithChar((CharSequence)glob, (char)'/')) {
            beginIndex = 1;
        } else {
            int slashes = StringUtil.countChars((CharSequence)glob, (char)'/');
            if (slashes == 0 || slashes == 1 && StringUtil.endsWithChar((CharSequence)glob, (char)'/')) {
                sb.append("(?:[^/]*?/)*");
            }
        }
        block7: for (char ch : chars = glob.substring(beginIndex).toCharArray()) {
            if (bracket && ch != ']') {
                sb.append(ch);
                continue;
            }
            if (doubleStar) {
                doubleStar = false;
                if (ch == '/') {
                    sb.append("(?:[^/]*/)*?");
                    continue;
                }
                sb.append("[^/]*?");
            }
            if (ch == '*') {
                if (escape) {
                    sb.append("\\*");
                    escape = false;
                    star = false;
                    continue;
                }
                if (star) {
                    char prev;
                    char c = prev = sb.length() > 0 ? sb.charAt(sb.length() - 1) : (char)'\u0000';
                    if (prev == '\u0000' || prev == '^' || prev == '/') {
                        doubleStar = true;
                    } else {
                        sb.append("[^/]*?");
                    }
                    star = false;
                    continue;
                }
                star = true;
                continue;
            }
            if (star) {
                sb.append("[^/]*?");
                star = false;
            }
            switch (ch) {
                case '\\': {
                    if (escape) {
                        sb.append("\\\\");
                        escape = false;
                        continue block7;
                    }
                    escape = true;
                    continue block7;
                }
                case '?': {
                    if (escape) {
                        sb.append("\\?");
                        escape = false;
                        continue block7;
                    }
                    sb.append('.');
                    continue block7;
                }
                case '[': {
                    if (escape) {
                        sb.append('\\');
                        escape = false;
                    } else {
                        bracket = true;
                    }
                    sb.append(ch);
                    continue block7;
                }
                case ']': {
                    if (!bracket) {
                        sb.append('\\');
                    }
                    sb.append(ch);
                    bracket = false;
                    escape = false;
                    continue block7;
                }
                case '$': 
                case '%': 
                case '(': 
                case ')': 
                case '+': 
                case '.': 
                case '@': 
                case '^': 
                case '|': {
                    sb.append('\\');
                    sb.append(ch);
                    escape = false;
                    continue block7;
                }
                default: {
                    escape = false;
                    sb.append(ch);
                }
            }
        }
        if (star || doubleStar) {
            if (StringUtil.endsWithChar((CharSequence)sb, (char)'/')) {
                sb.append(acceptChildren ? ".+" : "[^/]+/?");
            } else {
                sb.append("[^/]*/?");
            }
        } else if (StringUtil.endsWithChar((CharSequence)sb, (char)'/')) {
            if (acceptChildren) {
                sb.append("[^/]*");
            }
        } else {
            sb.append(acceptChildren ? "(?:/.*)?" : "/?");
        }
        sb.append('$');
        this.GLOBS_CACHE.put(glob, sb.toString());
        return sb.toString();
    }

    public void dispose() {
        this.clearCache();
    }

    public void clearCache() {
        this.GLOBS_CACHE.clear();
        this.PATTERNS_CACHE.clear();
    }

    public static PatternCache getInstance(@NotNull Project project) {
        return (PatternCache)ServiceManager.getService((Project)project, PatternCache.class);
    }
}

