/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.conflicts;

import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.conflicts.ChangelistConflictNotificationPanel;
import com.intellij.openapi.vcs.changes.conflicts.ChangelistConflictTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotifications;
import org.jetbrains.annotations.NotNull;

public final class ChangelistConflictNotificationProvider
extends EditorNotifications.Provider<ChangelistConflictNotificationPanel>
implements DumbAware {
    private static final Key<ChangelistConflictNotificationPanel> KEY = Key.create((String)"changelistConflicts");

    @NotNull
    public Key<ChangelistConflictNotificationPanel> getKey() {
        return KEY;
    }

    public ChangelistConflictNotificationPanel createNotificationPanel(@NotNull VirtualFile file, @NotNull FileEditor fileEditor, @NotNull Project project) {
        ChangelistConflictTracker conflictTracker = ChangeListManagerImpl.getInstanceImpl(project).getConflictTracker();
        return conflictTracker.hasConflict(file) ? ChangelistConflictNotificationPanel.create(conflictTracker, file) : null;
    }
}

