/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.conflicts;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusFactory;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.conflicts.ChangelistConflictTracker;
import com.intellij.openapi.vcs.impl.FileStatusProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ThreeState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ChangelistConflictFileStatusProvider
implements FileStatusProvider {
    public static final FileStatus MODIFIED_OUTSIDE = FileStatusFactory.getInstance().createFileStatus("modifiedOutside", VcsBundle.message((String)"settings.file.status.color.modified.in.not.active.changelist", (Object[])new Object[0]));
    public static final FileStatus ADDED_OUTSIDE = FileStatusFactory.getInstance().createFileStatus("addedOutside", VcsBundle.message((String)"settings.file.status.color.added.in.not.active.changelist", (Object[])new Object[0]));
    public static final FileStatus CHANGELIST_CONFLICT = FileStatusFactory.getInstance().createFileStatus("changelistConflict", VcsBundle.message((String)"settings.file.status.color.changelist.conflict", (Object[])new Object[0]));
    private final ChangeListManagerImpl myChangeListManager;

    public ChangelistConflictFileStatusProvider(@NotNull Project project) {
        this.myChangeListManager = ChangeListManagerImpl.getInstanceImpl(project);
    }

    @Nullable
    public FileStatus getFileStatus(@NotNull VirtualFile virtualFile) {
        FileStatus status;
        ChangelistConflictTracker conflictTracker = this.myChangeListManager.getConflictTracker();
        ChangelistConflictTracker.Options options = conflictTracker.getOptions();
        if (options.HIGHLIGHT_CONFLICTS && conflictTracker.hasConflict(virtualFile)) {
            return CHANGELIST_CONFLICT;
        }
        if (options.HIGHLIGHT_NON_ACTIVE_CHANGELIST && ((status = this.myChangeListManager.getStatus(virtualFile)) == FileStatus.MODIFIED || status == FileStatus.ADDED) && !conflictTracker.isFromActiveChangelist(virtualFile)) {
            return status == FileStatus.MODIFIED ? MODIFIED_OUTSIDE : ADDED_OUTSIDE;
        }
        return null;
    }

    public void refreshFileStatusFromDocument(@NotNull VirtualFile virtualFile, @NotNull Document doc) {
    }

    @NotNull
    public ThreeState getNotChangedDirectoryParentingStatus(@NotNull VirtualFile virtualFile) {
        throw new UnsupportedOperationException("Shouldn't be called");
    }
}

