/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.committed.BrowseCommittedChangesActionKt;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesFilterDialog;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesViewManager;
import com.intellij.openapi.vcs.versionBrowser.ChangeBrowserSettings;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/openapi/vcs/changes/committed/BrowseCommittedChangesAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "intellij.platform.vcs.impl"})
public final class BrowseCommittedChangesAction
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        e.getPresentation().setEnabledAndVisible(false);
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        VirtualFile virtualFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (virtualFile == null) {
            return;
        }
        VirtualFile file = virtualFile;
        AbstractVcs abstractVcs = ChangesUtil.getVcsForFile((VirtualFile)file, (Project)project2);
        if (abstractVcs == null) {
            return;
        }
        AbstractVcs vcs = abstractVcs;
        if (!CommittedChangesViewManager.Companion.isCommittedChangesAvailable(vcs)) {
            return;
        }
        e.getPresentation().setVisible(true);
        e.getPresentation().setEnabled(vcs.allowsRemoteCalls(file) && AbstractVcs.fileInVcsByFileStatus((Project)vcs.getProject(), (VirtualFile)file));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            Intrinsics.throwNpe();
        }
        Project project2 = project;
        Object object = e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (object == null) {
            Intrinsics.throwNpe();
        }
        VirtualFile file = (VirtualFile)object;
        AbstractVcs abstractVcs = ChangesUtil.getVcsForFile((VirtualFile)file, (Project)project2);
        if (abstractVcs == null) {
            Intrinsics.throwNpe();
        }
        AbstractVcs vcs = abstractVcs;
        ChangeBrowserSettings settings = BrowseCommittedChangesActionKt.access$getChangeBrowserSettings(vcs);
        CommittedChangesProvider committedChangesProvider = vcs.getCommittedChangesProvider();
        if (committedChangesProvider == null) {
            Intrinsics.throwNpe();
        }
        if (new CommittedChangesFilterDialog(project2, committedChangesProvider.createFilterUI(true), settings).showAndGet()) {
            BrowseCommittedChangesActionKt.access$showCommittedChanges(vcs, file, settings);
        }
    }
}

