/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions.diff.lst;

import com.intellij.diff.DiffContext;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.simple.SimpleDiffChange;
import com.intellij.diff.tools.simple.SimpleDiffChangeUi;
import com.intellij.diff.tools.simple.SimpleDiffViewer;
import com.intellij.diff.tools.util.DiffNotifications;
import com.intellij.diff.tools.util.base.DiffViewerBase;
import com.intellij.diff.util.DiffGutterOperation;
import com.intellij.diff.util.DiffGutterRenderer;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Side;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vcs.changes.actions.diff.lst.LocalChangeListDiffRequest;
import com.intellij.openapi.vcs.changes.actions.diff.lst.LocalChangeListDiffTool;
import com.intellij.openapi.vcs.changes.actions.diff.lst.LocalTrackerDiffUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleLocalChangeListDiffViewer
extends SimpleDiffViewer {
    @NotNull
    private final LocalChangeListDiffRequest myLocalRequest;
    private final boolean myAllowExcludeChangesFromCommit;
    private final LocalTrackerDiffUtil.LocalTrackerActionProvider myTrackerActionProvider;
    private LocalTrackerDiffUtil.ExcludeAllCheckboxPanel myExcludeAllCheckboxPanel;

    public SimpleLocalChangeListDiffViewer(@NotNull DiffContext context, @NotNull LocalChangeListDiffRequest localRequest) {
        super(context, (DiffRequest)localRequest.getRequest());
        this.myLocalRequest = localRequest;
        this.myAllowExcludeChangesFromCommit = DiffUtil.isUserDataFlagSet(LocalChangeListDiffTool.ALLOW_EXCLUDE_FROM_COMMIT, (UserDataHolder[])new UserDataHolder[]{context});
        this.myTrackerActionProvider = new MyLocalTrackerActionProvider(this, localRequest, this.myAllowExcludeChangesFromCommit);
        this.myExcludeAllCheckboxPanel.init(this.myLocalRequest, this.myAllowExcludeChangesFromCommit);
        LocalTrackerDiffUtil.installTrackerListener((DiffViewerBase)this, this.myLocalRequest);
    }

    @NotNull
    protected List<JComponent> createTitles() {
        List titles = DiffUtil.createTextTitles((ContentDiffRequest)this.myRequest, (List)this.getEditors());
        assert (titles.size() == 2);
        this.myExcludeAllCheckboxPanel = new LocalTrackerDiffUtil.ExcludeAllCheckboxPanel((DiffViewerBase)this, this.getEditor2());
        BorderLayoutPanel titleWithCheckbox = JBUI.Panels.simplePanel();
        if (titles.get(1) != null) {
            titleWithCheckbox.addToCenter((Component)titles.get(1));
        }
        titleWithCheckbox.addToLeft((Component)this.myExcludeAllCheckboxPanel);
        return DiffUtil.createSyncHeightComponents(Arrays.asList((JComponent)titles.get(0), titleWithCheckbox));
    }

    @NotNull
    protected List<AnAction> createEditorPopupActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>(super.createEditorPopupActions());
        group.addAll(LocalTrackerDiffUtil.createTrackerActions(this.myTrackerActionProvider));
        return group;
    }

    @NotNull
    protected SimpleDiffChangeUi createUi(@NotNull SimpleDiffChange change) {
        if (change instanceof MySimpleDiffChange) {
            return new MySimpleDiffChangeUi(this, (MySimpleDiffChange)change);
        }
        return super.createUi(change);
    }

    @NotNull
    private Runnable superComputeDifferences(@NotNull ProgressIndicator indicator) {
        return super.computeDifferences(indicator);
    }

    @NotNull
    protected Runnable computeDifferences(@NotNull ProgressIndicator indicator) {
        return LocalTrackerDiffUtil.computeDifferences(this.myLocalRequest.getLineStatusTracker(), this.getContent1().getDocument(), this.getContent2().getDocument(), this.myLocalRequest.getChangelistId(), this.myTextDiffProvider, indicator, new MyLocalTrackerDiffHandler(indicator));
    }

    protected void onAfterRediff() {
        super.onAfterRediff();
        this.myExcludeAllCheckboxPanel.refresh();
    }

    private static class MyLocalTrackerActionProvider
    extends LocalTrackerDiffUtil.LocalTrackerActionProvider {
        @NotNull
        private final SimpleLocalChangeListDiffViewer myViewer;

        private MyLocalTrackerActionProvider(@NotNull SimpleLocalChangeListDiffViewer viewer, @NotNull LocalChangeListDiffRequest localRequest, boolean allowExcludeChangesFromCommit) {
            super((DiffViewerBase)viewer, localRequest, allowExcludeChangesFromCommit);
            this.myViewer = viewer;
        }

        @Override
        @Nullable
        public List<LocalTrackerDiffUtil.LocalTrackerChange> getSelectedTrackerChanges(@NotNull AnActionEvent e) {
            Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
            Side side = Side.fromValue((List)this.myViewer.getEditors(), (Object)editor);
            if (side == null) {
                return null;
            }
            return StreamEx.of((Collection)this.myViewer.getSelectedChanges(side)).select(MySimpleDiffChange.class).map(it -> new LocalTrackerDiffUtil.LocalTrackerChange(it.getStartLine(Side.RIGHT), it.getEndLine(Side.RIGHT), ((MySimpleDiffChange)it).myChangelistId, ((MySimpleDiffChange)it).myIsExcludedFromCommit)).toList();
        }
    }

    private static class MySimpleDiffChangeUi
    extends SimpleDiffChangeUi {
        private MySimpleDiffChangeUi(@NotNull SimpleLocalChangeListDiffViewer viewer, @NotNull MySimpleDiffChange change) {
            super((SimpleDiffViewer)viewer, (SimpleDiffChange)change);
        }

        @NotNull
        private SimpleLocalChangeListDiffViewer getViewer() {
            return (SimpleLocalChangeListDiffViewer)this.myViewer;
        }

        @NotNull
        private MySimpleDiffChange getChange() {
            return (MySimpleDiffChange)this.myChange;
        }

        protected void doInstallActionHighlighters() {
            super.doInstallActionHighlighters();
            if (this.getViewer().myAllowExcludeChangesFromCommit) {
                ContainerUtil.addIfNotNull((Collection)this.myOperations, (Object)this.createExcludeGutterOperation());
            }
        }

        @Nullable
        private DiffGutterOperation createExcludeGutterOperation() {
            if (!this.getChange().isFromActiveChangelist()) {
                return null;
            }
            final boolean isExcludedFromCommit = this.getChange().isExcludedFromCommit();
            Icon icon2 = isExcludedFromCommit ? AllIcons.Diff.GutterCheckBox : AllIcons.Diff.GutterCheckBoxSelected;
            return this.createOperation(Side.RIGHT, (ctrlPressed, shiftPressed, altPressed) -> new DiffGutterRenderer(icon2, DiffBundle.message((String)"action.presentation.diff.include.into.commit.text", (Object[])new Object[0])){

                protected void handleMouseClick() {
                    if (!myChange.isValid()) {
                        return;
                    }
                    int line = myChange.getStartLine(Side.RIGHT);
                    LocalTrackerDiffUtil.toggleRangeAtLine(this.getViewer().myTrackerActionProvider, line, isExcludedFromCommit);
                }
            });
        }
    }

    private static class MySimpleDiffChange
    extends SimpleDiffChange {
        @NotNull
        private final String myChangelistId;
        private final boolean myIsFromActiveChangelist;
        private final boolean myIsExcludedFromCommit;

        MySimpleDiffChange(int index, @NotNull LineFragment fragment, boolean isExcluded, boolean isSkipped, @NotNull String changelistId, boolean isFromActiveChangelist, boolean isExcludedFromCommit) {
            super(index, fragment, isExcluded, isSkipped);
            this.myChangelistId = changelistId;
            this.myIsFromActiveChangelist = isFromActiveChangelist;
            this.myIsExcludedFromCommit = isExcludedFromCommit;
        }

        @NotNull
        public String getChangelistId() {
            return this.myChangelistId;
        }

        public boolean isFromActiveChangelist() {
            return this.myIsFromActiveChangelist;
        }

        public boolean isExcludedFromCommit() {
            return this.myIsExcludedFromCommit;
        }
    }

    private class MyLocalTrackerDiffHandler
    implements LocalTrackerDiffUtil.LocalTrackerDiffHandler {
        @NotNull
        private final ProgressIndicator myIndicator;

        private MyLocalTrackerDiffHandler(ProgressIndicator indicator) {
            this.myIndicator = indicator;
        }

        @Override
        @NotNull
        public Runnable done(boolean isContentsEqual, CharSequence @NotNull [] texts, @NotNull List<? extends LineFragment> fragments, @NotNull List<LocalTrackerDiffUtil.LineFragmentData> fragmentsData) {
            ArrayList<MySimpleDiffChange> changes = new ArrayList<MySimpleDiffChange>();
            for (int i = 0; i < fragments.size(); ++i) {
                LineFragment fragment = fragments.get(i);
                LocalTrackerDiffUtil.LineFragmentData data = fragmentsData.get(i);
                boolean isExcludedFromCommit = data.isExcludedFromCommit();
                boolean isFromActiveChangelist = data.isFromActiveChangelist();
                boolean isSkipped = data.isSkipped();
                boolean isExcluded = data.isExcluded(SimpleLocalChangeListDiffViewer.this.myAllowExcludeChangesFromCommit);
                changes.add(new MySimpleDiffChange(changes.size(), fragment, isExcluded, isSkipped, data.getChangelistId(), isFromActiveChangelist, isExcludedFromCommit));
            }
            return SimpleLocalChangeListDiffViewer.this.apply(changes, isContentsEqual);
        }

        @Override
        @NotNull
        public Runnable retryLater() {
            SimpleLocalChangeListDiffViewer.this.scheduleRediff();
            throw new ProcessCanceledException();
        }

        @Override
        @NotNull
        public Runnable fallback() {
            return SimpleLocalChangeListDiffViewer.this.superComputeDifferences(this.myIndicator);
        }

        @Override
        @NotNull
        public Runnable fallbackWithProgress() {
            Runnable callback2 = SimpleLocalChangeListDiffViewer.this.superComputeDifferences(this.myIndicator);
            return () -> {
                callback2.run();
                SimpleLocalChangeListDiffViewer.this.getStatusPanel().setBusy(true);
            };
        }

        @Override
        @NotNull
        public Runnable error() {
            return SimpleLocalChangeListDiffViewer.this.applyNotification(DiffNotifications.createError());
        }
    }
}

