/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions.diff;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffRequestFactory;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeDiffRequestProducer;
import com.intellij.openapi.vcs.changes.ui.ChangeDiffRequestChain;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnversionedDiffRequestProducer
implements ChangeDiffRequestChain.Producer {
    @Nullable
    private final Project myProject;
    @NotNull
    private final FilePath myPath;

    private UnversionedDiffRequestProducer(@Nullable Project project, @NotNull FilePath path2) {
        this.myProject = project;
        this.myPath = path2;
    }

    @Override
    @NotNull
    public FilePath getFilePath() {
        return this.myPath;
    }

    @Override
    @NotNull
    public FileStatus getFileStatus() {
        return FileStatus.UNKNOWN;
    }

    @Override
    @Nullable
    public Object getPopupTag() {
        return ChangesBrowserNode.UNVERSIONED_FILES_TAG;
    }

    @NotNull
    public String getName() {
        return this.myPath.getPresentableUrl();
    }

    @NotNull
    public DiffRequest process(@NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException, ProcessCanceledException {
        VirtualFile file = this.myPath.getVirtualFile();
        if (file == null) {
            throw new DiffRequestProducerException("Can't show diff - file not found");
        }
        return UnversionedDiffRequestProducer.createRequest(this.myProject, file);
    }

    @NotNull
    public static UnversionedDiffRequestProducer create(@Nullable Project project, @NotNull FilePath path2) {
        return new UnversionedDiffRequestProducer(project, path2);
    }

    @NotNull
    private static DiffRequest createRequest(@Nullable Project project, @NotNull VirtualFile file) {
        DiffContentFactory contentFactory = DiffContentFactory.getInstance();
        EmptyContent content1 = contentFactory.createEmpty();
        DiffContent content2 = contentFactory.create(project, file);
        SimpleDiffRequest request = new SimpleDiffRequest(DiffRequestFactory.getInstance().getTitle(file), (DiffContent)content1, content2, null, ChangeDiffRequestProducer.getYourVersion());
        DiffUtil.putDataKey((UserDataHolder)request, (DataKey)VcsDataKeys.CURRENT_UNVERSIONED, (Object)file);
        return request;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnversionedDiffRequestProducer producer = (UnversionedDiffRequestProducer)o;
        return Objects.equals(this.myPath, producer.myPath);
    }

    public int hashCode() {
        return this.myPath.hashCode();
    }
}

