/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.ListSelection;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionExtensionProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.actions.diff.ShowDiffAction;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesBrowserUseCase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowDiffWithLocalAction
extends AnAction
implements DumbAware,
AnActionExtensionProvider {
    private final boolean myUseBeforeVersion;

    public ShowDiffWithLocalAction() {
        this(false);
        this.getTemplatePresentation().setIcon(AllIcons.Actions.Diff);
    }

    public ShowDiffWithLocalAction(boolean useBeforeVersion) {
        this.myUseBeforeVersion = useBeforeVersion;
        ActionUtil.copyFrom((AnAction)this, (String)(useBeforeVersion ? "Vcs.ShowDiffWithLocal.Before" : "Vcs.ShowDiffWithLocal"));
    }

    public boolean isActive(@NotNull AnActionEvent e) {
        return e.getData(VcsDataKeys.CHANGES_SELECTION) != null;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        if (ChangeListManager.getInstance((Project)project).isFreezedWithNotification(null)) {
            return;
        }
        ListSelection selection = (ListSelection)e.getRequiredData(VcsDataKeys.CHANGES_SELECTION);
        ListSelection changesToLocal = selection.map(change -> this.getChangeWithLocal((Change)change));
        if (!changesToLocal.isEmpty()) {
            ShowDiffAction.showDiffForChange(project, (ListSelection<? extends Change>)changesToLocal);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        ListSelection selection = (ListSelection)e.getData(VcsDataKeys.CHANGES_SELECTION);
        boolean isInAir = CommittedChangesBrowserUseCase.IN_AIR.equals(e.getData(CommittedChangesBrowserUseCase.DATA_KEY));
        e.getPresentation().setEnabled(project != null && selection != null && !isInAir && this.canShowDiff(selection.getList()));
    }

    @Nullable
    private Change getChangeWithLocal(@NotNull Change c) {
        ContentRevision localRevision;
        ContentRevision revision = this.myUseBeforeVersion ? c.getBeforeRevision() : c.getAfterRevision();
        ContentRevision otherRevision = this.myUseBeforeVersion ? c.getAfterRevision() : c.getBeforeRevision();
        VirtualFile file = ShowDiffWithLocalAction.getLocalVirtualFileFor(revision);
        if (file == null) {
            file = ShowDiffWithLocalAction.getLocalVirtualFileFor(otherRevision);
        }
        ContentRevision contentRevision = localRevision = file != null ? CurrentContentRevision.create((FilePath)VcsUtil.getFilePath((VirtualFile)file)) : null;
        if (revision == null && localRevision == null) {
            return null;
        }
        return new Change(revision, localRevision);
    }

    private boolean canShowDiff(@NotNull List<? extends Change> changes) {
        return ContainerUtil.exists(changes, c -> this.getChangeWithLocal((Change)c) != null);
    }

    @Nullable
    private static VirtualFile getLocalVirtualFileFor(@Nullable ContentRevision revision) {
        if (revision == null) {
            return null;
        }
        FilePath filePath = revision.getFile();
        if (filePath.isNonLocal() || filePath.isDirectory()) {
            return null;
        }
        return filePath.getVirtualFile();
    }

    public static class ShowDiffBeforeWithLocalAction
    extends ShowDiffWithLocalAction {
        public ShowDiffBeforeWithLocalAction() {
            super(true);
        }
    }
}

