/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.actions.RevertCommittedStuffAbstractAction;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RevertSelectedChangesAction
extends RevertCommittedStuffAbstractAction {
    protected RevertSelectedChangesAction(boolean reverse) {
        super(reverse);
    }

    @Override
    protected boolean isEnabled(@NotNull AnActionEvent e) {
        return super.isEnabled(e) && RevertSelectedChangesAction.allSelectedChangeListsAreRevertable(e);
    }

    private static boolean allSelectedChangeListsAreRevertable(@NotNull AnActionEvent e) {
        ChangeList[] changeLists = (ChangeList[])e.getData(VcsDataKeys.CHANGE_LISTS);
        if (changeLists == null) {
            return true;
        }
        for (ChangeList list : changeLists) {
            if (!(list instanceof CommittedChangeList) || ((CommittedChangeList)list).isModifiable()) continue;
            return false;
        }
        return true;
    }

    @Override
    protected Change @Nullable [] getChanges(@NotNull AnActionEvent e, boolean isFromUpdate) {
        if (!isFromUpdate) {
            e.getData(VcsDataKeys.CHANGES_WITH_MOVED_CHILDREN);
        }
        return (Change[])e.getData(VcsDataKeys.SELECTED_CHANGES_IN_DETAILS);
    }

    public static class Apply
    extends RevertSelectedChangesAction {
        public Apply() {
            super(false);
        }
    }

    public static class Revert
    extends RevertSelectedChangesAction {
        public Revert() {
            super(true);
        }
    }
}

