/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionExtensionProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.ExtendableAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.CommitSession;
import com.intellij.openapi.vcs.changes.patch.CreatePatchCommitExecutor;
import com.intellij.openapi.vcs.changes.patch.PatchWriter;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangesViewManager;
import com.intellij.openapi.vcs.changes.ui.SessionDialog;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CreatePatchFromChangesAction
extends ExtendableAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(CreatePatchFromChangesAction.class);
    private static final ExtensionPointName<AnActionExtensionProvider> EP_NAME_DIALOG = ExtensionPointName.create((String)"com.intellij.openapi.vcs.changes.actions.CreatePatchFromChangesAction.Dialog.ExtensionProvider");
    private static final ExtensionPointName<AnActionExtensionProvider> EP_NAME_CLIPBOARD = ExtensionPointName.create((String)"com.intellij.openapi.vcs.changes.actions.CreatePatchFromChangesAction.Clipboard.ExtensionProvider");
    private final boolean mySilentClipboard;

    private CreatePatchFromChangesAction(boolean silentClipboard) {
        super(silentClipboard ? EP_NAME_CLIPBOARD : EP_NAME_DIALOG);
        this.mySilentClipboard = silentClipboard;
    }

    public void defaultActionPerformed(@NotNull AnActionEvent e) {
        CreatePatchCommitExecutor.PatchBuilder patchBuilder;
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        Object[] changes = (Change[])e.getData(VcsDataKeys.CHANGES);
        if (ArrayUtil.isEmpty((Object[])changes)) {
            return;
        }
        String commitMessage2 = CreatePatchFromChangesAction.extractCommitMessage(e);
        project = (Project)ObjectUtils.chooseNotNull((Object)project, (Object)ProjectManager.getInstance().getDefaultProject());
        ShelvedChangeList shelvedChangeList = (ShelvedChangeList)ContainerUtil.getOnlyItem(ShelvedChangesViewManager.getShelvedLists(e.getDataContext()));
        if (shelvedChangeList != null) {
            boolean entireList = ContainerUtil.getOnlyItem(ShelvedChangesViewManager.getExactlySelectedLists(e.getDataContext())) != null;
            List<String> selectedPaths = entireList ? ContainerUtil.emptyList() : ShelvedChangesViewManager.getSelectedShelvedChangeNames(e.getDataContext());
            patchBuilder = new CreatePatchCommitExecutor.ShelfPatchBuilder(project, shelvedChangeList, selectedPaths);
        } else {
            patchBuilder = new CreatePatchCommitExecutor.DefaultPatchBuilder(project);
        }
        CreatePatchFromChangesAction.createPatch(project, commitMessage2, Arrays.asList(changes), this.mySilentClipboard, patchBuilder);
    }

    @Nullable
    private static String extractCommitMessage(@NotNull AnActionEvent e) {
        String message = (String)e.getData(VcsDataKeys.PRESET_COMMIT_MESSAGE);
        if (message != null) {
            return message;
        }
        List<ShelvedChangeList> shelvedChangeLists = ShelvedChangesViewManager.getShelvedLists(e.getDataContext());
        if (!shelvedChangeLists.isEmpty()) {
            return shelvedChangeLists.get((int)0).DESCRIPTION;
        }
        ChangeList[] changeLists = (ChangeList[])e.getData(VcsDataKeys.CHANGE_LISTS);
        if (changeLists != null && changeLists.length > 0) {
            return changeLists[0].getComment();
        }
        return null;
    }

    public static void createPatch(@Nullable Project project, @Nullable String commitMessage2, @NotNull List<? extends Change> changes) {
        CreatePatchFromChangesAction.createPatch(project, commitMessage2, changes, false);
    }

    public static void createPatch(@Nullable Project project, @Nullable String commitMessage2, @NotNull List<? extends Change> changes, boolean silentClipboard) {
        project = (Project)ObjectUtils.chooseNotNull((Object)project, (Object)ProjectManager.getInstance().getDefaultProject());
        CreatePatchCommitExecutor.DefaultPatchBuilder patchBuilder = new CreatePatchCommitExecutor.DefaultPatchBuilder(project);
        CreatePatchFromChangesAction.createPatch(project, commitMessage2, changes, silentClipboard, patchBuilder);
    }

    private static void createPatch(@NotNull Project project, @Nullable String commitMessage2, @NotNull List<? extends Change> changes, boolean silentClipboard, @NotNull CreatePatchCommitExecutor.PatchBuilder patchBuilder) {
        CommitContext commitContext = new CommitContext();
        if (silentClipboard) {
            CreatePatchFromChangesAction.createIntoClipboard(project, changes, patchBuilder, commitContext);
        } else {
            CreatePatchFromChangesAction.createWithDialog(project, commitMessage2, changes, patchBuilder, commitContext);
        }
    }

    private static void createWithDialog(@NotNull Project project, @Nullable String commitMessage2, @NotNull List<? extends Change> changes, @NotNull CreatePatchCommitExecutor.PatchBuilder patchBuilder, @NotNull CommitContext commitContext) {
        CommitSession commitSession = CreatePatchCommitExecutor.createCommitSession(project, patchBuilder, commitContext);
        SessionDialog sessionDialog = new SessionDialog(VcsBundle.message((String)"action.name.create.patch", (Object[])new Object[0]), project, commitSession, changes, commitMessage2);
        if (!sessionDialog.showAndGet()) {
            return;
        }
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> commitSession.execute((Collection)changes, commitMessage2), VcsBundle.message((String)"create.patch.commit.action.progress", (Object[])new Object[0]), true, project);
    }

    private static void createIntoClipboard(@NotNull Project project, @NotNull List<? extends Change> changes, @NotNull CreatePatchCommitExecutor.PatchBuilder patchBuilder, @NotNull CommitContext commitContext) {
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            try {
                String baseDir = PatchWriter.calculateBaseForWritingPatch(project, changes).getPath();
                CreatePatchCommitExecutor.writePatchToClipboard(project, baseDir, changes, false, false, patchBuilder, commitContext);
            }
            catch (VcsException | IOException exception) {
                LOG.warn("Can't create patch", exception);
                VcsNotifier.getInstance(project).notifyWeakError(VcsBundle.message((String)"patch.creation.failed", (Object[])new Object[0]), exception.getMessage());
            }
        }, VcsBundle.message((String)"create.patch.commit.action.progress", (Object[])new Object[0]), true, project);
    }

    public void defaultUpdate(@NotNull AnActionEvent e) {
        Boolean haveSelectedChanges = (Boolean)e.getData(VcsDataKeys.HAVE_SELECTED_CHANGES);
        ChangeList[] changeLists = (ChangeList[])e.getData(VcsDataKeys.CHANGE_LISTS);
        List<ShelvedChangeList> shelveChangelists = ShelvedChangesViewManager.getShelvedLists(e.getDataContext());
        int changelistNum = changeLists == null ? 0 : changeLists.length;
        e.getPresentation().setEnabled(!Boolean.FALSE.equals(haveSelectedChanges) && (changelistNum += shelveChangelists.size()) <= 1 && !ArrayUtil.isEmpty((Object[])((Object[])e.getData(VcsDataKeys.CHANGES))));
    }

    public static class Clipboard
    extends CreatePatchFromChangesAction {
        public Clipboard() {
            super(true);
        }
    }

    public static class Dialog
    extends CreatePatchFromChangesAction {
        public Dialog() {
            super(false);
        }
    }
}

