/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.configurationStore.Scheme_implKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.Ignored;
import com.intellij.openapi.vcs.IgnoredCheckResult;
import com.intellij.openapi.vcs.NotIgnored;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsIgnoreChecker;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.changes.IgnoredFileContentProvider;
import com.intellij.openapi.vcs.changes.IgnoredFileProvider;
import com.intellij.openapi.vcs.changes.VcsIgnoreManager;
import com.intellij.openapi.vcs.changes.VcsIgnoreManagerImplKt;
import com.intellij.openapi.vcs.changes.VcsIgnoreManagerImplKt$sam$com_intellij_openapi_util_ThrowableComputable$0;
import com.intellij.openapi.vcs.changes.ignore.lang.IgnoreFileType;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.project.ProjectKt;
import com.intellij.util.Alarm;
import com.intellij.util.PathUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.vcsUtil.VcsImplUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u0000 $2\u00020\u0001:\u0001$B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\fH\u0002J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010\u001b\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\fH\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\fH\u0016J\u0010\u0010 \u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010 \u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010!\u001a\u00020\u001e2\u0006\u0010\u0010\u001a\u00020\fH\u0016J\u0018\u0010\"\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\fH\u0002J\u0010\u0010#\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\fH\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/intellij/openapi/vcs/changes/VcsIgnoreManagerImpl;", "Lcom/intellij/openapi/vcs/changes/VcsIgnoreManager;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "ignoreRefreshQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "getIgnoreRefreshQueue", "()Lcom/intellij/util/ui/update/MergingUpdateQueue;", "checkConfigurationVcsIgnored", "Lcom/intellij/openapi/vcs/IgnoredCheckResult;", "configurationFileName", "", "checkProjectNotDefault", "", "configurationNameToFileName", "configurationName", "findIgnoreFileType", "Lcom/intellij/openapi/vcs/changes/ignore/lang/IgnoreFileType;", "vcs", "Lcom/intellij/openapi/vcs/AbstractVcs;", "getCheckerForFile", "Lcom/intellij/openapi/vcs/VcsIgnoreChecker;", "filePath", "Lcom/intellij/openapi/vcs/FilePath;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getDirectoryVcsIgnoredStatus", "dirPathString", "isDirectoryVcsIgnored", "", "dirPath", "isPotentiallyIgnoredFile", "isRunConfigurationVcsIgnored", "removeConfigurationFromVcsIgnore", "removeRunConfigurationFromVcsIgnore", "Companion", "intellij.platform.vcs.impl"})
public final class VcsIgnoreManagerImpl
implements VcsIgnoreManager {
    @NotNull
    private final MergingUpdateQueue ignoreRefreshQueue;
    private final Project project;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final MergingUpdateQueue getIgnoreRefreshQueue() {
        return this.ignoreRefreshQueue;
    }

    @Nullable
    public final IgnoreFileType findIgnoreFileType(@NotNull AbstractVcs vcs) {
        IgnoredFileContentProvider ignoredFileContentProvider = VcsImplUtil.findIgnoredFileContentProvider(vcs);
        if (ignoredFileContentProvider == null) {
            return null;
        }
        IgnoredFileContentProvider ignoredFileContentProvider2 = ignoredFileContentProvider;
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(ignoredFileContentProvider2.getFileName());
        if (!(fileType instanceof IgnoreFileType)) {
            fileType = null;
        }
        return (IgnoreFileType)fileType;
    }

    public boolean isDirectoryVcsIgnored(@NotNull String dirPath) {
        try {
            Function0 checkForIgnore2;
            Function0 function0 = checkForIgnore2 = (Function0)new Function0<Boolean>(this, dirPath){
                final /* synthetic */ VcsIgnoreManagerImpl this$0;
                final /* synthetic */ String $dirPath;

                public final boolean invoke() {
                    return VcsIgnoreManagerImpl.access$getDirectoryVcsIgnoredStatus(this.this$0, VcsIgnoreManagerImpl.access$getProject$p(this.this$0), this.$dirPath) instanceof Ignored;
                }
                {
                    this.this$0 = vcsIgnoreManagerImpl;
                    this.$dirPath = string;
                    super(0);
                }
            };
            return (Boolean)ProgressManager.getInstance().runProcessWithProgressSynchronously((ThrowableComputable)new VcsIgnoreManagerImplKt$sam$com_intellij_openapi_util_ThrowableComputable$0(function0), VcsBundle.message((String)"checking.vcs.status.progress", (Object[])new Object[0]), false, this.project);
        }
        catch (IOException e) {
            VcsIgnoreManagerImplKt.access$getLOG$p().warn((Throwable)e);
            return false;
        }
    }

    private final IgnoredCheckResult getDirectoryVcsIgnoredStatus(Project project, String dirPathString) {
        FilePath dirPath = VcsContextFactory.SERVICE.getInstance().createFilePath(dirPathString, true);
        VirtualFile virtualFile = VcsUtil.getVcsRootFor((Project)project, (FilePath)dirPath);
        if (virtualFile == null) {
            return (IgnoredCheckResult)NotIgnored.INSTANCE;
        }
        VirtualFile vcsRoot = virtualFile;
        VcsIgnoreChecker vcsIgnoreChecker = this.getCheckerForFile(project, dirPath);
        if (vcsIgnoreChecker == null || (vcsIgnoreChecker = vcsIgnoreChecker.isFilePatternIgnored(vcsRoot, dirPathString)) == null) {
            vcsIgnoreChecker = (IgnoredCheckResult)NotIgnored.INSTANCE;
        }
        return vcsIgnoreChecker;
    }

    public boolean isRunConfigurationVcsIgnored(@NotNull String configurationName) {
        try {
            Function0 checkForIgnore2;
            String configurationFileName = this.configurationNameToFileName(configurationName);
            Function0 function0 = checkForIgnore2 = (Function0)new Function0<Boolean>(this, configurationFileName){
                final /* synthetic */ VcsIgnoreManagerImpl this$0;
                final /* synthetic */ String $configurationFileName;

                public final boolean invoke() {
                    return VcsIgnoreManagerImpl.access$checkConfigurationVcsIgnored(this.this$0, VcsIgnoreManagerImpl.access$getProject$p(this.this$0), this.$configurationFileName) instanceof Ignored;
                }
                {
                    this.this$0 = vcsIgnoreManagerImpl;
                    this.$configurationFileName = string;
                    super(0);
                }
            };
            return (Boolean)ProgressManager.getInstance().runProcessWithProgressSynchronously((ThrowableComputable)new VcsIgnoreManagerImplKt$sam$com_intellij_openapi_util_ThrowableComputable$0(function0), "Checking configuration " + configurationName + " for ignore...", false, this.project);
        }
        catch (IOException e) {
            VcsIgnoreManagerImplKt.access$getLOG$p().warn((Throwable)e);
            return false;
        }
    }

    public void removeRunConfigurationFromVcsIgnore(@NotNull String configurationName) {
        try {
            Function0 removeFromIgnore2;
            Function0 function0 = removeFromIgnore2 = (Function0)new Function0<Unit>(this, configurationName){
                final /* synthetic */ VcsIgnoreManagerImpl this$0;
                final /* synthetic */ String $configurationName;

                public final void invoke() {
                    VcsIgnoreManagerImpl.access$removeConfigurationFromVcsIgnore(this.this$0, VcsIgnoreManagerImpl.access$getProject$p(this.this$0), this.$configurationName);
                }
                {
                    this.this$0 = vcsIgnoreManagerImpl;
                    this.$configurationName = string;
                    super(0);
                }
            };
            ProgressManager.getInstance().runProcessWithProgressSynchronously((ThrowableComputable)new VcsIgnoreManagerImplKt$sam$com_intellij_openapi_util_ThrowableComputable$0(function0), "Removing configuration " + configurationName + " from ignore...", false, this.project);
        }
        catch (IOException io) {
            VcsIgnoreManagerImplKt.access$getLOG$p().warn((Throwable)io);
        }
    }

    public boolean isPotentiallyIgnoredFile(@NotNull VirtualFile file) {
        return this.isPotentiallyIgnoredFile(VcsUtil.getFilePath((VirtualFile)file));
    }

    public boolean isPotentiallyIgnoredFile(@NotNull FilePath filePath) {
        boolean $i$f$runReadAction = false;
        return (Boolean)ApplicationManager.getApplication().runReadAction(new Computable<T>(this, filePath){
            final /* synthetic */ VcsIgnoreManagerImpl this$0;
            final /* synthetic */ FilePath $filePath$inlined;
            {
                this.this$0 = vcsIgnoreManagerImpl;
                this.$filePath$inlined = filePath;
            }

            public final T compute() {
                boolean bl;
                block3: {
                    boolean bl2 = false;
                    if (VcsIgnoreManagerImpl.access$getProject$p(this.this$0).isDisposed()) {
                        bl = false;
                    } else {
                        Object[] $this$any$iv = IgnoredFileProvider.IGNORE_FILE.getExtensions();
                        boolean $i$f$any = false;
                        for (Object element$iv : $this$any$iv) {
                            IgnoredFileProvider it = (IgnoredFileProvider)element$iv;
                            boolean bl3 = false;
                            if (!it.isIgnoredFile(VcsIgnoreManagerImpl.access$getProject$p(this.this$0), this.$filePath$inlined)) continue;
                            bl = true;
                            break block3;
                        }
                        bl = false;
                    }
                }
                return (T)Boolean.valueOf(bl);
            }
        });
    }

    private final void removeConfigurationFromVcsIgnore(Project project, String configurationName) {
        VirtualFile virtualFile;
        if (ProjectKt.isDirectoryBased((Project)project)) {
            String string = ProjectKt.getStateStore((Project)project).getProjectConfigDir();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            if ((virtualFile = VfsUtil.findFile((Path)Paths.get(string, new String[0]), (boolean)true)) == null) {
                Intrinsics.throwNpe();
            }
        } else {
            virtualFile = project.getProjectFile();
            if (virtualFile == null) {
                Intrinsics.throwNpe();
            }
        }
        VirtualFile projectFileOrConfigDir = virtualFile;
        VirtualFile virtualFile2 = VcsUtil.getVcsRootFor((Project)project, (VirtualFile)projectFileOrConfigDir);
        if (virtualFile2 == null) {
            return;
        }
        VirtualFile projectVcsRoot = virtualFile2;
        AbstractVcs vcs = VcsUtil.getVcsFor((Project)project, (VirtualFile)projectVcsRoot);
        if (vcs == null) {
            VcsIgnoreManagerImplKt.access$getLOG$p().debug("Cannot get VCS for root " + projectVcsRoot.getPath());
            return;
        }
        IgnoredFileContentProvider ignoreContentProvider = VcsImplUtil.findIgnoredFileContentProvider(vcs);
        if (ignoreContentProvider == null) {
            VcsIgnoreManagerImplKt.access$getLOG$p().debug("Cannot get ignore content provider for vcs " + vcs.getName());
            return;
        }
        IgnoredCheckResult checkResult = this.checkConfigurationVcsIgnored(project, configurationName);
        if (checkResult instanceof Ignored) {
            File ignoreFile = ((Ignored)checkResult).getIgnoreFile();
            FileUtil.appendToFile((File)ignoreFile, (String)ignoreContentProvider.buildUnignoreContent(((Ignored)checkResult).getMatchedPattern()));
        }
    }

    private final IgnoredCheckResult checkConfigurationVcsIgnored(Project project, String configurationFileName) {
        VcsIgnoreChecker vcsIgnoreChecker;
        if (ProjectKt.isDirectoryBased((Project)project)) {
            String string = ProjectKt.getStateStore((Project)project).getProjectConfigDir();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            VirtualFile virtualFile = VfsUtil.findFile((Path)Paths.get(string, new String[0]), (boolean)true);
            if (virtualFile == null) {
                Intrinsics.throwNpe();
            }
            VirtualFile projectConfigDir = virtualFile;
            File checkForIgnore2 = FilesKt.resolve((File)FilesKt.resolve((File)VfsUtilCore.virtualToIoFile((VirtualFile)projectConfigDir), (String)"runConfigurations"), (String)(configurationFileName + "*.xml"));
            VirtualFile virtualFile2 = VcsUtil.getVcsRootFor((Project)project, (VirtualFile)projectConfigDir);
            if (virtualFile2 == null) {
                return (IgnoredCheckResult)NotIgnored.INSTANCE;
            }
            VirtualFile vcsRootForIgnore = virtualFile2;
            vcsIgnoreChecker = this.getCheckerForFile(project, projectConfigDir);
            if (vcsIgnoreChecker == null || (vcsIgnoreChecker = vcsIgnoreChecker.isFilePatternIgnored(vcsRootForIgnore, PathUtil.toSystemIndependentName((String)checkForIgnore2.getPath()))) == null) {
                vcsIgnoreChecker = (IgnoredCheckResult)NotIgnored.INSTANCE;
            }
        } else {
            VirtualFile virtualFile = project.getProjectFile();
            if (virtualFile == null) {
                Intrinsics.throwNpe();
            }
            VirtualFile projectFile = virtualFile;
            File checkForIgnore3 = VfsUtilCore.virtualToIoFile((VirtualFile)projectFile);
            VirtualFile virtualFile3 = VcsUtil.getVcsRootFor((Project)project, (VirtualFile)projectFile);
            if (virtualFile3 == null) {
                return (IgnoredCheckResult)NotIgnored.INSTANCE;
            }
            VirtualFile vcsRootForIgnore = virtualFile3;
            vcsIgnoreChecker = this.getCheckerForFile(project, projectFile);
            if (vcsIgnoreChecker == null || (vcsIgnoreChecker = vcsIgnoreChecker.isIgnored(vcsRootForIgnore, checkForIgnore3)) == null) {
                vcsIgnoreChecker = (IgnoredCheckResult)NotIgnored.INSTANCE;
            }
        }
        return vcsIgnoreChecker;
    }

    private final VcsIgnoreChecker getCheckerForFile(Project project, VirtualFile file) {
        return this.getCheckerForFile(project, VcsUtil.getFilePath((VirtualFile)file));
    }

    private final VcsIgnoreChecker getCheckerForFile(Project project, FilePath filePath) {
        Object v1;
        block2: {
            AbstractVcs abstractVcs = VcsUtil.getVcsFor((Project)project, (FilePath)filePath);
            if (abstractVcs == null) {
                return null;
            }
            AbstractVcs vcs = abstractVcs;
            Iterable iterable = VcsIgnoreChecker.EXTENSION_POINT_NAME.getExtensionList((AreaInstance)project);
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                VcsIgnoreChecker checker = (VcsIgnoreChecker)t;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)checker.getSupportedVcs(), (Object)vcs.getKeyInstanceMethod())) continue;
                v1 = t;
                break block2;
            }
            v1 = null;
        }
        return v1;
    }

    private final String configurationNameToFileName(String configurationName) {
        return (String)Scheme_implKt.getOLD_NAME_CONVERTER().invoke((Object)configurationName);
    }

    private final void checkProjectNotDefault(Project project) {
        if (project.isDefault()) {
            throw (Throwable)new UnsupportedOperationException("Default project not supported");
        }
    }

    public VcsIgnoreManagerImpl(@NotNull Project project) {
        this.project = project;
        this.checkProjectNotDefault(this.project);
        this.ignoreRefreshQueue = new MergingUpdateQueue("VcsIgnoreUpdate", 500, true, null, (Disposable)this.project, null, Alarm.ThreadToUse.POOLED_THREAD);
    }

    public static final /* synthetic */ IgnoredCheckResult access$getDirectoryVcsIgnoredStatus(VcsIgnoreManagerImpl $this, Project project, String dirPathString) {
        return $this.getDirectoryVcsIgnoredStatus(project, dirPathString);
    }

    public static final /* synthetic */ Project access$getProject$p(VcsIgnoreManagerImpl $this) {
        return $this.project;
    }

    public static final /* synthetic */ IgnoredCheckResult access$checkConfigurationVcsIgnored(VcsIgnoreManagerImpl $this, Project project, String configurationFileName) {
        return $this.checkConfigurationVcsIgnored(project, configurationFileName);
    }

    public static final /* synthetic */ void access$removeConfigurationFromVcsIgnore(VcsIgnoreManagerImpl $this, Project project, String configurationName) {
        $this.removeConfigurationFromVcsIgnore(project, configurationName);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/openapi/vcs/changes/VcsIgnoreManagerImpl$Companion;", "", "()V", "getInstanceImpl", "Lcom/intellij/openapi/vcs/changes/VcsIgnoreManagerImpl;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.vcs.impl"})
    public static final class Companion {
        @NotNull
        public final VcsIgnoreManagerImpl getInstanceImpl(@NotNull Project project) {
            VcsIgnoreManager vcsIgnoreManager = VcsIgnoreManager.getInstance((Project)project);
            if (vcsIgnoreManager == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.vcs.changes.VcsIgnoreManagerImpl");
            }
            return (VcsIgnoreManagerImpl)vcsIgnoreManager;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

