/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManagerImpl;
import com.intellij.openapi.vcs.changes.VcsModifiableDirtyScope;
import com.intellij.openapi.vcs.impl.projectlevelman.RecursiveFilePathSet;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsFileUtil;
import com.intellij.vcsUtil.VcsUtil;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsDirtyScopeImpl
extends VcsModifiableDirtyScope {
    private final Map<VirtualFile, THashSet<FilePath>> myDirtyFiles = new HashMap<VirtualFile, THashSet<FilePath>>();
    private final Map<VirtualFile, RecursiveFilePathSet> myDirtyDirectoriesRecursively = new HashMap<VirtualFile, RecursiveFilePathSet>();
    private final Set<VirtualFile> myAffectedContentRoots = new THashSet();
    @NotNull
    private final Project myProject;
    private final ProjectLevelVcsManager myVcsManager;
    @NotNull
    private final AbstractVcs myVcs;
    private final boolean myWasEverythingDirty;
    @NotNull
    private final TObjectHashingStrategy<FilePath> myHashingStrategy;
    private final boolean myCaseSensitive;

    public VcsDirtyScopeImpl(@NotNull AbstractVcs vcs) {
        this(vcs, false);
    }

    public VcsDirtyScopeImpl(@NotNull AbstractVcs vcs, boolean wasEverythingDirty) {
        this.myVcs = vcs;
        this.myProject = vcs.getProject();
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
        this.myWasEverythingDirty = wasEverythingDirty;
        this.myHashingStrategy = VcsDirtyScopeManagerImpl.getDirtyScopeHashingStrategy(this.myVcs);
        this.myCaseSensitive = this.myVcs.needsCaseSensitiveDirtyScope() || SystemInfo.isFileSystemCaseSensitive;
    }

    public Collection<VirtualFile> getAffectedContentRoots() {
        return this.myAffectedContentRoots;
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public AbstractVcs getVcs() {
        return this.myVcs;
    }

    public Set<FilePath> getDirtyFiles() {
        THashSet<FilePath> result2 = this.newFilePathsSet();
        for (THashSet<FilePath> paths : this.myDirtyFiles.values()) {
            result2.addAll(paths);
        }
        for (THashSet<FilePath> paths : this.myDirtyFiles.values()) {
            for (FilePath filePath : paths) {
                VirtualFile vFile = filePath.getVirtualFile();
                if (vFile == null || !vFile.isValid() || !vFile.isDirectory()) continue;
                for (VirtualFile child : vFile.getChildren()) {
                    result2.add((Object)VcsUtil.getFilePath((VirtualFile)child));
                }
            }
        }
        return result2;
    }

    public Set<FilePath> getDirtyFilesNoExpand() {
        THashSet<FilePath> paths = this.newFilePathsSet();
        for (THashSet<FilePath> filePaths : this.myDirtyFiles.values()) {
            paths.addAll(filePaths);
        }
        return paths;
    }

    public Set<FilePath> getRecursivelyDirtyDirectories() {
        THashSet<FilePath> result2 = this.newFilePathsSet();
        for (RecursiveFilePathSet dirsByRoot : this.myDirtyDirectoriesRecursively.values()) {
            result2.addAll(dirsByRoot.filePaths());
        }
        return result2;
    }

    public void addDirtyPathFast(@NotNull VirtualFile vcsRoot, @NotNull FilePath filePath, boolean recursively) {
        this.myAffectedContentRoots.add(vcsRoot);
        RecursiveFilePathSet dirsByRoot = this.myDirtyDirectoriesRecursively.get(vcsRoot);
        if (dirsByRoot != null && dirsByRoot.hasAncestor(filePath)) {
            return;
        }
        if (recursively) {
            if (dirsByRoot == null) {
                dirsByRoot = this.newRecursiveFilePathSet();
                this.myDirtyDirectoriesRecursively.put(vcsRoot, dirsByRoot);
            }
            dirsByRoot.add(filePath);
        } else {
            THashSet<FilePath> dirtyFiles = this.myDirtyFiles.get(vcsRoot);
            if (dirtyFiles == null) {
                dirtyFiles = this.newFilePathsSet();
                this.myDirtyFiles.put(vcsRoot, dirtyFiles);
            }
            dirtyFiles.add((Object)filePath);
        }
    }

    @NotNull
    public VcsDirtyScopeImpl pack() {
        VcsDirtyScopeImpl copy = new VcsDirtyScopeImpl(this.myVcs, this.myWasEverythingDirty);
        for (VirtualFile root : this.myAffectedContentRoots) {
            RecursiveFilePathSet rootDirs = this.myDirtyDirectoriesRecursively.get(root);
            Set rootFiles = ContainerUtil.notNullize((Set)((Set)this.myDirtyFiles.get(root)));
            RecursiveFilePathSet filteredDirs = this.removeAncestorsRecursive(rootDirs);
            THashSet<FilePath> filteredFiles = this.removeAncestorsNonRecursive(filteredDirs, rootFiles);
            copy.myAffectedContentRoots.add(root);
            copy.myDirtyDirectoriesRecursively.put(root, filteredDirs);
            copy.myDirtyFiles.put(root, filteredFiles);
        }
        return copy;
    }

    @NotNull
    private RecursiveFilePathSet removeAncestorsRecursive(@Nullable RecursiveFilePathSet dirs) {
        RecursiveFilePathSet result2 = this.newRecursiveFilePathSet();
        if (dirs == null) {
            return result2;
        }
        List paths = ContainerUtil.sorted(dirs.filePaths(), Comparator.comparingInt(it -> it.getPath().length()));
        for (FilePath path2 : paths) {
            if (result2.hasAncestor(path2)) continue;
            result2.add(path2);
        }
        return result2;
    }

    @NotNull
    private THashSet<FilePath> removeAncestorsNonRecursive(@NotNull RecursiveFilePathSet dirs, @NotNull Set<? extends FilePath> files) {
        THashSet<FilePath> result2 = this.newFilePathsSet();
        for (FilePath filePath : files) {
            if (dirs.hasAncestor(filePath) || !filePath.isDirectory() && files.contains(filePath.getParentPath())) continue;
            result2.add((Object)filePath);
        }
        return result2;
    }

    @NotNull
    private THashSet<FilePath> newFilePathsSet() {
        return new THashSet(this.myHashingStrategy);
    }

    @NotNull
    private RecursiveFilePathSet newRecursiveFilePathSet() {
        return new RecursiveFilePathSet(this.myCaseSensitive);
    }

    public void addDirtyDirRecursively(FilePath newcomer) {
        VirtualFile vcsRoot = this.myVcsManager.getVcsRootFor(newcomer);
        if (vcsRoot == null) {
            return;
        }
        this.myAffectedContentRoots.add(vcsRoot);
        for (Map.Entry<VirtualFile, THashSet<FilePath>> entry : this.myDirtyFiles.entrySet()) {
            THashSet<FilePath> files;
            VirtualFile groupRoot = entry.getKey();
            if (groupRoot == null || !VfsUtilCore.isAncestor((VirtualFile)vcsRoot, (VirtualFile)groupRoot, (boolean)false) || (files = entry.getValue()) == null) continue;
            Iterator it = files.iterator();
            while (it.hasNext()) {
                FilePath oldBoy2 = (FilePath)it.next();
                if (!VcsFileUtil.isAncestor(newcomer, oldBoy2, false)) continue;
                it.remove();
            }
        }
        RecursiveFilePathSet dirsByRoot = this.myDirtyDirectoriesRecursively.get(vcsRoot);
        if (dirsByRoot == null) {
            dirsByRoot = this.newRecursiveFilePathSet();
            this.myDirtyDirectoriesRecursively.put(vcsRoot, dirsByRoot);
        } else {
            if (dirsByRoot.hasAncestor(newcomer)) {
                return;
            }
            List toRemove = ContainerUtil.filter(dirsByRoot.filePaths(), oldBoy -> VcsFileUtil.isAncestor(newcomer, oldBoy, false));
            for (FilePath path2 : toRemove) {
                dirsByRoot.remove(path2);
            }
        }
        dirsByRoot.add(newcomer);
    }

    public void addDirtyFile(FilePath newcomer) {
        FilePath parent;
        VirtualFile vcsRoot = this.myVcsManager.getVcsRootFor(newcomer);
        if (vcsRoot == null) {
            return;
        }
        this.myAffectedContentRoots.add(vcsRoot);
        RecursiveFilePathSet dirsByRoot = this.myDirtyDirectoriesRecursively.get(vcsRoot);
        if (dirsByRoot != null && dirsByRoot.hasAncestor(newcomer)) {
            return;
        }
        THashSet<FilePath> dirtyFiles = this.myDirtyFiles.get(vcsRoot);
        if (dirtyFiles == null) {
            dirtyFiles = this.newFilePathsSet();
            this.myDirtyFiles.put(vcsRoot, dirtyFiles);
        } else if (newcomer.isDirectory()) {
            Iterator iterator = dirtyFiles.iterator();
            while (iterator.hasNext()) {
                FilePath oldBoy = (FilePath)iterator.next();
                if (oldBoy.isDirectory() || !this.myHashingStrategy.equals((Object)oldBoy.getParentPath(), (Object)newcomer)) continue;
                iterator.remove();
            }
        } else if (!dirtyFiles.isEmpty() && (parent = newcomer.getParentPath()) != null && dirtyFiles.contains((Object)parent)) {
            return;
        }
        dirtyFiles.add((Object)newcomer);
    }

    public void iterate(Processor<? super FilePath> iterator) {
        VirtualFile vFile;
        if (this.myProject.isDisposed()) {
            return;
        }
        for (VirtualFile root : this.myAffectedContentRoots) {
            RecursiveFilePathSet dirsByRoot = this.myDirtyDirectoriesRecursively.get(root);
            if (dirsByRoot == null) continue;
            for (FilePath dir : dirsByRoot.filePaths()) {
                vFile = dir.getVirtualFile();
                if (vFile == null || !vFile.isValid()) continue;
                this.myVcsManager.iterateVcsRoot(vFile, iterator);
            }
        }
        for (VirtualFile root : this.myAffectedContentRoots) {
            THashSet<FilePath> files = this.myDirtyFiles.get(root);
            if (files == null) continue;
            for (FilePath file : files) {
                iterator.process((Object)file);
                vFile = file.getVirtualFile();
                if (vFile == null || !vFile.isValid() || !vFile.isDirectory()) continue;
                for (VirtualFile child : vFile.getChildren()) {
                    iterator.process((Object)VcsUtil.getFilePath((VirtualFile)child));
                }
            }
        }
    }

    public void iterateExistingInsideScope(Processor<? super VirtualFile> processor) {
        VirtualFile vFile;
        if (this.myProject.isDisposed()) {
            return;
        }
        for (VirtualFile root : this.myAffectedContentRoots) {
            RecursiveFilePathSet dirsByRoot = this.myDirtyDirectoriesRecursively.get(root);
            if (dirsByRoot == null) continue;
            for (FilePath dir : dirsByRoot.filePaths()) {
                vFile = VcsDirtyScopeImpl.obtainVirtualFile(dir);
                if (vFile == null || !vFile.isValid()) continue;
                this.myVcsManager.iterateVfUnderVcsRoot(vFile, processor);
            }
        }
        for (VirtualFile root : this.myAffectedContentRoots) {
            THashSet<FilePath> files = this.myDirtyFiles.get(root);
            if (files == null) continue;
            for (FilePath file : files) {
                vFile = VcsDirtyScopeImpl.obtainVirtualFile(file);
                if (vFile == null || !vFile.isValid()) continue;
                processor.process((Object)vFile);
                if (!vFile.isDirectory()) continue;
                for (VirtualFile child : vFile.getChildren()) {
                    processor.process((Object)child);
                }
            }
        }
    }

    @Nullable
    private static VirtualFile obtainVirtualFile(FilePath file) {
        VirtualFile vFile = file.getVirtualFile();
        return vFile == null ? VfsUtil.findFileByIoFile((File)file.getIOFile(), (boolean)false) : vFile;
    }

    public boolean isEmpty() {
        return this.myDirtyDirectoriesRecursively.isEmpty() && this.myDirtyFiles.isEmpty();
    }

    public boolean belongsTo(FilePath path2) {
        if (this.myProject.isDisposed()) {
            return false;
        }
        VcsRoot rootObject = this.myVcsManager.getVcsRootObjectFor(path2);
        if (rootObject == null || rootObject.getVcs() != this.myVcs) {
            return false;
        }
        VirtualFile vcsRoot = rootObject.getPath();
        boolean pathIsRoot = vcsRoot.equals(path2.getVirtualFile());
        for (VirtualFile contentRoot : this.myDirtyDirectoriesRecursively.keySet()) {
            RecursiveFilePathSet dirsByRoot;
            boolean strict;
            if (!VfsUtilCore.isAncestor((VirtualFile)contentRoot, (VirtualFile)vcsRoot, (boolean)(strict = pathIsRoot && !this.myVcs.areDirectoriesVersionedItems())) || !(dirsByRoot = this.myDirtyDirectoriesRecursively.get(contentRoot)).hasAncestor(path2)) continue;
            return true;
        }
        if (!this.myDirtyFiles.isEmpty()) {
            if (this.isInDirtyFiles(path2, vcsRoot)) {
                return true;
            }
            FilePath parent = path2.getParentPath();
            if (parent != null && this.isInDirtyFiles(parent, (VirtualFile)(!pathIsRoot ? vcsRoot : null))) {
                return true;
            }
        }
        return false;
    }

    private boolean isInDirtyFiles(@NotNull FilePath path2, @Nullable VirtualFile vcsRoot) {
        THashSet<FilePath> files;
        if (vcsRoot == null) {
            VcsRoot rootObject = this.myVcsManager.getVcsRootObjectFor(path2);
            if (rootObject == null || !this.myVcs.equals((Object)rootObject.getVcs())) {
                return false;
            }
            vcsRoot = rootObject.getPath();
        }
        return (files = this.myDirtyFiles.get(vcsRoot)) != null && files.contains((Object)path2);
    }

    @NonNls
    public String toString() {
        StringBuilder result2 = new StringBuilder("VcsDirtyScope[");
        if (!this.myDirtyFiles.isEmpty()) {
            result2.append(" files: ");
            for (THashSet<FilePath> paths : this.myDirtyFiles.values()) {
                for (FilePath file : paths) {
                    result2.append(file).append(" ");
                }
            }
        }
        if (!this.myDirtyDirectoriesRecursively.isEmpty()) {
            result2.append("\ndirs: ");
            for (RecursiveFilePathSet dirsByRoot : this.myDirtyDirectoriesRecursively.values()) {
                for (FilePath file : dirsByRoot.filePaths()) {
                    result2.append(file).append(" ");
                }
            }
        }
        result2.append("\naffected roots: ");
        for (VirtualFile contentRoot : this.myAffectedContentRoots) {
            result2.append(contentRoot.getPath()).append(" ");
        }
        result2.append("]");
        return result2.toString();
    }

    public boolean wasEveryThingDirty() {
        return this.myWasEverythingDirty;
    }
}

