/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.impl.DirectoryIndexExcludePolicy;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsApplicationSettings;
import com.intellij.openapi.vcs.changes.IgnoredBeanFactory;
import com.intellij.openapi.vcs.changes.IgnoredFileBean;
import com.intellij.openapi.vcs.changes.IgnoredFileDescriptor;
import com.intellij.openapi.vcs.changes.IgnoredFileProvider;
import com.intellij.openapi.vcs.changes.ui.ChangesComparator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/openapi/vcs/changes/ProjectExcludesIgnoredFileProvider;", "Lcom/intellij/openapi/vcs/changes/IgnoredFileProvider;", "()V", "getIgnoredFiles", "", "Lcom/intellij/openapi/vcs/changes/IgnoredFileDescriptor;", "project", "Lcom/intellij/openapi/project/Project;", "getIgnoredGroupDescription", "", "getProjectExcludePaths", "isIgnoredFile", "", "filePath", "Lcom/intellij/openapi/vcs/FilePath;", "intellij.platform.vcs.impl"})
public final class ProjectExcludesIgnoredFileProvider
implements IgnoredFileProvider {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isIgnoredFile(@NotNull Project project, @NotNull FilePath filePath) {
        if (!VcsApplicationSettings.getInstance().MARK_EXCLUDED_AS_IGNORED) return false;
        if (Registry.is((String)"ide.hide.excluded.files")) return false;
        VirtualFile virtualFile = filePath.getVirtualFile();
        if (virtualFile == null) return false;
        VirtualFile virtualFile2 = virtualFile;
        boolean bl = false;
        boolean bl2 = false;
        VirtualFile file = virtualFile2;
        boolean bl3 = false;
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)project);
        if (!projectFileIndex.isExcluded(file)) return false;
        if (projectFileIndex.isUnderIgnored(file)) return false;
        return true;
    }

    @NotNull
    public Set<IgnoredFileDescriptor> getIgnoredFiles(@NotNull Project project) {
        return this.getProjectExcludePaths(project);
    }

    @NotNull
    public String getIgnoredGroupDescription() {
        return "Project exclude paths";
    }

    /*
     * WARNING - void declaration
     */
    private final Set<IgnoredFileDescriptor> getProjectExcludePaths(Project project) {
        if (!VcsApplicationSettings.getInstance().MARK_EXCLUDED_AS_IGNORED) {
            return SetsKt.emptySet();
        }
        TreeSet excludes = SetsKt.sortedSetOf(ChangesComparator.getVirtualFileComparator(false), (Object[])new VirtualFile[0]);
        ProjectFileIndex fileIndex = ProjectFileIndex.SERVICE.getInstance((Project)project);
        for (DirectoryIndexExcludePolicy directoryIndexExcludePolicy : (DirectoryIndexExcludePolicy[])DirectoryIndexExcludePolicy.EP_NAME.getExtensions((AreaInstance)project)) {
            for (String string : directoryIndexExcludePolicy.getExcludeUrlsForProject()) {
                VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(string);
                if (file == null) continue;
                excludes.add(file);
            }
        }
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            if (module.isDisposed()) continue;
            for (String string : ModuleRootManager.getInstance((Module)module).getExcludeRoots()) {
                boolean $i$f$runReadAction = false;
                if (((Boolean)ApplicationManager.getApplication().runReadAction(new Computable<T>(fileIndex, (VirtualFile)string){
                    final /* synthetic */ ProjectFileIndex $fileIndex$inlined;
                    final /* synthetic */ VirtualFile $excludeRoot$inlined;
                    {
                        this.$fileIndex$inlined = projectFileIndex;
                        this.$excludeRoot$inlined = virtualFile;
                    }

                    public final T compute() {
                        boolean bl = false;
                        return (T)Boolean.valueOf(!this.$fileIndex$inlined.isExcluded(this.$excludeRoot$inlined));
                    }
                })).booleanValue()) continue;
                excludes.add(string);
            }
        }
        Iterable iterable = excludes;
        boolean $i$f$map = false;
        Iterable iterable2 = iterable;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean bl = false;
        for (Object item$iv$iv : iterable2) {
            void file;
            VirtualFile virtualFile = (VirtualFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            IgnoredFileBean ignoredFileBean = IgnoredBeanFactory.ignoreFile((VirtualFile)file, (Project)project);
            collection.add(ignoredFileBean);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }
}

