/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.diff.impl.DiffRequestProcessor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.changes.DiffPreview;
import com.intellij.openapi.vcs.changes.DiffPreviewUpdateProcessor;
import com.intellij.openapi.vcs.changes.EditorTabDiffPreviewProvider;
import com.intellij.openapi.vcs.changes.EditorTabPreview;
import com.intellij.openapi.vcs.changes.EditorTabPreviewEscapeAction;
import com.intellij.openapi.vcs.changes.PreviewDiffVirtualFile;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.util.Consumer;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.Processor;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JTree;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\b&\u0018\u0000 22\u00020\u0001:\u00012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0018\u001a\u00020\u0019J\n\u0010\u001a\u001a\u0004\u0018\u00010\u001bH$J\b\u0010\u001c\u001a\u00020\u001dH$J\u0010\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 H\u0002J\u000e\u0010\"\u001a\u00020\u00192\u0006\u0010#\u001a\u00020$J\u001e\u0010%\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00190'H\u0002J\b\u0010(\u001a\u00020\u001dH\u0002J\u000e\u0010)\u001a\u00020\u001d2\u0006\u0010*\u001a\u00020\u001dJ\u000e\u0010+\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010,\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 J\u0010\u0010-\u001a\u00020\u00192\u0006\u0010.\u001a\u00020\u001dH\u0016J\b\u0010/\u001a\u00020\u001dH\u0014J\u0010\u00100\u001a\u00020\u00192\u0006\u00101\u001a\u00020\u001dH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0012\u001a\u0004\u0018\u00010\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/intellij/openapi/vcs/changes/EditorTabPreview;", "Lcom/intellij/openapi/vcs/changes/DiffPreview;", "diffProcessor", "Lcom/intellij/diff/impl/DiffRequestProcessor;", "(Lcom/intellij/diff/impl/DiffRequestProcessor;)V", "escapeHandler", "Ljava/lang/Runnable;", "getEscapeHandler", "()Ljava/lang/Runnable;", "setEscapeHandler", "(Ljava/lang/Runnable;)V", "previewFile", "Lcom/intellij/openapi/vcs/changes/PreviewDiffVirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "Lorg/jetbrains/annotations/Nullable;", "getProject", "()Lcom/intellij/openapi/project/Project;", "updatePreviewProcessor", "Lcom/intellij/openapi/vcs/changes/DiffPreviewUpdateProcessor;", "getUpdatePreviewProcessor", "()Lcom/intellij/openapi/vcs/changes/DiffPreviewUpdateProcessor;", "updatePreviewQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "closePreview", "", "getCurrentName", "", "hasContent", "", "installDoubleClickHandler", "tree", "Lcom/intellij/openapi/vcs/changes/ui/ChangesTree;", "installEnterKeyHandler", "installNextDiffActionOn", "component", "Ljavax/swing/JComponent;", "installSelectionChangedHandler", "handler", "Lkotlin/Function0;", "isPreviewOpen", "openPreview", "focusEditor", "openWithDoubleClick", "openWithSingleClick", "setPreviewVisible", "isPreviewVisible", "skipPreviewUpdate", "updatePreview", "fromModelRefresh", "Companion", "intellij.platform.vcs.impl"})
public abstract class EditorTabPreview
implements DiffPreview {
    private final PreviewDiffVirtualFile previewFile;
    private final MergingUpdateQueue updatePreviewQueue;
    @Nullable
    private Runnable escapeHandler;
    private final DiffRequestProcessor diffProcessor;
    public static final Companion Companion = new Companion(null);

    private final Project getProject() {
        Project project = this.diffProcessor.getProject();
        if (project == null) {
            Intrinsics.throwNpe();
        }
        return project;
    }

    private final DiffPreviewUpdateProcessor getUpdatePreviewProcessor() {
        DiffRequestProcessor diffRequestProcessor = this.diffProcessor;
        if (!(diffRequestProcessor instanceof DiffPreviewUpdateProcessor)) {
            diffRequestProcessor = null;
        }
        return (DiffPreviewUpdateProcessor)diffRequestProcessor;
    }

    @Nullable
    public final Runnable getEscapeHandler() {
        return this.escapeHandler;
    }

    public final void setEscapeHandler(@Nullable Runnable runnable) {
        this.escapeHandler = runnable;
    }

    public final void openWithDoubleClick(@NotNull ChangesTree tree) {
        this.installDoubleClickHandler(tree);
        this.installEnterKeyHandler(tree);
        this.installSelectionChangedHandler(tree, (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ EditorTabPreview this$0;

            public final void invoke() {
                this.this$0.updatePreview(false);
            }
            {
                this.this$0 = editorTabPreview;
                super(0);
            }
        }));
    }

    public final void openWithSingleClick(@NotNull ChangesTree tree) {
        DumbService.getInstance((Project)this.getProject()).smartInvokeLater(new Runnable(this, tree){
            final /* synthetic */ EditorTabPreview this$0;
            final /* synthetic */ ChangesTree $tree;

            public final void run() {
                if (Disposer.isDisposed((Disposable)((Disposable)EditorTabPreview.access$getUpdatePreviewQueue$p(this.this$0)))) {
                    return;
                }
                EditorTabPreview.access$installSelectionChangedHandler(this.this$0, this.$tree, (Function0)new Function0<Unit>(this){
                    final /* synthetic */ openWithSingleClick.1 this$0;

                    public final void invoke() {
                        if (!this.this$0.this$0.openPreview(false)) {
                            this.this$0.this$0.closePreview();
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                });
            }
            {
                this.this$0 = editorTabPreview;
                this.$tree = changesTree;
            }
        });
    }

    public final void installNextDiffActionOn(@NotNull JComponent component) {
        DumbAwareAction dumbAwareAction = DumbAwareAction.create((Consumer)((Consumer)new Consumer<AnActionEvent>(this){
            final /* synthetic */ EditorTabPreview this$0;

            public final void consume(AnActionEvent it) {
                this.this$0.openPreview(true);
            }
            {
                this.this$0 = editorTabPreview;
            }
        }));
        boolean bl = false;
        boolean bl2 = false;
        DumbAwareAction $this$apply = dumbAwareAction;
        boolean bl3 = false;
        $this$apply.copyShortcutFrom(ActionManager.getInstance().getAction("NextDiff"));
        $this$apply.registerCustomShortcutSet(component, (Disposable)this.diffProcessor);
    }

    private final void installDoubleClickHandler(ChangesTree tree) {
        Processor<MouseEvent> oldDoubleClickHandler = tree.getDoubleClickHandler();
        Processor newDoubleClickHandler2 = (Processor)new Processor<MouseEvent>(this, tree, oldDoubleClickHandler){
            final /* synthetic */ EditorTabPreview this$0;
            final /* synthetic */ ChangesTree $tree;
            final /* synthetic */ Processor $oldDoubleClickHandler;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean process(MouseEvent e) {
                if (EditSourceOnDoubleClickHandler.isToggleEvent((JTree)((JTree)((Object)this.$tree)), (MouseEvent)e)) {
                    return false;
                }
                if (this.this$0.openPreview(true)) return true;
                Processor processor = this.$oldDoubleClickHandler;
                if (processor == null) return false;
                if (!processor.process((Object)e)) return false;
                return true;
            }
            {
                this.this$0 = editorTabPreview;
                this.$tree = changesTree;
                this.$oldDoubleClickHandler = processor;
            }
        };
        tree.setDoubleClickHandler((Processor<MouseEvent>)newDoubleClickHandler2);
        Disposer.register((Disposable)((Disposable)this.diffProcessor), (Disposable)new Disposable(tree, oldDoubleClickHandler){
            final /* synthetic */ ChangesTree $tree;
            final /* synthetic */ Processor $oldDoubleClickHandler;

            public final void dispose() {
                this.$tree.setDoubleClickHandler((Processor<MouseEvent>)this.$oldDoubleClickHandler);
            }
            {
                this.$tree = changesTree;
                this.$oldDoubleClickHandler = processor;
            }
        });
    }

    private final void installEnterKeyHandler(ChangesTree tree) {
        Processor<KeyEvent> oldEnterKeyHandler = tree.getEnterKeyHandler();
        Processor newEnterKeyHandler2 = (Processor)new Processor<KeyEvent>(this, oldEnterKeyHandler){
            final /* synthetic */ EditorTabPreview this$0;
            final /* synthetic */ Processor $oldEnterKeyHandler;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean process(KeyEvent e) {
                if (this.this$0.openPreview(false)) return true;
                Processor processor = this.$oldEnterKeyHandler;
                if (processor == null) return false;
                if (!processor.process((Object)e)) return false;
                return true;
            }
            {
                this.this$0 = editorTabPreview;
                this.$oldEnterKeyHandler = processor;
            }
        };
        tree.setEnterKeyHandler((Processor<KeyEvent>)newEnterKeyHandler2);
        Disposer.register((Disposable)((Disposable)this.diffProcessor), (Disposable)new Disposable(tree, oldEnterKeyHandler){
            final /* synthetic */ ChangesTree $tree;
            final /* synthetic */ Processor $oldEnterKeyHandler;

            public final void dispose() {
                this.$tree.setEnterKeyHandler((Processor<KeyEvent>)this.$oldEnterKeyHandler);
            }
            {
                this.$tree = changesTree;
                this.$oldEnterKeyHandler = processor;
            }
        });
    }

    private final void installSelectionChangedHandler(ChangesTree tree, Function0<Unit> handler) {
        tree.addSelectionListener(new Runnable(this, handler){
            final /* synthetic */ EditorTabPreview this$0;
            final /* synthetic */ Function0 $handler;

            public final void run() {
                EditorTabPreview.access$getUpdatePreviewQueue$p(this.this$0).queue(Update.create((Object)this.this$0, (Runnable)new Runnable(this){
                    final /* synthetic */ installSelectionChangedHandler.1 this$0;

                    public final void run() {
                        if (this.this$0.this$0.skipPreviewUpdate()) {
                            return;
                        }
                        this.this$0.$handler.invoke();
                    }
                    {
                        this.this$0 = var1_1;
                    }
                }));
            }
            {
                this.this$0 = editorTabPreview;
                this.$handler = function0;
            }
        }, (Disposable)this.updatePreviewQueue);
    }

    @Nullable
    protected abstract String getCurrentName();

    protected abstract boolean hasContent();

    protected boolean skipPreviewUpdate() {
        return ToolWindowManager.Companion.getInstance(this.getProject()).isEditorComponentActive();
    }

    @Override
    public void updatePreview(boolean fromModelRefresh) {
        block2: {
            block1: {
                if (!this.isPreviewOpen()) break block1;
                DiffPreviewUpdateProcessor diffPreviewUpdateProcessor = this.getUpdatePreviewProcessor();
                if (diffPreviewUpdateProcessor != null) {
                    diffPreviewUpdateProcessor.refresh(false);
                }
                FileEditorManagerEx.getInstanceEx((Project)this.getProject()).updateFilePresentation((VirtualFile)this.previewFile);
                break block2;
            }
            DiffPreviewUpdateProcessor diffPreviewUpdateProcessor = this.getUpdatePreviewProcessor();
            if (diffPreviewUpdateProcessor == null) break block2;
            diffPreviewUpdateProcessor.clear();
        }
    }

    @Override
    public void setPreviewVisible(boolean isPreviewVisible) {
        if (isPreviewVisible) {
            this.openPreview(false);
        } else {
            this.closePreview();
        }
    }

    private final boolean isPreviewOpen() {
        return FileEditorManager.getInstance((Project)this.getProject()).isFileOpen((VirtualFile)this.previewFile);
    }

    public final void closePreview() {
        block0: {
            FileEditorManager.getInstance((Project)this.getProject()).closeFile((VirtualFile)this.previewFile);
            DiffPreviewUpdateProcessor diffPreviewUpdateProcessor = this.getUpdatePreviewProcessor();
            if (diffPreviewUpdateProcessor == null) break block0;
            diffPreviewUpdateProcessor.clear();
        }
    }

    public final boolean openPreview(boolean focusEditor) {
        DiffPreviewUpdateProcessor diffPreviewUpdateProcessor = this.getUpdatePreviewProcessor();
        if (diffPreviewUpdateProcessor != null) {
            diffPreviewUpdateProcessor.refresh(false);
        }
        if (!this.hasContent()) {
            return false;
        }
        Companion.openPreview(this.getProject(), this.previewFile, focusEditor, this.escapeHandler);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public EditorTabPreview(@NotNull DiffRequestProcessor diffProcessor) {
        void $this$apply;
        this.diffProcessor = diffProcessor;
        this.previewFile = new PreviewDiffVirtualFile(new EditorTabDiffPreviewProvider(this.diffProcessor, (Function0<String>)((Function0)new Function0<String>(this){
            final /* synthetic */ EditorTabPreview this$0;

            @Nullable
            public final String invoke() {
                return this.this$0.getCurrentName();
            }
            {
                this.this$0 = editorTabPreview;
                super(0);
            }
        })));
        MergingUpdateQueue mergingUpdateQueue = new MergingUpdateQueue("updatePreviewQueue", 100, true, null, (Disposable)this.diffProcessor);
        boolean bl = false;
        boolean bl2 = false;
        MergingUpdateQueue mergingUpdateQueue2 = mergingUpdateQueue;
        EditorTabPreview editorTabPreview = this;
        boolean bl3 = false;
        $this$apply.setRestartTimerOnAdd(true);
        Unit unit = Unit.INSTANCE;
        editorTabPreview.updatePreviewQueue = mergingUpdateQueue;
    }

    public static final /* synthetic */ MergingUpdateQueue access$getUpdatePreviewQueue$p(EditorTabPreview $this) {
        return $this.updatePreviewQueue;
    }

    public static final /* synthetic */ void access$installSelectionChangedHandler(EditorTabPreview $this, ChangesTree tree, Function0 handler) {
        $this.installSelectionChangedHandler(tree, (Function0<Unit>)handler);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a8\u0006\r"}, d2={"Lcom/intellij/openapi/vcs/changes/EditorTabPreview$Companion;", "", "()V", "openPreview", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vcs/changes/PreviewDiffVirtualFile;", "focusEditor", "", "escapeHandler", "Ljava/lang/Runnable;", "intellij.platform.vcs.impl"})
    public static final class Companion {
        public final void openPreview(@NotNull Project project, @NotNull PreviewDiffVirtualFile file, boolean focusEditor, @Nullable Runnable escapeHandler2) {
            boolean wasAlreadyOpen = FileEditorManager.getInstance((Project)project).isFileOpen((VirtualFile)file);
            FileEditor fileEditor = (FileEditor)ArraysKt.singleOrNull((Object[])FileEditorManager.getInstance((Project)project).openFile((VirtualFile)file, focusEditor, true));
            if (fileEditor == null) {
                return;
            }
            FileEditor editor = fileEditor;
            if (wasAlreadyOpen || escapeHandler2 == null) {
                return;
            }
            new EditorTabPreviewEscapeAction(escapeHandler2).registerCustomShortcutSet(CommonShortcuts.ESCAPE, editor.getComponent(), (Disposable)editor);
        }

        public static /* synthetic */ void openPreview$default(Companion companion, Project project, PreviewDiffVirtualFile previewDiffVirtualFile, boolean bl, Runnable runnable, int n, Object object) {
            if ((n & 8) != 0) {
                runnable = null;
            }
            companion.openPreview(project, previewDiffVirtualFile, bl, runnable);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

