/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.impl.CacheDiffRequestProcessor;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.ErrorDiffRequest;
import com.intellij.diff.requests.LoadingDiffRequest;
import com.intellij.diff.tools.util.PrevNextDifferenceIterable;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListChange;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.DiffPreviewUpdateProcessor;
import com.intellij.openapi.vcs.changes.FakeRevision;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeDiffRequestProducer;
import com.intellij.openapi.vcs.changes.actions.diff.UnversionedDiffRequestProducer;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ChangeViewDiffRequestProcessor
extends CacheDiffRequestProcessor.Simple
implements DiffPreviewUpdateProcessor {
    private static final int MANY_CHANGES_THRESHOLD = 10000;
    @Nullable
    private Wrapper myCurrentChange;

    public ChangeViewDiffRequestProcessor(@NotNull Project project, @NotNull String place) {
        super(project, place);
    }

    @NotNull
    protected abstract Stream<Wrapper> getSelectedChanges();

    @NotNull
    protected abstract Stream<Wrapper> getAllChanges();

    protected abstract void selectChange(@NotNull Wrapper var1);

    protected DiffRequestProducer getCurrentRequestProvider() {
        return this.myCurrentChange != null ? this.myCurrentChange.createProducer(this.getProject()) : null;
    }

    @Nullable
    protected DiffRequest loadRequestFast(@NotNull DiffRequestProducer provider) {
        DiffRequest request = super.loadRequestFast((Object)provider);
        return ChangeViewDiffRequestProcessor.isRequestValid(request) ? request : null;
    }

    private static boolean isRequestValid(@Nullable DiffRequest request) {
        if (request instanceof ContentDiffRequest) {
            for (DiffContent content2 : ((ContentDiffRequest)request).getContents()) {
                if (!(content2 instanceof FileContent) || ((FileContent)content2).getFile().isValid()) continue;
                return false;
            }
        }
        return true;
    }

    public void updatePreview(boolean state, boolean fromModelRefresh) {
        if (state) {
            this.refresh(fromModelRefresh);
        } else {
            this.clear();
        }
    }

    @NotNull
    public Project getProject() {
        return super.getProject();
    }

    public boolean isWindowFocused() {
        return DiffUtil.isFocusedComponent((Project)this.getProject(), (Component)this.getComponent());
    }

    @Override
    public void clear() {
        if (this.myCurrentChange != null) {
            this.myCurrentChange = null;
            this.updateRequest();
        }
        this.dropCaches();
    }

    @Override
    public void refresh(boolean fromModelRefresh) {
        Wrapper selectedChange;
        if (this.isDisposed()) {
            return;
        }
        List selectedChanges = this.getSelectedChanges().collect(Collectors.toList());
        Wrapper wrapper = selectedChange = this.myCurrentChange != null ? (Wrapper)ContainerUtil.find(selectedChanges, (Object)this.myCurrentChange) : null;
        if (fromModelRefresh && selectedChange == null && this.myCurrentChange != null && this.getContext().isWindowFocused() && this.getContext().isFocusedInWindow()) {
            if (selectedChanges.size() == 1 && this.getAllChanges().anyMatch(it -> this.myCurrentChange.equals(it))) {
                this.selectChange(this.myCurrentChange);
            }
            return;
        }
        if (selectedChanges.isEmpty()) {
            this.setCurrentChange(null);
            return;
        }
        if (selectedChange == null) {
            this.setCurrentChange((Wrapper)selectedChanges.get(0));
            return;
        }
        this.setCurrentChange(selectedChange);
    }

    @Nullable
    public String getCurrentChangeName() {
        if (this.myCurrentChange == null) {
            return null;
        }
        return this.myCurrentChange.getPresentableName();
    }

    public void setCurrentChange(@Nullable Wrapper change) {
        this.myCurrentChange = change;
        this.updateRequest();
    }

    protected boolean hasNextChange(boolean fromUpdate) {
        PrevNextDifferenceIterable strategy = this.getSelectionStrategy(fromUpdate);
        return strategy != null && strategy.canGoNext();
    }

    protected boolean hasPrevChange(boolean fromUpdate) {
        PrevNextDifferenceIterable strategy = this.getSelectionStrategy(fromUpdate);
        return strategy != null && strategy.canGoPrev();
    }

    protected void goToNextChange(boolean fromDifferences) {
        Objects.requireNonNull(this.getSelectionStrategy(false)).goNext();
        this.updateRequest(false, (DiffUserDataKeysEx.ScrollToPolicy)(fromDifferences ? DiffUserDataKeysEx.ScrollToPolicy.FIRST_CHANGE : null));
    }

    protected void goToPrevChange(boolean fromDifferences) {
        Objects.requireNonNull(this.getSelectionStrategy(false)).goPrev();
        this.updateRequest(false, (DiffUserDataKeysEx.ScrollToPolicy)(fromDifferences ? DiffUserDataKeysEx.ScrollToPolicy.LAST_CHANGE : null));
    }

    protected boolean isNavigationEnabled() {
        return true;
    }

    @Nullable
    private PrevNextDifferenceIterable getSelectionStrategy(boolean fromUpdate) {
        if (this.myCurrentChange == null) {
            return null;
        }
        List<Wrapper> selectedChanges = ChangeViewDiffRequestProcessor.toListIfNotMany(this.getSelectedChanges(), fromUpdate);
        if (selectedChanges == null) {
            return DumbPrevNextDifferenceIterable.INSTANCE;
        }
        if (selectedChanges.isEmpty()) {
            return null;
        }
        if (selectedChanges.size() == 1) {
            List<Wrapper> allChanges = ChangeViewDiffRequestProcessor.toListIfNotMany(this.getAllChanges(), fromUpdate);
            if (allChanges == null) {
                return DumbPrevNextDifferenceIterable.INSTANCE;
            }
            return new ChangesNavigatable(allChanges, selectedChanges.get(0), true);
        }
        return new ChangesNavigatable(selectedChanges, selectedChanges.get(0), false);
    }

    @Nullable
    private static <T> List<T> toListIfNotMany(@NotNull Stream<T> stream, boolean fromUpdate) {
        if (!fromUpdate) {
            return stream.collect(Collectors.toList());
        }
        List result2 = stream.limit(10001L).collect(Collectors.toList());
        if (result2.size() > 10000) {
            return null;
        }
        return result2;
    }

    private static class ErrorChangeRequestProducer
    implements DiffRequestProducer {
        @NotNull
        private final Change myChange;
        @NotNull
        private final DiffRequest myRequest;

        ErrorChangeRequestProducer(@NotNull Change change, @NotNull DiffRequest request) {
            this.myChange = change;
            this.myRequest = request;
        }

        @NotNull
        public String getName() {
            return ChangeDiffRequestProducer.getRequestTitle(this.myChange);
        }

        @NotNull
        public DiffRequest process(@NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws ProcessCanceledException {
            return this.myRequest;
        }
    }

    protected static class UnversionedFileWrapper
    extends Wrapper {
        @NotNull
        protected final FilePath path;

        public UnversionedFileWrapper(@NotNull FilePath path2) {
            this.path = path2;
        }

        @Override
        @NotNull
        public Object getUserObject() {
            return this.path;
        }

        @Override
        @Nullable
        public String getPresentableName() {
            return this.path.getName();
        }

        @Override
        @Nullable
        public DiffRequestProducer createProducer(@Nullable Project project) {
            return UnversionedDiffRequestProducer.create(project, this.path);
        }
    }

    protected static class ChangeWrapper
    extends Wrapper {
        @NotNull
        protected final Change change;

        public ChangeWrapper(@NotNull Change change) {
            this.change = change;
        }

        @Override
        @NotNull
        public Object getUserObject() {
            return this.change;
        }

        @Override
        @Nullable
        public String getPresentableName() {
            return ChangesUtil.getFilePath((Change)this.change).getName();
        }

        @Override
        @Nullable
        public DiffRequestProducer createProducer(@Nullable Project project) {
            if (this.change.getBeforeRevision() instanceof FakeRevision || this.change.getAfterRevision() instanceof FakeRevision) {
                LoadingDiffRequest request = new LoadingDiffRequest(ChangeDiffRequestProducer.getRequestTitle(this.change));
                return new ErrorChangeRequestProducer(this.change, (DiffRequest)request);
            }
            ChangeDiffRequestProducer producer = ChangeDiffRequestProducer.create(project, this.change);
            if (producer == null) {
                ErrorDiffRequest request = new ErrorDiffRequest(DiffBundle.message((String)"error.cant.show.diff.message", (Object[])new Object[0]));
                return new ErrorChangeRequestProducer(this.change, (DiffRequest)request);
            }
            return producer;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (this.getClass() != o.getClass()) {
                return false;
            }
            ChangeWrapper wrapper = (ChangeWrapper)o;
            return ChangeListChange.HASHING_STRATEGY.equals((Object)wrapper.change, (Object)this.change);
        }

        @Override
        public int hashCode() {
            return this.change.hashCode();
        }
    }

    protected static abstract class Wrapper {
        protected Wrapper() {
        }

        @NotNull
        public abstract Object getUserObject();

        @Nullable
        public abstract String getPresentableName();

        @Nullable
        public abstract DiffRequestProducer createProducer(@Nullable Project var1);

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (this.getClass() != o.getClass()) {
                return false;
            }
            Wrapper wrapper = (Wrapper)o;
            return Comparing.equal((Object)this.getUserObject(), (Object)wrapper.getUserObject());
        }

        public int hashCode() {
            return this.getUserObject().hashCode();
        }
    }

    private static class DumbPrevNextDifferenceIterable
    implements PrevNextDifferenceIterable {
        public static final DumbPrevNextDifferenceIterable INSTANCE = new DumbPrevNextDifferenceIterable();

        private DumbPrevNextDifferenceIterable() {
        }

        public boolean canGoPrev() {
            return true;
        }

        public boolean canGoNext() {
            return true;
        }

        public void goPrev() {
            throw new UnsupportedOperationException();
        }

        public void goNext() {
            throw new UnsupportedOperationException();
        }
    }

    private class ChangesNavigatable
    implements PrevNextDifferenceIterable {
        @NotNull
        private final List<? extends Wrapper> myChanges;
        @NotNull
        private final Wrapper myFallback;
        private final boolean myUpdateSelection;

        ChangesNavigatable(@NotNull List<? extends Wrapper> allChanges, Wrapper fallback, boolean updateSelection) {
            this.myChanges = allChanges;
            this.myFallback = fallback;
            this.myUpdateSelection = updateSelection;
        }

        public boolean canGoNext() {
            if (ChangeViewDiffRequestProcessor.this.myCurrentChange == null) {
                return false;
            }
            int index = this.myChanges.indexOf(ChangeViewDiffRequestProcessor.this.myCurrentChange);
            return index == -1 || index < this.myChanges.size() - 1;
        }

        public boolean canGoPrev() {
            if (ChangeViewDiffRequestProcessor.this.myCurrentChange == null) {
                return false;
            }
            int index = this.myChanges.indexOf(ChangeViewDiffRequestProcessor.this.myCurrentChange);
            return index == -1 || index > 0;
        }

        public void goNext() {
            int index = this.myChanges.indexOf(ChangeViewDiffRequestProcessor.this.myCurrentChange);
            if (index != -1) {
                this.select(this.myChanges.get(index + 1));
            } else {
                this.select(this.myFallback);
            }
        }

        public void goPrev() {
            int index = this.myChanges.indexOf(ChangeViewDiffRequestProcessor.this.myCurrentChange);
            if (index != -1) {
                this.select(this.myChanges.get(index - 1));
            } else {
                this.select(this.myFallback);
            }
        }

        private void select(@NotNull Wrapper change) {
            ChangeViewDiffRequestProcessor.this.myCurrentChange = change;
            if (this.myUpdateSelection) {
                ChangeViewDiffRequestProcessor.this.selectChange(change);
            }
        }
    }
}

