/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.BaseRevision;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.HierarchicalFilePathComparator;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.BeforeAfter;
import com.intellij.util.ThreeState;
import com.intellij.vcsUtil.VcsUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeListsIndexes {
    private static final Logger LOG = Logger.getInstance(ChangeListsIndexes.class);
    private final Map<FilePath, Data> myMap;
    private final TreeSet<FilePath> myAffectedPaths;
    private final Set<Change> myChanges;

    public ChangeListsIndexes() {
        this.myMap = new HashMap<FilePath, Data>();
        this.myAffectedPaths = new TreeSet<FilePath>(HierarchicalFilePathComparator.SYSTEM_CASE_SENSITIVE);
        this.myChanges = new HashSet<Change>();
    }

    public ChangeListsIndexes(@NotNull ChangeListsIndexes idx) {
        this.myMap = new HashMap<FilePath, Data>(idx.myMap);
        this.myAffectedPaths = new TreeSet<FilePath>((SortedSet<FilePath>)idx.myAffectedPaths);
        this.myChanges = new HashSet<Change>(idx.myChanges);
    }

    public void copyFrom(@NotNull ChangeListsIndexes idx) {
        this.myMap.clear();
        this.myAffectedPaths.clear();
        this.myChanges.clear();
        this.myMap.putAll(idx.myMap);
        this.myAffectedPaths.addAll(idx.myAffectedPaths);
        this.myChanges.addAll(idx.myChanges);
    }

    private void add(@NotNull FilePath file, @NotNull FileStatus status, @Nullable AbstractVcs key, @NotNull VcsRevisionNumber number) {
        this.myMap.put(file, new Data(status, key, number));
        this.myAffectedPaths.add(file);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Set status " + status + " for " + file);
        }
    }

    private void remove(FilePath file) {
        this.myMap.remove(file);
        this.myAffectedPaths.remove(file);
    }

    @Nullable
    public FileStatus getStatus(@NotNull VirtualFile file) {
        return this.getStatus(VcsUtil.getFilePath((VirtualFile)file));
    }

    @Nullable
    public FileStatus getStatus(@NotNull FilePath file) {
        Data data = this.myMap.get(file);
        return data != null ? data.status : null;
    }

    public void changeAdded(@NotNull Change change, AbstractVcs key) {
        this.myChanges.add(change);
        ContentRevision afterRevision = change.getAfterRevision();
        ContentRevision beforeRevision = change.getBeforeRevision();
        if (beforeRevision != null && afterRevision != null) {
            this.add(afterRevision.getFile(), change.getFileStatus(), key, beforeRevision.getRevisionNumber());
            if (!Comparing.equal((Object)beforeRevision.getFile(), (Object)afterRevision.getFile())) {
                this.add(beforeRevision.getFile(), FileStatus.DELETED, key, beforeRevision.getRevisionNumber());
            }
        } else if (afterRevision != null) {
            this.add(afterRevision.getFile(), change.getFileStatus(), key, VcsRevisionNumber.NULL);
        } else if (beforeRevision != null) {
            this.add(beforeRevision.getFile(), change.getFileStatus(), key, beforeRevision.getRevisionNumber());
        }
    }

    public void changeRemoved(@NotNull Change change) {
        this.myChanges.remove(change);
        ContentRevision afterRevision = change.getAfterRevision();
        ContentRevision beforeRevision = change.getBeforeRevision();
        if (afterRevision != null) {
            this.remove(afterRevision.getFile());
        }
        if (beforeRevision != null) {
            this.remove(beforeRevision.getFile());
        }
    }

    @NotNull
    public Set<Change> getChanges() {
        return this.myChanges;
    }

    @Nullable
    public AbstractVcs getVcsFor(@NotNull Change change) {
        AbstractVcs vcs = this.getVcsForRevision(change.getAfterRevision());
        if (vcs != null) {
            return vcs;
        }
        return this.getVcsForRevision(change.getBeforeRevision());
    }

    @Nullable
    private AbstractVcs getVcsForRevision(@Nullable ContentRevision revision) {
        if (revision != null) {
            Data data = this.myMap.get(revision.getFile());
            return data != null ? data.vcs : null;
        }
        return null;
    }

    public void getDelta(ChangeListsIndexes newIndexes, Set<? super BaseRevision> toRemove, Set<? super BaseRevision> toAdd, Set<? super BeforeAfter<BaseRevision>> toModify) {
        FilePath s;
        Map<FilePath, Data> oldMap = this.myMap;
        Map<FilePath, Data> newMap = newIndexes.myMap;
        for (Map.Entry<FilePath, Data> entry : oldMap.entrySet()) {
            s = entry.getKey();
            Data oldData = entry.getValue();
            Data newData = newMap.get(s);
            if (newData != null) {
                if (oldData.sameRevisions(newData)) continue;
                toModify.add((BeforeAfter<BaseRevision>)new BeforeAfter((Object)ChangeListsIndexes.createBaseRevision(s, oldData), (Object)ChangeListsIndexes.createBaseRevision(s, newData)));
                continue;
            }
            toRemove.add(ChangeListsIndexes.createBaseRevision(s, oldData));
        }
        for (Map.Entry<FilePath, Data> entry : newMap.entrySet()) {
            s = entry.getKey();
            Data newData = entry.getValue();
            if (oldMap.containsKey(s)) continue;
            toAdd.add(ChangeListsIndexes.createBaseRevision(s, newData));
        }
    }

    @NotNull
    public ThreeState haveChangesUnder(@NotNull FilePath dir) {
        FilePath changeCandidate = this.myAffectedPaths.ceiling(dir);
        if (changeCandidate == null) {
            return ThreeState.NO;
        }
        return FileUtil.isAncestorThreeState((String)dir.getPath(), (String)changeCandidate.getPath(), (boolean)false);
    }

    private static BaseRevision createBaseRevision(@NotNull FilePath path2, @NotNull Data data) {
        return new BaseRevision(data.vcs, data.revision, path2);
    }

    public void clear() {
        this.myMap.clear();
        this.myAffectedPaths.clear();
        this.myChanges.clear();
    }

    @NotNull
    public Set<FilePath> getAffectedPaths() {
        return Collections.unmodifiableSet(this.myMap.keySet());
    }

    private static class Data {
        @NotNull
        public final FileStatus status;
        public final AbstractVcs vcs;
        @NotNull
        public final VcsRevisionNumber revision;

        Data(@NotNull FileStatus status, AbstractVcs vcs, @NotNull VcsRevisionNumber revision) {
            this.status = status;
            this.vcs = vcs;
            this.revision = revision;
        }

        public boolean sameRevisions(@NotNull Data data) {
            return Comparing.equal((Object)this.vcs, (Object)data.vcs) && Comparing.equal((Object)this.revision, (Object)data.revision);
        }
    }
}

