/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.actions.AnnotateActionGroup;
import com.intellij.openapi.vcs.actions.ShortNameType;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowShortenNames
extends ActionGroup
implements DumbAware {
    private final AnAction[] myChildren;

    public ShowShortenNames() {
        super(VcsBundle.messagePointer((String)"annotations.short.name.type.group.names", (Object[])new Object[0]), true);
        ArrayList<SetShortNameTypeAction> kids = new ArrayList<SetShortNameTypeAction>(ShortNameType.values().length);
        for (ShortNameType type : ShortNameType.values()) {
            kids.add(new SetShortNameTypeAction(type));
        }
        this.myChildren = kids.toArray(AnAction.EMPTY_ARRAY);
    }

    public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
        return this.myChildren;
    }

    public static ShortNameType getType() {
        for (ShortNameType type : ShortNameType.values()) {
            if (!type.isSet()) continue;
            return type;
        }
        return ShortNameType.LASTNAME;
    }

    private static class SetShortNameTypeAction
    extends ToggleAction
    implements DumbAware {
        private final ShortNameType myType;

        SetShortNameTypeAction(ShortNameType type) {
            super(type.getDescription());
            this.myType = type;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            return this.myType == ShowShortenNames.getType();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean enabled) {
            if (enabled) {
                this.myType.set();
            }
            AnnotateActionGroup.revalidateMarkupInAllEditors();
        }
    }
}

