/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.ExternallyAddedFilesProcessorImpl;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ProjectConfigurationFilesProcessorImpl;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsFileListenerContextHelper;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.VcsIgnoreManager;
import com.intellij.openapi.vcs.changes.ignore.IgnoreFilesProcessorImpl;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SmartHashSet;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VcsVFSListener
implements Disposable {
    protected static final Logger LOG = Logger.getInstance(VcsVFSListener.class);
    private final ProjectLevelVcsManager myVcsManager;
    private final VcsIgnoreManager myVcsIgnoreManager;
    private final VcsFileListenerContextHelper myVcsFileListenerContextHelper;
    protected final Project myProject;
    protected final AbstractVcs myVcs;
    protected final ChangeListManager myChangeListManager;
    private final VcsShowConfirmationOption myAddOption;
    protected final VcsShowConfirmationOption myRemoveOption;
    protected final StateProcessor myProcessor = new StateProcessor();
    private final ProjectConfigurationFilesProcessorImpl myProjectConfigurationFilesProcessor;
    protected final ExternallyAddedFilesProcessorImpl myExternalFilesProcessor;
    private final List<VFileEvent> myEventsToProcess = new SmartList();

    protected VcsVFSListener(@NotNull AbstractVcs vcs) {
        this.myProject = vcs.getProject();
        this.myVcs = vcs;
        this.myChangeListManager = ChangeListManager.getInstance((Project)this.myProject);
        this.myVcsIgnoreManager = VcsIgnoreManager.getInstance((Project)this.myProject);
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
        this.myAddOption = this.myVcsManager.getStandardConfirmation(VcsConfiguration.StandardConfirmation.ADD, vcs);
        this.myRemoveOption = this.myVcsManager.getStandardConfirmation(VcsConfiguration.StandardConfirmation.REMOVE, vcs);
        this.myVcsFileListenerContextHelper = VcsFileListenerContextHelper.getInstance((Project)this.myProject);
        this.myProjectConfigurationFilesProcessor = this.createProjectConfigurationFilesProcessor();
        this.myExternalFilesProcessor = this.createExternalFilesProcessor();
    }

    @Deprecated
    protected VcsVFSListener(@NotNull Project project, @NotNull AbstractVcs vcs) {
        this(vcs);
        this.installListeners();
    }

    protected void installListeners() {
        VirtualFileManager.getInstance().addAsyncFileListener((AsyncFileListener)new MyAsyncVfsListener(), (Disposable)this);
        this.myProject.getMessageBus().connect((Disposable)this).subscribe(CommandListener.TOPIC, (Object)new MyCommandAdapter());
        this.myProjectConfigurationFilesProcessor.install();
        this.myExternalFilesProcessor.install();
        new IgnoreFilesProcessorImpl(this.myProject, this.myVcs, this).install();
    }

    public void dispose() {
    }

    protected boolean isEventAccepted(@NotNull VFileEvent event) {
        return !event.isFromRefresh() && event.getFileSystem() instanceof LocalFileSystem;
    }

    protected boolean isEventIgnored(@NotNull VFileEvent event) {
        FilePath filePath = VcsUtil.getFilePath((String)event.getPath());
        return !this.isUnderMyVcs(filePath) || this.myChangeListManager.isIgnoredFile(filePath);
    }

    protected boolean isUnderMyVcs(@Nullable VirtualFile file) {
        return file != null && (Boolean)ReadAction.compute(() -> !this.myProject.isDisposed() && this.myVcsManager.getVcsFor(file) == this.myVcs) != false;
    }

    protected boolean isUnderMyVcs(@Nullable FilePath filePath) {
        return filePath != null && (Boolean)ReadAction.compute(() -> !this.myProject.isDisposed() && this.myVcsManager.getVcsFor(filePath) == this.myVcs) != false;
    }

    protected void executeAdd() {
        Map<VirtualFile, VirtualFile> copyFromMap;
        List<VirtualFile> addedFiles = this.myProcessor.acquireAddedFiles();
        LOG.debug("executeAdd. addedFiles: ", new Object[]{addedFiles});
        addedFiles.removeIf(arg_0 -> ((VcsFileListenerContextHelper)this.myVcsFileListenerContextHelper).isAdditionIgnored(arg_0));
        addedFiles.removeIf(arg_0 -> ((VcsIgnoreManager)this.myVcsIgnoreManager).isPotentiallyIgnoredFile(arg_0));
        Map<VirtualFile, VirtualFile> map2 = copyFromMap = this.isFileCopyingFromTrackingSupported() ? this.myProcessor.acquireCopiedFiles() : Collections.emptyMap();
        if (!addedFiles.isEmpty()) {
            this.executeAdd(addedFiles, copyFromMap);
        }
    }

    protected void executeAdd(@NotNull List<VirtualFile> addedFiles, @NotNull Map<VirtualFile, VirtualFile> copyFromMap) {
        VcsShowConfirmationOption.Value addOption = this.myAddOption.getValue();
        LOG.debug("executeAdd. add-option: ", new Object[]{addOption, ", files to add: ", addedFiles});
        if (addOption == VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY) {
            return;
        }
        addedFiles = this.myProjectConfigurationFilesProcessor.filterNotProjectConfigurationFiles(addedFiles);
        if (addOption == VcsShowConfirmationOption.Value.DO_ACTION_SILENTLY) {
            this.performAdding(addedFiles, copyFromMap);
        } else {
            AbstractVcsHelper helper = AbstractVcsHelper.getInstance((Project)this.myProject);
            Collection filesToProcess = helper.selectFilesToProcess(addedFiles, this.getAddTitle(), null, this.getSingleFileAddTitle(), this.getSingleFileAddPromptTemplate(), this.myAddOption);
            if (filesToProcess != null) {
                this.performAdding(new ArrayList<VirtualFile>(filesToProcess), copyFromMap);
            }
        }
    }

    protected void executeAddWithoutIgnores(@NotNull List<VirtualFile> addedFiles, @NotNull Map<VirtualFile, VirtualFile> copyFromMap, @NotNull ExecuteAddCallback executeAddCallback) {
        executeAddCallback.executeAdd(addedFiles, copyFromMap);
    }

    private void executeMoveRename() {
        List<MovedFileInfo> movedFiles = this.myProcessor.acquireMovedFiles();
        LOG.debug("executeMoveRename ", new Object[]{movedFiles});
        if (!movedFiles.isEmpty()) {
            this.performMoveRename(movedFiles);
        }
    }

    protected void executeDelete() {
        Collection<FilePath> filePaths;
        AllDeletedFiles allFiles = this.myProcessor.acquireAllDeletedFiles();
        List<FilePath> filesToDelete = allFiles.deletedWithoutConfirmFiles;
        List<FilePath> deletedFiles = allFiles.deletedFiles;
        filesToDelete.removeIf(arg_0 -> ((VcsFileListenerContextHelper)this.myVcsFileListenerContextHelper).isDeletionIgnored(arg_0));
        deletedFiles.removeIf(arg_0 -> ((VcsFileListenerContextHelper)this.myVcsFileListenerContextHelper).isDeletionIgnored(arg_0));
        VcsShowConfirmationOption.Value removeOption = this.myRemoveOption.getValue();
        if (removeOption == VcsShowConfirmationOption.Value.DO_ACTION_SILENTLY) {
            filesToDelete.addAll(deletedFiles);
        } else if (removeOption == VcsShowConfirmationOption.Value.SHOW_CONFIRMATION && !deletedFiles.isEmpty() && (filePaths = this.selectFilePathsToDelete(deletedFiles)) != null) {
            filesToDelete.addAll(filePaths);
        }
        if (!filesToDelete.isEmpty()) {
            this.performDeletion(filesToDelete);
        }
    }

    protected void processMovedFile(@NotNull VirtualFile file, @NotNull String newParentPath, @NotNull String newName) {
        this.myProcessor.processMovedFile(file, newParentPath, newName);
    }

    protected void saveUnsavedVcsIgnoreFiles() {
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        Set ignoreFileNames = VcsUtil.getVcsIgnoreFileNames((Project)this.myProject);
        for (Document document : fileDocumentManager.getUnsavedDocuments()) {
            VirtualFile file = fileDocumentManager.getFile(document);
            if (file == null || !ignoreFileNames.contains(file.getName())) continue;
            ApplicationManager.getApplication().invokeAndWait(() -> fileDocumentManager.saveDocument(document));
        }
    }

    @Nullable
    protected Collection<FilePath> selectFilePathsToDelete(@NotNull List<FilePath> deletedFiles) {
        AbstractVcsHelper helper = AbstractVcsHelper.getInstance((Project)this.myProject);
        Ref ref = Ref.create();
        ApplicationManager.getApplication().invokeAndWait(() -> ref.set((Object)helper.selectFilePathsToProcess(deletedFiles, this.getDeleteTitle(), null, this.getSingleFileDeleteTitle(), this.getSingleFileDeletePromptTemplate(), this.myRemoveOption)));
        return (Collection)ref.get();
    }

    protected void beforeContentsChange(@NotNull VFileContentChangeEvent event) {
    }

    private void addFileToMove(@NotNull VirtualFile file, @NotNull String newParentPath, @NotNull String newName) {
        if (file.isDirectory() && !file.is(VFileProperty.SYMLINK) && !this.isDirectoryVersioningSupported()) {
            VirtualFile[] children = file.getChildren();
            if (children != null) {
                for (VirtualFile child : children) {
                    ProgressManager.checkCanceled();
                    this.addFileToMove(child, newParentPath + "/" + newName, child.getName());
                }
            }
        } else {
            this.processMovedFile(file, newParentPath, newName);
        }
    }

    protected boolean filterOutUnknownFiles() {
        return true;
    }

    @NotNull
    protected VcsDeleteType needConfirmDeletion(@NotNull VirtualFile file) {
        return VcsDeleteType.CONFIRM;
    }

    @NotNull
    protected abstract String getAddTitle();

    @NotNull
    protected abstract String getSingleFileAddTitle();

    @NotNull
    protected abstract String getSingleFileAddPromptTemplate();

    @NotNull
    protected abstract String getDeleteTitle();

    protected abstract String getSingleFileDeleteTitle();

    protected abstract String getSingleFileDeletePromptTemplate();

    protected abstract void performAdding(@NotNull Collection<VirtualFile> var1, @NotNull Map<VirtualFile, VirtualFile> var2);

    protected abstract void performDeletion(@NotNull List<FilePath> var1);

    protected abstract void performMoveRename(@NotNull List<MovedFileInfo> var1);

    protected abstract boolean isDirectoryVersioningSupported();

    protected boolean isRecursiveDeleteSupported() {
        return false;
    }

    protected boolean isFileCopyingFromTrackingSupported() {
        return true;
    }

    private ExternallyAddedFilesProcessorImpl createExternalFilesProcessor() {
        return new ExternallyAddedFilesProcessorImpl(this.myProject, this, this.myVcs, (Function1<? super Collection<? extends VirtualFile>, Unit>)((Function1)files -> {
            this.performAdding((Collection<VirtualFile>)files, Collections.emptyMap());
            return Unit.INSTANCE;
        }));
    }

    private ProjectConfigurationFilesProcessorImpl createProjectConfigurationFilesProcessor() {
        return new ProjectConfigurationFilesProcessorImpl(this.myProject, this, this.myVcs.getDisplayName(), (Function1<? super Collection<? extends VirtualFile>, Unit>)((Function1)files -> {
            this.performAdding((Collection<VirtualFile>)files, Collections.emptyMap());
            return Unit.INSTANCE;
        }));
    }

    private class MyCommandAdapter
    implements CommandListener {
        private MyCommandAdapter() {
        }

        public void commandFinished(@NotNull CommandEvent event) {
            if (VcsVFSListener.this.myProject != event.getProject()) {
                return;
            }
            List events = ContainerUtil.copyList((List)VcsVFSListener.this.myEventsToProcess);
            VcsVFSListener.this.myEventsToProcess.clear();
            if (events.isEmpty() && !VcsVFSListener.this.myProcessor.isAnythingToProcess()) {
                return;
            }
            ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> VcsVFSListener.this.myProcessor.process(events), VcsBundle.message((String)"progress.title.version.control.processing.changed.files", (Object[])new Object[0]), true, VcsVFSListener.this.myProject);
        }
    }

    private class MyAsyncVfsListener
    implements AsyncFileListener {
        private MyAsyncVfsListener() {
        }

        private boolean isBeforeEvent(@NotNull VFileEvent event) {
            return event instanceof VFileContentChangeEvent || event instanceof VFileDeleteEvent || event instanceof VFileMoveEvent || event instanceof VFilePropertyChangeEvent;
        }

        private boolean isAfterEvent(@NotNull VFileEvent event) {
            return event instanceof VFileCreateEvent || event instanceof VFileCopyEvent || event instanceof VFileMoveEvent;
        }

        @Nullable
        public AsyncFileListener.ChangeApplier prepareChange(@NotNull List<? extends VFileEvent> events) {
            final ArrayList<VFileEvent> beforeEvents = new ArrayList<VFileEvent>();
            final ArrayList<VFileEvent> afterEvents = new ArrayList<VFileEvent>();
            for (VFileEvent vFileEvent : events) {
                ProgressManager.checkCanceled();
                if (vFileEvent instanceof VFileContentChangeEvent) {
                    VirtualFile file = Objects.requireNonNull(vFileEvent.getFile());
                    if (!VcsVFSListener.this.isUnderMyVcs(file)) continue;
                    beforeEvents.add(vFileEvent);
                    continue;
                }
                if (!VcsVFSListener.this.isEventAccepted(vFileEvent)) continue;
                if (this.isBeforeEvent(vFileEvent)) {
                    beforeEvents.add(vFileEvent);
                }
                if (!this.isAfterEvent(vFileEvent)) continue;
                afterEvents.add(vFileEvent);
            }
            return beforeEvents.isEmpty() && afterEvents.isEmpty() ? null : new AsyncFileListener.ChangeApplier(){

                public void beforeVfsChange() {
                    for (VFileEvent event : beforeEvents) {
                        if (event instanceof VFileContentChangeEvent) {
                            VcsVFSListener.this.beforeContentsChange((VFileContentChangeEvent)event);
                        }
                        if (VcsVFSListener.this.isEventIgnored(event)) continue;
                        if (event instanceof VFileDeleteEvent) {
                            VcsVFSListener.this.myProcessor.processDeletedFile(((VFileDeleteEvent)event).getFile());
                            continue;
                        }
                        if (event instanceof VFileMoveEvent) {
                            VcsVFSListener.this.myProcessor.processBeforeFileMovement((VFileMoveEvent)event);
                            continue;
                        }
                        if (!(event instanceof VFilePropertyChangeEvent)) continue;
                        VcsVFSListener.this.myProcessor.processBeforePropertyChange((VFilePropertyChangeEvent)event);
                    }
                }

                public void afterVfsChange() {
                    VcsVFSListener.this.myEventsToProcess.addAll(afterEvents);
                }
            };
        }
    }

    @FunctionalInterface
    protected static interface ExecuteAddCallback {
        public void executeAdd(@NotNull List<VirtualFile> var1, @NotNull Map<VirtualFile, VirtualFile> var2);
    }

    protected final class StateProcessor {
        private final Set<VirtualFile> myAddedFiles = new SmartHashSet();
        private final Map<VirtualFile, VirtualFile> myCopyFromMap = new HashMap<VirtualFile, VirtualFile>();
        private final Set<FilePath> myDeletedFiles = new SmartHashSet();
        private final Set<FilePath> myDeletedWithoutConfirmFiles = new SmartHashSet();
        private final Set<MovedFileInfo> myMovedFiles = new SmartHashSet();
        private final List<VcsException> myExceptions = new SmartList();
        private final ReentrantReadWriteLock PROCESSING_LOCK = new ReentrantReadWriteLock();

        protected StateProcessor() {
        }

        public boolean addException(@NotNull VcsException exception) {
            return (Boolean)ConcurrencyUtil.withLock((Lock)this.PROCESSING_LOCK.writeLock(), () -> this.myExceptions.add(exception));
        }

        @NotNull
        public List<VcsException> acquireExceptions() {
            return this.acquireListUnderLock(this.myExceptions);
        }

        @NotNull
        public List<VirtualFile> acquireAddedFiles() {
            return this.acquireListUnderLock(this.myAddedFiles);
        }

        @NotNull
        public List<MovedFileInfo> acquireMovedFiles() {
            return this.acquireListUnderLock(this.myMovedFiles);
        }

        @NotNull
        public AllDeletedFiles acquireAllDeletedFiles() {
            return (AllDeletedFiles)ConcurrencyUtil.withLock((Lock)this.PROCESSING_LOCK.writeLock(), () -> {
                ArrayList<FilePath> deletedWithoutConfirmFiles = new ArrayList<FilePath>(this.myDeletedWithoutConfirmFiles);
                ArrayList<FilePath> deletedFiles = new ArrayList<FilePath>(this.myDeletedFiles);
                this.myDeletedWithoutConfirmFiles.clear();
                this.myDeletedFiles.clear();
                return new AllDeletedFiles(deletedFiles, deletedWithoutConfirmFiles);
            });
        }

        @NotNull
        private <T> List<T> acquireListUnderLock(@NotNull Collection<T> files) {
            return (List)ConcurrencyUtil.withLock((Lock)this.PROCESSING_LOCK.writeLock(), () -> {
                ArrayList copiedFiles = new ArrayList(files);
                files.clear();
                return copiedFiles;
            });
        }

        @NotNull
        public Map<VirtualFile, VirtualFile> acquireCopiedFiles() {
            return (Map)ConcurrencyUtil.withLock((Lock)this.PROCESSING_LOCK.writeLock(), () -> {
                HashMap<VirtualFile, VirtualFile> copyFromMap = new HashMap<VirtualFile, VirtualFile>(this.myCopyFromMap);
                this.myCopyFromMap.clear();
                return copyFromMap;
            });
        }

        private void checkMovedAddedSourceBack() {
            if (this.myAddedFiles.isEmpty() || this.myMovedFiles.isEmpty()) {
                return;
            }
            HashMap<String, VirtualFile> addedPaths = new HashMap<String, VirtualFile>(this.myAddedFiles.size());
            for (VirtualFile file : this.myAddedFiles) {
                addedPaths.put(file.getPath(), file);
            }
            Iterator<MovedFileInfo> iterator = this.myMovedFiles.iterator();
            while (iterator.hasNext()) {
                MovedFileInfo movedFile = iterator.next();
                VirtualFile oldAdded = (VirtualFile)addedPaths.get(movedFile.myOldPath);
                if (oldAdded == null) continue;
                iterator.remove();
                this.myAddedFiles.remove(oldAdded);
                this.myAddedFiles.add(movedFile.myFile);
                if (!VcsVFSListener.this.isFileCopyingFromTrackingSupported()) continue;
                this.myCopyFromMap.put(oldAdded, movedFile.myFile);
            }
        }

        private void doNotDeleteAddedCopiedOrMovedFiles() {
            if (this.myDeletedFiles.isEmpty() && this.myDeletedWithoutConfirmFiles.isEmpty()) {
                return;
            }
            HashSet<String> copiedAddedMoved = new HashSet<String>();
            for (VirtualFile file : this.myCopyFromMap.keySet()) {
                copiedAddedMoved.add(file.getPath());
            }
            for (VirtualFile file : this.myAddedFiles) {
                copiedAddedMoved.add(file.getPath());
            }
            for (MovedFileInfo movedFileInfo : this.myMovedFiles) {
                copiedAddedMoved.add(movedFileInfo.myNewPath);
            }
            this.myDeletedFiles.removeIf(path2 -> copiedAddedMoved.contains(path2.getPath()));
            this.myDeletedWithoutConfirmFiles.removeIf(path2 -> copiedAddedMoved.contains(path2.getPath()));
        }

        private boolean isAnythingToProcess() {
            return (Boolean)ConcurrencyUtil.withLock((Lock)this.PROCESSING_LOCK.readLock(), () -> !this.myAddedFiles.isEmpty() || !this.myDeletedFiles.isEmpty() || !this.myDeletedWithoutConfirmFiles.isEmpty() || !this.myMovedFiles.isEmpty());
        }

        private void process(@NotNull List<VFileEvent> events) {
            this.processEvents(events);
            ConcurrencyUtil.withLock((Lock)this.PROCESSING_LOCK.writeLock(), () -> {
                this.doNotDeleteAddedCopiedOrMovedFiles();
                this.checkMovedAddedSourceBack();
            });
            VcsVFSListener.this.executeAdd();
            VcsVFSListener.this.executeDelete();
            VcsVFSListener.this.executeMoveRename();
            List<VcsException> exceptions = this.acquireExceptions();
            if (!exceptions.isEmpty()) {
                AbstractVcsHelper.getInstance((Project)VcsVFSListener.this.myProject).showErrors(exceptions, VcsVFSListener.this.myVcs.getDisplayName() + " operations errors");
            }
        }

        private void processFileCreated(@NotNull VFileCreateEvent event) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("fileCreated: ", new Object[]{event.getFile()});
            }
            if (VcsVFSListener.this.isDirectoryVersioningSupported() || !event.isDirectory()) {
                VirtualFile file = event.getFile();
                if (file == null) {
                    return;
                }
                LOG.debug("Adding [", new Object[]{file, "] to added files"});
                ConcurrencyUtil.withLock((Lock)this.PROCESSING_LOCK.writeLock(), () -> this.myAddedFiles.add(file));
            }
        }

        private void processFileMoved(@NotNull VFileMoveEvent event) {
            VirtualFile file = event.getFile();
            VirtualFile oldParent = event.getOldParent();
            if (!VcsVFSListener.this.isUnderMyVcs(oldParent)) {
                ConcurrencyUtil.withLock((Lock)this.PROCESSING_LOCK.writeLock(), () -> this.myAddedFiles.add(file));
            }
        }

        private void processFileCopied(@NotNull VFileCopyEvent event) {
            VirtualFile newFile = event.getNewParent().findChild(event.getNewChildName());
            if (newFile == null || VcsVFSListener.this.myChangeListManager.isIgnoredFile(newFile)) {
                return;
            }
            VirtualFile originalFile = event.getFile();
            ConcurrencyUtil.withLock((Lock)this.PROCESSING_LOCK.writeLock(), () -> {
                if (VcsVFSListener.this.isFileCopyingFromTrackingSupported() && VcsVFSListener.this.isUnderMyVcs(originalFile)) {
                    this.myAddedFiles.add(newFile);
                    this.myCopyFromMap.put(newFile, originalFile);
                } else {
                    this.myAddedFiles.add(newFile);
                }
            });
        }

        private void processDeletedFile(@NotNull VirtualFile file) {
            if (file.isDirectory() && file instanceof NewVirtualFile && !VcsVFSListener.this.isDirectoryVersioningSupported() && !VcsVFSListener.this.isRecursiveDeleteSupported()) {
                for (VirtualFile child : ((NewVirtualFile)file).getCachedChildren()) {
                    ProgressManager.checkCanceled();
                    if (VcsVFSListener.this.myChangeListManager.isIgnoredFile(child)) continue;
                    this.processDeletedFile(child);
                }
            } else {
                VcsDeleteType type = VcsVFSListener.this.needConfirmDeletion(file);
                if (type == VcsDeleteType.IGNORE) {
                    return;
                }
                FilePath filePath = VcsUtil.getFilePath((VirtualFile)file);
                ConcurrencyUtil.withLock((Lock)this.PROCESSING_LOCK.writeLock(), () -> {
                    if (type == VcsDeleteType.CONFIRM) {
                        this.myDeletedFiles.add(filePath);
                    } else if (type == VcsDeleteType.SILENT) {
                        this.myDeletedWithoutConfirmFiles.add(filePath);
                    }
                });
            }
        }

        private void processMovedFile(@NotNull VirtualFile file, @NotNull String newParentPath, @NotNull String newName) {
            FileStatus status = VcsVFSListener.this.myChangeListManager.getStatus(file);
            LOG.debug("Checking moved file ", new Object[]{file, "; status=", status});
            String newPath = newParentPath + "/" + newName;
            ConcurrencyUtil.withLock((Lock)this.PROCESSING_LOCK.writeLock(), () -> {
                if (!(VcsVFSListener.this.filterOutUnknownFiles() && status == FileStatus.UNKNOWN || status == FileStatus.IGNORED)) {
                    MovedFileInfo existingMovedFile = (MovedFileInfo)ContainerUtil.find(this.myMovedFiles, info -> Comparing.equal((Object)((MovedFileInfo)info).myFile, (Object)file));
                    if (existingMovedFile != null) {
                        LOG.debug("Reusing existing moved file [" + file + "] with new path [" + newPath + "]");
                        existingMovedFile.myNewPath = newPath;
                    } else {
                        LOG.debug("Registered moved file ", new Object[]{file});
                        this.myMovedFiles.add(new MovedFileInfo(file, newPath));
                    }
                } else {
                    this.myDeletedFiles.remove(VcsUtil.getFilePath((String)newPath));
                }
            });
        }

        private void processBeforeFileMovement(@NotNull VFileMoveEvent event) {
            VirtualFile file = event.getFile();
            if (VcsVFSListener.this.isUnderMyVcs(event.getNewParent())) {
                LOG.debug("beforeFileMovement ", new Object[]{event, " into same vcs"});
                VcsVFSListener.this.addFileToMove(file, event.getNewParent().getPath(), file.getName());
            } else {
                LOG.debug("beforeFileMovement ", new Object[]{event, " into different vcs"});
                VcsVFSListener.this.myProcessor.processDeletedFile(file);
            }
        }

        private void processBeforePropertyChange(@NotNull VFilePropertyChangeEvent event) {
            if (event.isRename()) {
                LOG.debug("before file rename ", new Object[]{event});
                String newName = (String)event.getNewValue();
                VirtualFile file = event.getFile();
                VirtualFile parent = file.getParent();
                if (parent != null) {
                    VcsVFSListener.this.addFileToMove(file, parent.getPath(), newName);
                }
            }
        }

        private void processEvents(@NotNull List<VFileEvent> events) {
            for (VFileEvent event : events) {
                ProgressManager.checkCanceled();
                if (VcsVFSListener.this.isEventIgnored(event)) continue;
                if (event instanceof VFileCreateEvent) {
                    this.processFileCreated((VFileCreateEvent)event);
                    continue;
                }
                if (event instanceof VFileCopyEvent) {
                    this.processFileCopied((VFileCopyEvent)event);
                    continue;
                }
                if (!(event instanceof VFileMoveEvent)) continue;
                this.processFileMoved((VFileMoveEvent)event);
            }
        }
    }

    protected static enum VcsDeleteType {
        SILENT,
        CONFIRM,
        IGNORE;

    }

    protected static class AllDeletedFiles {
        public final List<FilePath> deletedFiles;
        public final List<FilePath> deletedWithoutConfirmFiles;

        public AllDeletedFiles(@NotNull List<FilePath> deletedFiles, @NotNull List<FilePath> deletedWithoutConfirmFiles) {
            this.deletedFiles = deletedFiles;
            this.deletedWithoutConfirmFiles = deletedWithoutConfirmFiles;
        }
    }

    protected static class MovedFileInfo {
        @NotNull
        public final String myOldPath;
        @NotNull
        public String myNewPath;
        @NotNull
        private final VirtualFile myFile;

        MovedFileInfo(@NotNull VirtualFile file, @NotNull String newPath) {
            this.myOldPath = file.getPath();
            this.myNewPath = newPath;
            this.myFile = file;
        }

        public String toString() {
            return String.format("MovedFileInfo{[%s] -> [%s]}", this.myOldPath, this.myNewPath);
        }
    }
}

